/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.integration.ApiTester;
import com.twitter.clientlib.model.GenericMultipleUsersLookupResponse;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.MultiUserLookupResponse;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.SingleUserLookupResponse;
import com.twitter.clientlib.model.User;
import com.twitter.clientlib.model.UsersBlockingMutationResponse;
import com.twitter.clientlib.model.UsersFollowingCreateResponse;
import com.twitter.clientlib.model.UsersFollowingDeleteResponse;
import com.twitter.clientlib.model.UsersFollowingLookupResponse;
import com.twitter.clientlib.model.UsersIdBlockRequest;
import com.twitter.clientlib.model.UsersIdFollowRequest;
import com.twitter.clientlib.model.UsersIdMuteRequest;
import com.twitter.clientlib.model.UsersMutingMutationResponse;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiUserTester
extends ApiTester {
    private final String popularUsername = "TheRock";
    private final String usernameNotFound = "cprttfdgq";
    private final List<String> usersnames = Arrays.asList("TheRock");
    private final List<String> usersnamesNotFounds = Arrays.asList("cprttfdgq");

    @BeforeAll
    public void init() {
        this.initApiInstance();
    }

    @Test
    public void findUserByIdTest() throws ApiException {
        SingleUserLookupResponse result = this.apiInstance.users().findUserById(this.userId, null, this.tweetFields, this.userFields);
        this.checkErrors(false, result.getErrors());
        this.checkUserData(result.getData());
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void findUserByIdErrorTest() throws ApiException {
        SingleUserLookupResponse result = this.apiInstance.users().findUserById("9999999999999", null, this.tweetFields, this.userFields);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void findUsersByIdTest() throws ApiException {
        MultiUserLookupResponse result = this.apiInstance.users().findUsersById(this.usersIds, null, this.tweetFields, this.userFields);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void findUsersByIdErrorTest() throws ApiException {
        MultiUserLookupResponse result = this.apiInstance.users().findUsersById(this.usersIdsNotFound, null, this.tweetFields, this.userFields);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "ids");
    }

    @Test
    public void findUserByUsernameTest() throws ApiException {
        SingleUserLookupResponse result = this.apiInstance.users().findUserByUsername("TheRock", null, this.tweetFields, this.userFields);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData(result.getData());
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void findUserByUsernameFoundTest() throws ApiException {
        SingleUserLookupResponse result = this.apiInstance.users().findUserByUsername("cprttfdgq", null, this.tweetFields, this.userFields);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "cprttfdgq", "Not Found Error", "username");
    }

    @Test
    public void findUsersByUsernameTest() throws ApiException {
        MultiUserLookupResponse result = this.apiInstance.users().findUsersByUsername(this.usersnames, null, this.tweetFields, this.userFields);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void findUsersByUsernameNotFoundTest() throws ApiException {
        MultiUserLookupResponse result = this.apiInstance.users().findUsersByUsername(this.usersnamesNotFounds, null, this.tweetFields, this.userFields);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "cprttfdgq", "Not Found Error", "usernames");
    }

    @Test
    public void findMyUserTest() throws ApiException {
        SingleUserLookupResponse result = this.apiInstance.users().findMyUser(null, this.tweetFields, this.userFields);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData(result.getData());
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void usersIdFollowingTest() throws ApiException {
        UsersFollowingLookupResponse result = this.apiInstance.users().usersIdFollowing("250831586", this.maxResults, null);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void usersIdFollowingNotFoundTest() throws ApiException {
        UsersFollowingLookupResponse result = this.apiInstance.users().usersIdFollowing("9999999999999", this.maxResults, null);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
        Assertions.assertNull((Object)result.getMeta());
    }

    @Test
    public void usersIdFollowersTest() throws ApiException {
        GenericMultipleUsersLookupResponse result = this.apiInstance.users().usersIdFollowers("250831586", this.maxResults, null);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void usersIdFollowersNotFoundTest() throws ApiException {
        GenericMultipleUsersLookupResponse result = this.apiInstance.users().usersIdFollowers("9999999999999", this.maxResults, null);
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
        Assertions.assertNull((Object)result.getMeta());
    }

    @Test
    public void usersIdFollowTest() throws ApiException {
        UsersIdFollowRequest request = new UsersIdFollowRequest();
        request.setTargetUserId("250831586");
        UsersFollowingCreateResponse result = this.apiInstance.users().usersIdFollow(request, this.userId);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getFollowing());
        Assertions.assertFalse((boolean)result.getData().getPendingFollow());
    }

    @Test
    public void usersIdFollowFollowingNotFoundTest() throws ApiException {
        UsersIdFollowRequest request = new UsersIdFollowRequest();
        request.setTargetUserId("9999999999999");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdFollow(request, this.userId));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot follow an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdFollowFollowerNotFoundTest() throws ApiException {
        UsersIdFollowRequest request = new UsersIdFollowRequest();
        request.setTargetUserId("250831586");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdFollow(request, "9999999999999"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnfollowTest() throws ApiException {
        UsersFollowingDeleteResponse result = this.apiInstance.users().usersIdUnfollow(this.userId, "250831586");
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getFollowing());
    }

    @Test
    public void usersIdUnfollowFollowingNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnfollow(this.userId, "9999999999999"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot unfollow an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnfollowFollowerNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnfollow("9999999999999", "250831586"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `source_user_id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdBlockingTest() throws ApiException {
        GenericMultipleUsersLookupResponse result = this.apiInstance.users().usersIdBlocking(this.userId, this.maxResults, null);
        this.checkErrors(false, result.getErrors());
        if (result.getData() != null) {
            this.checkUserData((User)result.getData().get(0));
            Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
            Assertions.assertNotNull((Object)result.getIncludes());
        } else {
            Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
            Assertions.assertNull((Object)result.getIncludes());
        }
        Assertions.assertNotNull((Object)result.getMeta());
    }

    @Test
    public void usersIdBlockingNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdBlocking("9999999999999", this.maxResults, null));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdBlockTest() throws ApiException {
        UsersIdBlockRequest request = new UsersIdBlockRequest();
        request.setTargetUserId("250831586");
        UsersBlockingMutationResponse result = this.apiInstance.users().usersIdBlock(request, this.userId);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getBlocking());
    }

    @Test
    public void usersIdBlockBlockedNotFoundTest() throws ApiException {
        UsersIdBlockRequest request = new UsersIdBlockRequest();
        request.setTargetUserId("9999999999999");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdBlock(request, this.userId));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot block an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdBlockBlockingNotFoundTest() throws ApiException {
        UsersIdBlockRequest request = new UsersIdBlockRequest();
        request.setTargetUserId("250831586");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdBlock(request, "9999999999999"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnblockTest() throws ApiException {
        UsersIdBlockRequest request = new UsersIdBlockRequest();
        request.setTargetUserId("250831586");
        UsersBlockingMutationResponse result = this.apiInstance.users().usersIdUnblock(this.userId, "250831586");
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getBlocking());
    }

    @Test
    public void usersIdUnblockBlockedNotFoundTest() throws ApiException {
        UsersIdBlockRequest request = new UsersIdBlockRequest();
        request.setTargetUserId("9999999999999");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnblock(this.userId, "9999999999999"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot unblock an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnblockBlockingNotFoundTest() throws ApiException {
        UsersIdBlockRequest request = new UsersIdBlockRequest();
        request.setTargetUserId("250831586");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnblock("9999999999999", "250831586"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `source_user_id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdMutingTest() throws ApiException {
        GenericMultipleUsersLookupResponse result = this.apiInstance.users().usersIdMuting(this.userId, this.maxResults, null);
        this.checkErrors(false, result.getErrors());
        if (result.getData() != null) {
            this.checkUserData((User)result.getData().get(0));
            Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
            Assertions.assertNotNull((Object)result.getIncludes());
        } else {
            Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
            Assertions.assertNull((Object)result.getIncludes());
        }
        Assertions.assertNotNull((Object)result.getMeta());
    }

    @Test
    public void usersIdMutingNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdMuting("9999999999999", this.maxResults, null));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdMuteTest() throws ApiException {
        UsersIdMuteRequest request = new UsersIdMuteRequest();
        request.setTargetUserId("250831586");
        UsersMutingMutationResponse result = this.apiInstance.users().usersIdMute(request, this.userId);
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getMuting());
    }

    @Test
    public void usersIdMuteMutedNotFoundTest() throws ApiException {
        UsersIdMuteRequest request = new UsersIdMuteRequest();
        request.setTargetUserId("9999999999999");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdMute(request, this.userId));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot mute an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdMuteMutingNotFoundTest() throws ApiException {
        UsersIdMuteRequest request = new UsersIdMuteRequest();
        request.setTargetUserId("250831586");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdMute(request, "9999999999999"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnmuteTest() throws ApiException {
        UsersMutingMutationResponse result = this.apiInstance.users().usersIdUnmute(this.userId, "250831586");
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getMuting());
    }

    @Test
    public void usersIdUnmuteMutedNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnmute(this.userId, "9999999999999"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot unmute an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnmuteMutingNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnmute("9999999999999", "250831586"));
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `source_user_id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }
}

