/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.model.CashtagEntity;
import com.twitter.clientlib.model.FullTextEntitiesAnnotations;
import com.twitter.clientlib.model.HashtagEntity;
import com.twitter.clientlib.model.MentionEntity;
import com.twitter.clientlib.model.UrlEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.twitter.clientlib.JSON;

/**
 * FullTextEntities
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class FullTextEntities {
  public static final String SERIALIZED_NAME_ANNOTATIONS = "annotations";
  @SerializedName(SERIALIZED_NAME_ANNOTATIONS)
  private List<FullTextEntitiesAnnotations> annotations = null;

  public static final String SERIALIZED_NAME_CASHTAGS = "cashtags";
  @SerializedName(SERIALIZED_NAME_CASHTAGS)
  private List<CashtagEntity> cashtags = null;

  public static final String SERIALIZED_NAME_HASHTAGS = "hashtags";
  @SerializedName(SERIALIZED_NAME_HASHTAGS)
  private List<HashtagEntity> hashtags = null;

  public static final String SERIALIZED_NAME_MENTIONS = "mentions";
  @SerializedName(SERIALIZED_NAME_MENTIONS)
  private List<MentionEntity> mentions = null;

  public static final String SERIALIZED_NAME_URLS = "urls";
  @SerializedName(SERIALIZED_NAME_URLS)
  private List<UrlEntity> urls = null;

  public FullTextEntities() { 
  }

  public FullTextEntities annotations(List<FullTextEntitiesAnnotations> annotations) {
    
    this.annotations = annotations;
    return this;
  }

  public FullTextEntities addAnnotationsItem(FullTextEntitiesAnnotations annotationsItem) {
    if (this.annotations == null) {
      this.annotations = new ArrayList<>();
    }
    this.annotations.add(annotationsItem);
    return this;
  }

   /**
   * Get annotations
   * @return annotations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<FullTextEntitiesAnnotations> getAnnotations() {
    return annotations;
  }


  public void setAnnotations(List<FullTextEntitiesAnnotations> annotations) {
    this.annotations = annotations;
  }


  public FullTextEntities cashtags(List<CashtagEntity> cashtags) {
    
    this.cashtags = cashtags;
    return this;
  }

  public FullTextEntities addCashtagsItem(CashtagEntity cashtagsItem) {
    if (this.cashtags == null) {
      this.cashtags = new ArrayList<>();
    }
    this.cashtags.add(cashtagsItem);
    return this;
  }

   /**
   * Get cashtags
   * @return cashtags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<CashtagEntity> getCashtags() {
    return cashtags;
  }


  public void setCashtags(List<CashtagEntity> cashtags) {
    this.cashtags = cashtags;
  }


  public FullTextEntities hashtags(List<HashtagEntity> hashtags) {
    
    this.hashtags = hashtags;
    return this;
  }

  public FullTextEntities addHashtagsItem(HashtagEntity hashtagsItem) {
    if (this.hashtags == null) {
      this.hashtags = new ArrayList<>();
    }
    this.hashtags.add(hashtagsItem);
    return this;
  }

   /**
   * Get hashtags
   * @return hashtags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<HashtagEntity> getHashtags() {
    return hashtags;
  }


  public void setHashtags(List<HashtagEntity> hashtags) {
    this.hashtags = hashtags;
  }


  public FullTextEntities mentions(List<MentionEntity> mentions) {
    
    this.mentions = mentions;
    return this;
  }

  public FullTextEntities addMentionsItem(MentionEntity mentionsItem) {
    if (this.mentions == null) {
      this.mentions = new ArrayList<>();
    }
    this.mentions.add(mentionsItem);
    return this;
  }

   /**
   * Get mentions
   * @return mentions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<MentionEntity> getMentions() {
    return mentions;
  }


  public void setMentions(List<MentionEntity> mentions) {
    this.mentions = mentions;
  }


  public FullTextEntities urls(List<UrlEntity> urls) {
    
    this.urls = urls;
    return this;
  }

  public FullTextEntities addUrlsItem(UrlEntity urlsItem) {
    if (this.urls == null) {
      this.urls = new ArrayList<>();
    }
    this.urls.add(urlsItem);
    return this;
  }

   /**
   * Get urls
   * @return urls
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<UrlEntity> getUrls() {
    return urls;
  }


  public void setUrls(List<UrlEntity> urls) {
    this.urls = urls;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FullTextEntities fullTextEntities = (FullTextEntities) o;
    return Objects.equals(this.annotations, fullTextEntities.annotations) &&
        Objects.equals(this.cashtags, fullTextEntities.cashtags) &&
        Objects.equals(this.hashtags, fullTextEntities.hashtags) &&
        Objects.equals(this.mentions, fullTextEntities.mentions) &&
        Objects.equals(this.urls, fullTextEntities.urls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(annotations, cashtags, hashtags, mentions, urls);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FullTextEntities {\n");
    sb.append("    annotations: ").append(toIndentedString(annotations)).append("\n");
    sb.append("    cashtags: ").append(toIndentedString(cashtags)).append("\n");
    sb.append("    hashtags: ").append(toIndentedString(hashtags)).append("\n");
    sb.append("    mentions: ").append(toIndentedString(mentions)).append("\n");
    sb.append("    urls: ").append(toIndentedString(urls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("annotations");
    openapiFields.add("cashtags");
    openapiFields.add("hashtags");
    openapiFields.add("mentions");
    openapiFields.add("urls");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to FullTextEntities
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
     // if (jsonObj == null) {
     //   if (FullTextEntities.openapiRequiredFields.isEmpty()) {
     //     return;
     //   } else { // has required fields
     //     throw new IllegalArgumentException(String.format("The required field(s) %s in FullTextEntities is not found in the empty JSON string", FullTextEntities.openapiRequiredFields.toString()));
     //   }
     // }

      JsonArray jsonArrayannotations = jsonObj.getAsJsonArray("annotations");
      if (jsonArrayannotations != null) {
        // ensure the json data is an array
        if (!jsonObj.get("annotations").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `annotations` to be an array in the JSON string but got `%s`", jsonObj.get("annotations").toString()));
        }

        // validate the optional field `annotations` (array)
        for (int i = 0; i < jsonArrayannotations.size(); i++) {
          FullTextEntitiesAnnotations.validateJsonObject(jsonArrayannotations.get(i).getAsJsonObject());
        };
      }
      JsonArray jsonArraycashtags = jsonObj.getAsJsonArray("cashtags");
      if (jsonArraycashtags != null) {
        // ensure the json data is an array
        if (!jsonObj.get("cashtags").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `cashtags` to be an array in the JSON string but got `%s`", jsonObj.get("cashtags").toString()));
        }

        // validate the optional field `cashtags` (array)
        for (int i = 0; i < jsonArraycashtags.size(); i++) {
          CashtagEntity.validateJsonObject(jsonArraycashtags.get(i).getAsJsonObject());
        };
      }
      JsonArray jsonArrayhashtags = jsonObj.getAsJsonArray("hashtags");
      if (jsonArrayhashtags != null) {
        // ensure the json data is an array
        if (!jsonObj.get("hashtags").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `hashtags` to be an array in the JSON string but got `%s`", jsonObj.get("hashtags").toString()));
        }

        // validate the optional field `hashtags` (array)
        for (int i = 0; i < jsonArrayhashtags.size(); i++) {
          HashtagEntity.validateJsonObject(jsonArrayhashtags.get(i).getAsJsonObject());
        };
      }
      JsonArray jsonArraymentions = jsonObj.getAsJsonArray("mentions");
      if (jsonArraymentions != null) {
        // ensure the json data is an array
        if (!jsonObj.get("mentions").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `mentions` to be an array in the JSON string but got `%s`", jsonObj.get("mentions").toString()));
        }

        // validate the optional field `mentions` (array)
        for (int i = 0; i < jsonArraymentions.size(); i++) {
          MentionEntity.validateJsonObject(jsonArraymentions.get(i).getAsJsonObject());
        };
      }
      JsonArray jsonArrayurls = jsonObj.getAsJsonArray("urls");
      if (jsonArrayurls != null) {
        // ensure the json data is an array
        if (!jsonObj.get("urls").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `urls` to be an array in the JSON string but got `%s`", jsonObj.get("urls").toString()));
        }

        // validate the optional field `urls` (array)
        for (int i = 0; i < jsonArrayurls.size(); i++) {
          UrlEntity.validateJsonObject(jsonArrayurls.get(i).getAsJsonObject());
        };
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FullTextEntities.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FullTextEntities' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FullTextEntities> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FullTextEntities.class));

       return (TypeAdapter<T>) new TypeAdapter<FullTextEntities>() {
           @Override
           public void write(JsonWriter out, FullTextEntities value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FullTextEntities read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FullTextEntities given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FullTextEntities
  * @throws IOException if the JSON string is invalid with respect to FullTextEntities
  */
  public static FullTextEntities fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FullTextEntities.class);
  }

 /**
  * Convert an instance of FullTextEntities to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

