/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.model.Variant;
import com.twitter.clientlib.model.VideoAllOfNonPublicMetrics;
import com.twitter.clientlib.model.VideoAllOfOrganicMetrics;
import com.twitter.clientlib.model.VideoAllOfPromotedMetrics;
import com.twitter.clientlib.model.VideoAllOfPublicMetrics;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.twitter.clientlib.JSON;

/**
 * VideoAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class VideoAllOf {
  public static final String SERIALIZED_NAME_DURATION_MS = "duration_ms";
  @SerializedName(SERIALIZED_NAME_DURATION_MS)
  private Integer durationMs;

  public static final String SERIALIZED_NAME_NON_PUBLIC_METRICS = "non_public_metrics";
  @SerializedName(SERIALIZED_NAME_NON_PUBLIC_METRICS)
  private VideoAllOfNonPublicMetrics nonPublicMetrics;

  public static final String SERIALIZED_NAME_ORGANIC_METRICS = "organic_metrics";
  @SerializedName(SERIALIZED_NAME_ORGANIC_METRICS)
  private VideoAllOfOrganicMetrics organicMetrics;

  public static final String SERIALIZED_NAME_PREVIEW_IMAGE_URL = "preview_image_url";
  @SerializedName(SERIALIZED_NAME_PREVIEW_IMAGE_URL)
  private URL previewImageUrl;

  public static final String SERIALIZED_NAME_PROMOTED_METRICS = "promoted_metrics";
  @SerializedName(SERIALIZED_NAME_PROMOTED_METRICS)
  private VideoAllOfPromotedMetrics promotedMetrics;

  public static final String SERIALIZED_NAME_PUBLIC_METRICS = "public_metrics";
  @SerializedName(SERIALIZED_NAME_PUBLIC_METRICS)
  private VideoAllOfPublicMetrics publicMetrics;

  public static final String SERIALIZED_NAME_VARIANTS = "variants";
  @SerializedName(SERIALIZED_NAME_VARIANTS)
  private List<Variant> variants = null;

  public VideoAllOf() { 
  }

  public VideoAllOf durationMs(Integer durationMs) {
    
    this.durationMs = durationMs;
    return this;
  }

   /**
   * Get durationMs
   * @return durationMs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getDurationMs() {
    return durationMs;
  }


  public void setDurationMs(Integer durationMs) {
    this.durationMs = durationMs;
  }


  public VideoAllOf nonPublicMetrics(VideoAllOfNonPublicMetrics nonPublicMetrics) {
    
    this.nonPublicMetrics = nonPublicMetrics;
    return this;
  }

   /**
   * Get nonPublicMetrics
   * @return nonPublicMetrics
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public VideoAllOfNonPublicMetrics getNonPublicMetrics() {
    return nonPublicMetrics;
  }


  public void setNonPublicMetrics(VideoAllOfNonPublicMetrics nonPublicMetrics) {
    this.nonPublicMetrics = nonPublicMetrics;
  }


  public VideoAllOf organicMetrics(VideoAllOfOrganicMetrics organicMetrics) {
    
    this.organicMetrics = organicMetrics;
    return this;
  }

   /**
   * Get organicMetrics
   * @return organicMetrics
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public VideoAllOfOrganicMetrics getOrganicMetrics() {
    return organicMetrics;
  }


  public void setOrganicMetrics(VideoAllOfOrganicMetrics organicMetrics) {
    this.organicMetrics = organicMetrics;
  }


  public VideoAllOf previewImageUrl(URL previewImageUrl) {
    
    this.previewImageUrl = previewImageUrl;
    return this;
  }

   /**
   * Get previewImageUrl
   * @return previewImageUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public URL getPreviewImageUrl() {
    return previewImageUrl;
  }


  public void setPreviewImageUrl(URL previewImageUrl) {
    this.previewImageUrl = previewImageUrl;
  }


  public VideoAllOf promotedMetrics(VideoAllOfPromotedMetrics promotedMetrics) {
    
    this.promotedMetrics = promotedMetrics;
    return this;
  }

   /**
   * Get promotedMetrics
   * @return promotedMetrics
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public VideoAllOfPromotedMetrics getPromotedMetrics() {
    return promotedMetrics;
  }


  public void setPromotedMetrics(VideoAllOfPromotedMetrics promotedMetrics) {
    this.promotedMetrics = promotedMetrics;
  }


  public VideoAllOf publicMetrics(VideoAllOfPublicMetrics publicMetrics) {
    
    this.publicMetrics = publicMetrics;
    return this;
  }

   /**
   * Get publicMetrics
   * @return publicMetrics
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public VideoAllOfPublicMetrics getPublicMetrics() {
    return publicMetrics;
  }


  public void setPublicMetrics(VideoAllOfPublicMetrics publicMetrics) {
    this.publicMetrics = publicMetrics;
  }


  public VideoAllOf variants(List<Variant> variants) {
    
    this.variants = variants;
    return this;
  }

  public VideoAllOf addVariantsItem(Variant variantsItem) {
    if (this.variants == null) {
      this.variants = new ArrayList<>();
    }
    this.variants.add(variantsItem);
    return this;
  }

   /**
   * An array of all available variants of the media.
   * @return variants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array of all available variants of the media.")

  public List<Variant> getVariants() {
    return variants;
  }


  public void setVariants(List<Variant> variants) {
    this.variants = variants;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VideoAllOf videoAllOf = (VideoAllOf) o;
    return Objects.equals(this.durationMs, videoAllOf.durationMs) &&
        Objects.equals(this.nonPublicMetrics, videoAllOf.nonPublicMetrics) &&
        Objects.equals(this.organicMetrics, videoAllOf.organicMetrics) &&
        Objects.equals(this.previewImageUrl, videoAllOf.previewImageUrl) &&
        Objects.equals(this.promotedMetrics, videoAllOf.promotedMetrics) &&
        Objects.equals(this.publicMetrics, videoAllOf.publicMetrics) &&
        Objects.equals(this.variants, videoAllOf.variants);
  }

  @Override
  public int hashCode() {
    return Objects.hash(durationMs, nonPublicMetrics, organicMetrics, previewImageUrl, promotedMetrics, publicMetrics, variants);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VideoAllOf {\n");
    sb.append("    durationMs: ").append(toIndentedString(durationMs)).append("\n");
    sb.append("    nonPublicMetrics: ").append(toIndentedString(nonPublicMetrics)).append("\n");
    sb.append("    organicMetrics: ").append(toIndentedString(organicMetrics)).append("\n");
    sb.append("    previewImageUrl: ").append(toIndentedString(previewImageUrl)).append("\n");
    sb.append("    promotedMetrics: ").append(toIndentedString(promotedMetrics)).append("\n");
    sb.append("    publicMetrics: ").append(toIndentedString(publicMetrics)).append("\n");
    sb.append("    variants: ").append(toIndentedString(variants)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("duration_ms");
    openapiFields.add("non_public_metrics");
    openapiFields.add("organic_metrics");
    openapiFields.add("preview_image_url");
    openapiFields.add("promoted_metrics");
    openapiFields.add("public_metrics");
    openapiFields.add("variants");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to VideoAllOf
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
     // if (jsonObj == null) {
     //   if (VideoAllOf.openapiRequiredFields.isEmpty()) {
     //     return;
     //   } else { // has required fields
     //     throw new IllegalArgumentException(String.format("The required field(s) %s in VideoAllOf is not found in the empty JSON string", VideoAllOf.openapiRequiredFields.toString()));
     //   }
     // }

      // validate the optional field `non_public_metrics`
      if (jsonObj.getAsJsonObject("non_public_metrics") != null) {
        VideoAllOfNonPublicMetrics.validateJsonObject(jsonObj.getAsJsonObject("non_public_metrics"));
      }
      // validate the optional field `organic_metrics`
      if (jsonObj.getAsJsonObject("organic_metrics") != null) {
        VideoAllOfOrganicMetrics.validateJsonObject(jsonObj.getAsJsonObject("organic_metrics"));
      }
      if (jsonObj.get("preview_image_url") != null && !jsonObj.get("preview_image_url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `preview_image_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("preview_image_url").toString()));
      }
      // validate the optional field `promoted_metrics`
      if (jsonObj.getAsJsonObject("promoted_metrics") != null) {
        VideoAllOfPromotedMetrics.validateJsonObject(jsonObj.getAsJsonObject("promoted_metrics"));
      }
      // validate the optional field `public_metrics`
      if (jsonObj.getAsJsonObject("public_metrics") != null) {
        VideoAllOfPublicMetrics.validateJsonObject(jsonObj.getAsJsonObject("public_metrics"));
      }
      JsonArray jsonArrayvariants = jsonObj.getAsJsonArray("variants");
      if (jsonArrayvariants != null) {
        // ensure the json data is an array
        if (!jsonObj.get("variants").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `variants` to be an array in the JSON string but got `%s`", jsonObj.get("variants").toString()));
        }

        // validate the optional field `variants` (array)
        for (int i = 0; i < jsonArrayvariants.size(); i++) {
          Variant.validateJsonObject(jsonArrayvariants.get(i).getAsJsonObject());
        };
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!VideoAllOf.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'VideoAllOf' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<VideoAllOf> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(VideoAllOf.class));

       return (TypeAdapter<T>) new TypeAdapter<VideoAllOf>() {
           @Override
           public void write(JsonWriter out, VideoAllOf value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public VideoAllOf read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of VideoAllOf given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of VideoAllOf
  * @throws IOException if the JSON string is invalid with respect to VideoAllOf
  */
  public static VideoAllOf fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, VideoAllOf.class);
  }

 /**
  * Convert an instance of VideoAllOf to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

