/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.BookmarkAddRequest;
import com.twitter.clientlib.model.BookmarkMutationResponse;
import com.twitter.clientlib.model.Get2UsersIdBookmarksResponse;
import com.twitter.clientlib.model.ProblemOrError;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import okhttp3.Call;

public class BookmarksApi
extends ApiCommon {
    private Call getUsersIdBookmarksCall(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/bookmarks".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (mediaFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "media.fields", mediaFields));
        }
        if (pollFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "poll.fields", pollFields));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (placeFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "place.fields", placeFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call getUsersIdBookmarksValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getUsersIdBookmarks(Async)");
        }
        Call localVarCall = this.getUsersIdBookmarksCall(id, maxResults, paginationToken, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdBookmarksResponse> getUsersIdBookmarksWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields) throws ApiException {
        Call localVarCall = this.getUsersIdBookmarksValidateBeforeCall(id, maxResults, paginationToken, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdBookmarksResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call getUsersIdBookmarksAsync(String id, Integer maxResults, String paginationToken, Set<String> tweetFields, Set<String> expansions, Set<String> mediaFields, Set<String> pollFields, Set<String> userFields, Set<String> placeFields, ApiCallback<Get2UsersIdBookmarksResponse> _callback) throws ApiException {
        Call localVarCall = this.getUsersIdBookmarksValidateBeforeCall(id, maxResults, paginationToken, tweetFields, expansions, mediaFields, pollFields, userFields, placeFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdBookmarksResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetUsersIdBookmarksRequest getUsersIdBookmarks(String id) {
        return new APIgetUsersIdBookmarksRequest(id);
    }

    private Call postUsersIdBookmarksCall(BookmarkAddRequest bookmarkAddRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        BookmarkAddRequest localVarPostBody = bookmarkAddRequest;
        String localVarPath = "/2/users/{id}/bookmarks".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call postUsersIdBookmarksValidateBeforeCall(BookmarkAddRequest bookmarkAddRequest, String id, ApiCallback _callback) throws ApiException {
        if (bookmarkAddRequest == null) {
            throw new ApiException("Missing the required parameter 'bookmarkAddRequest' when calling postUsersIdBookmarks(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postUsersIdBookmarks(Async)");
        }
        Call localVarCall = this.postUsersIdBookmarksCall(bookmarkAddRequest, id, _callback);
        return localVarCall;
    }

    private ApiResponse<BookmarkMutationResponse> postUsersIdBookmarksWithHttpInfo(BookmarkAddRequest bookmarkAddRequest, String id) throws ApiException {
        Call localVarCall = this.postUsersIdBookmarksValidateBeforeCall(bookmarkAddRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call postUsersIdBookmarksAsync(BookmarkAddRequest bookmarkAddRequest, String id, ApiCallback<BookmarkMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.postUsersIdBookmarksValidateBeforeCall(bookmarkAddRequest, id, _callback);
        Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpostUsersIdBookmarksRequest postUsersIdBookmarks(BookmarkAddRequest bookmarkAddRequest, String id) {
        return new APIpostUsersIdBookmarksRequest(bookmarkAddRequest, id);
    }

    private Call usersIdBookmarksDeleteCall(String id, String tweetId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/bookmarks/{tweet_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{tweet_id\\}", this.localVarApiClient.escapeString(tweetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdBookmarksDeleteValidateBeforeCall(String id, String tweetId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdBookmarksDelete(Async)");
        }
        if (tweetId == null) {
            throw new ApiException("Missing the required parameter 'tweetId' when calling usersIdBookmarksDelete(Async)");
        }
        Call localVarCall = this.usersIdBookmarksDeleteCall(id, tweetId, _callback);
        return localVarCall;
    }

    private ApiResponse<BookmarkMutationResponse> usersIdBookmarksDeleteWithHttpInfo(String id, String tweetId) throws ApiException {
        Call localVarCall = this.usersIdBookmarksDeleteValidateBeforeCall(id, tweetId, null);
        try {
            Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdBookmarksDeleteAsync(String id, String tweetId, ApiCallback<BookmarkMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdBookmarksDeleteValidateBeforeCall(id, tweetId, _callback);
        Type localVarReturnType = new TypeToken<BookmarkMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdBookmarksDeleteRequest usersIdBookmarksDelete(String id, String tweetId) {
        return new APIusersIdBookmarksDeleteRequest(id, tweetId);
    }

    public class APIusersIdBookmarksDeleteRequest {
        private final String id;
        private final String tweetId;

        private APIusersIdBookmarksDeleteRequest(String id, String tweetId) {
            this.id = id;
            this.tweetId = tweetId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BookmarksApi.this.usersIdBookmarksDeleteCall(this.id, this.tweetId, _callback);
        }

        public BookmarkMutationResponse execute() throws ApiException {
            ApiResponse localVarResp = BookmarksApi.this.usersIdBookmarksDeleteWithHttpInfo(this.id, this.tweetId);
            return (BookmarkMutationResponse)localVarResp.getData();
        }

        public BookmarkMutationResponse execute(Integer retries) throws ApiException {
            BookmarkMutationResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (BookmarksApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<BookmarkMutationResponse> executeWithHttpInfo() throws ApiException {
            return BookmarksApi.this.usersIdBookmarksDeleteWithHttpInfo(this.id, this.tweetId);
        }

        public Call executeAsync(ApiCallback<BookmarkMutationResponse> _callback) throws ApiException {
            return BookmarksApi.this.usersIdBookmarksDeleteAsync(this.id, this.tweetId, _callback);
        }
    }

    public class APIpostUsersIdBookmarksRequest {
        private final BookmarkAddRequest bookmarkAddRequest;
        private final String id;

        private APIpostUsersIdBookmarksRequest(BookmarkAddRequest bookmarkAddRequest, String id) {
            this.bookmarkAddRequest = bookmarkAddRequest;
            this.id = id;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BookmarksApi.this.postUsersIdBookmarksCall(this.bookmarkAddRequest, this.id, _callback);
        }

        public BookmarkMutationResponse execute() throws ApiException {
            ApiResponse localVarResp = BookmarksApi.this.postUsersIdBookmarksWithHttpInfo(this.bookmarkAddRequest, this.id);
            return (BookmarkMutationResponse)localVarResp.getData();
        }

        public BookmarkMutationResponse execute(Integer retries) throws ApiException {
            BookmarkMutationResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (BookmarksApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<BookmarkMutationResponse> executeWithHttpInfo() throws ApiException {
            return BookmarksApi.this.postUsersIdBookmarksWithHttpInfo(this.bookmarkAddRequest, this.id);
        }

        public Call executeAsync(ApiCallback<BookmarkMutationResponse> _callback) throws ApiException {
            return BookmarksApi.this.postUsersIdBookmarksAsync(this.bookmarkAddRequest, this.id, _callback);
        }
    }

    public class APIgetUsersIdBookmarksRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> tweetFields;
        private Set<String> expansions;
        private Set<String> mediaFields;
        private Set<String> pollFields;
        private Set<String> userFields;
        private Set<String> placeFields;

        private APIgetUsersIdBookmarksRequest(String id) {
            this.id = id;
        }

        public APIgetUsersIdBookmarksRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIgetUsersIdBookmarksRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIgetUsersIdBookmarksRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public APIgetUsersIdBookmarksRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIgetUsersIdBookmarksRequest mediaFields(Set<String> mediaFields) {
            this.mediaFields = mediaFields;
            return this;
        }

        public APIgetUsersIdBookmarksRequest pollFields(Set<String> pollFields) {
            this.pollFields = pollFields;
            return this;
        }

        public APIgetUsersIdBookmarksRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIgetUsersIdBookmarksRequest placeFields(Set<String> placeFields) {
            this.placeFields = placeFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return BookmarksApi.this.getUsersIdBookmarksCall(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }

        public Get2UsersIdBookmarksResponse execute() throws ApiException {
            ApiResponse localVarResp = BookmarksApi.this.getUsersIdBookmarksWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
            return (Get2UsersIdBookmarksResponse)localVarResp.getData();
        }

        public Get2UsersIdBookmarksResponse execute(Integer retries) throws ApiException {
            Get2UsersIdBookmarksResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (BookmarksApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdBookmarksResponse> executeWithHttpInfo() throws ApiException {
            return BookmarksApi.this.getUsersIdBookmarksWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdBookmarksResponse> _callback) throws ApiException {
            return BookmarksApi.this.getUsersIdBookmarksAsync(this.id, this.maxResults, this.paginationToken, this.tweetFields, this.expansions, this.mediaFields, this.pollFields, this.userFields, this.placeFields, _callback);
        }
    }
}

