/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.Get2ListsIdResponse;
import com.twitter.clientlib.model.Get2UsersIdFollowedListsResponse;
import com.twitter.clientlib.model.Get2UsersIdListMembershipsResponse;
import com.twitter.clientlib.model.Get2UsersIdOwnedListsResponse;
import com.twitter.clientlib.model.Get2UsersIdPinnedListsResponse;
import com.twitter.clientlib.model.ListAddUserRequest;
import com.twitter.clientlib.model.ListCreateRequest;
import com.twitter.clientlib.model.ListCreateResponse;
import com.twitter.clientlib.model.ListDeleteResponse;
import com.twitter.clientlib.model.ListFollowedRequest;
import com.twitter.clientlib.model.ListFollowedResponse;
import com.twitter.clientlib.model.ListMutateResponse;
import com.twitter.clientlib.model.ListPinnedRequest;
import com.twitter.clientlib.model.ListPinnedResponse;
import com.twitter.clientlib.model.ListUnpinResponse;
import com.twitter.clientlib.model.ListUpdateRequest;
import com.twitter.clientlib.model.ListUpdateResponse;
import com.twitter.clientlib.model.ProblemOrError;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import okhttp3.Call;

public class ListsApi
extends ApiCommon {
    private Call getUserListMembershipsCall(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/list_memberships".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (listFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call getUserListMembershipsValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getUserListMemberships(Async)");
        }
        Call localVarCall = this.getUserListMembershipsCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdListMembershipsResponse> getUserListMembershipsWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        Call localVarCall = this.getUserListMembershipsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdListMembershipsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call getUserListMembershipsAsync(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback<Get2UsersIdListMembershipsResponse> _callback) throws ApiException {
        Call localVarCall = this.getUserListMembershipsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdListMembershipsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetUserListMembershipsRequest getUserListMemberships(String id) {
        return new APIgetUserListMembershipsRequest(id);
    }

    private Call listAddMemberCall(ListAddUserRequest listAddUserRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        ListAddUserRequest localVarPostBody = listAddUserRequest;
        String localVarPath = "/2/lists/{id}/members".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listAddMemberValidateBeforeCall(ListAddUserRequest listAddUserRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listAddMember(Async)");
        }
        Call localVarCall = this.listAddMemberCall(listAddUserRequest, id, _callback);
        return localVarCall;
    }

    private ApiResponse<ListMutateResponse> listAddMemberWithHttpInfo(ListAddUserRequest listAddUserRequest, String id) throws ApiException {
        Call localVarCall = this.listAddMemberValidateBeforeCall(listAddUserRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListMutateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listAddMemberAsync(ListAddUserRequest listAddUserRequest, String id, ApiCallback<ListMutateResponse> _callback) throws ApiException {
        Call localVarCall = this.listAddMemberValidateBeforeCall(listAddUserRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListMutateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistAddMemberRequest listAddMember(String id) {
        return new APIlistAddMemberRequest(id);
    }

    private Call listIdCreateCall(ListCreateRequest listCreateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        ListCreateRequest localVarPostBody = listCreateRequest;
        String localVarPath = "/2/lists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listIdCreateValidateBeforeCall(ListCreateRequest listCreateRequest, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listIdCreateCall(listCreateRequest, _callback);
        return localVarCall;
    }

    private ApiResponse<ListCreateResponse> listIdCreateWithHttpInfo(ListCreateRequest listCreateRequest) throws ApiException {
        Call localVarCall = this.listIdCreateValidateBeforeCall(listCreateRequest, null);
        try {
            Type localVarReturnType = new TypeToken<ListCreateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listIdCreateAsync(ListCreateRequest listCreateRequest, ApiCallback<ListCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.listIdCreateValidateBeforeCall(listCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<ListCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistIdCreateRequest listIdCreate() {
        return new APIlistIdCreateRequest();
    }

    private Call listIdDeleteCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listIdDeleteValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listIdDelete(Async)");
        }
        Call localVarCall = this.listIdDeleteCall(id, _callback);
        return localVarCall;
    }

    private ApiResponse<ListDeleteResponse> listIdDeleteWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.listIdDeleteValidateBeforeCall(id, null);
        try {
            Type localVarReturnType = new TypeToken<ListDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listIdDeleteAsync(String id, ApiCallback<ListDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.listIdDeleteValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ListDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistIdDeleteRequest listIdDelete(String id) {
        return new APIlistIdDeleteRequest(id);
    }

    private Call listIdGetCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (listFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listIdGetValidateBeforeCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listIdGet(Async)");
        }
        Call localVarCall = this.listIdGetCall(id, listFields, expansions, userFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2ListsIdResponse> listIdGetWithHttpInfo(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        Call localVarCall = this.listIdGetValidateBeforeCall(id, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2ListsIdResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listIdGetAsync(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback<Get2ListsIdResponse> _callback) throws ApiException {
        Call localVarCall = this.listIdGetValidateBeforeCall(id, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<Get2ListsIdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistIdGetRequest listIdGet(String id) {
        return new APIlistIdGetRequest(id);
    }

    private Call listIdUpdateCall(ListUpdateRequest listUpdateRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        ListUpdateRequest localVarPostBody = listUpdateRequest;
        String localVarPath = "/2/lists/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listIdUpdateValidateBeforeCall(ListUpdateRequest listUpdateRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listIdUpdate(Async)");
        }
        Call localVarCall = this.listIdUpdateCall(listUpdateRequest, id, _callback);
        return localVarCall;
    }

    private ApiResponse<ListUpdateResponse> listIdUpdateWithHttpInfo(ListUpdateRequest listUpdateRequest, String id) throws ApiException {
        Call localVarCall = this.listIdUpdateValidateBeforeCall(listUpdateRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListUpdateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listIdUpdateAsync(ListUpdateRequest listUpdateRequest, String id, ApiCallback<ListUpdateResponse> _callback) throws ApiException {
        Call localVarCall = this.listIdUpdateValidateBeforeCall(listUpdateRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListUpdateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistIdUpdateRequest listIdUpdate(String id) {
        return new APIlistIdUpdateRequest(id);
    }

    private Call listRemoveMemberCall(String id, String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}/members/{user_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{user_id\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listRemoveMemberValidateBeforeCall(String id, String userId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listRemoveMember(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listRemoveMember(Async)");
        }
        Call localVarCall = this.listRemoveMemberCall(id, userId, _callback);
        return localVarCall;
    }

    private ApiResponse<ListMutateResponse> listRemoveMemberWithHttpInfo(String id, String userId) throws ApiException {
        Call localVarCall = this.listRemoveMemberValidateBeforeCall(id, userId, null);
        try {
            Type localVarReturnType = new TypeToken<ListMutateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listRemoveMemberAsync(String id, String userId, ApiCallback<ListMutateResponse> _callback) throws ApiException {
        Call localVarCall = this.listRemoveMemberValidateBeforeCall(id, userId, _callback);
        Type localVarReturnType = new TypeToken<ListMutateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistRemoveMemberRequest listRemoveMember(String id, String userId) {
        return new APIlistRemoveMemberRequest(id, userId);
    }

    private Call listUserFollowCall(ListFollowedRequest listFollowedRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        ListFollowedRequest localVarPostBody = listFollowedRequest;
        String localVarPath = "/2/users/{id}/followed_lists".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserFollowValidateBeforeCall(ListFollowedRequest listFollowedRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserFollow(Async)");
        }
        Call localVarCall = this.listUserFollowCall(listFollowedRequest, id, _callback);
        return localVarCall;
    }

    private ApiResponse<ListFollowedResponse> listUserFollowWithHttpInfo(ListFollowedRequest listFollowedRequest, String id) throws ApiException {
        Call localVarCall = this.listUserFollowValidateBeforeCall(listFollowedRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listUserFollowAsync(ListFollowedRequest listFollowedRequest, String id, ApiCallback<ListFollowedResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserFollowValidateBeforeCall(listFollowedRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserFollowRequest listUserFollow(String id) {
        return new APIlistUserFollowRequest(id);
    }

    private Call listUserOwnedListsCall(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/owned_lists".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (listFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserOwnedListsValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserOwnedLists(Async)");
        }
        Call localVarCall = this.listUserOwnedListsCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdOwnedListsResponse> listUserOwnedListsWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        Call localVarCall = this.listUserOwnedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdOwnedListsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listUserOwnedListsAsync(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback<Get2UsersIdOwnedListsResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserOwnedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdOwnedListsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserOwnedListsRequest listUserOwnedLists(String id) {
        return new APIlistUserOwnedListsRequest(id);
    }

    private Call listUserPinCall(ListPinnedRequest listPinnedRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        ListPinnedRequest localVarPostBody = listPinnedRequest;
        String localVarPath = "/2/users/{id}/pinned_lists".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserPinValidateBeforeCall(ListPinnedRequest listPinnedRequest, String id, ApiCallback _callback) throws ApiException {
        if (listPinnedRequest == null) {
            throw new ApiException("Missing the required parameter 'listPinnedRequest' when calling listUserPin(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserPin(Async)");
        }
        Call localVarCall = this.listUserPinCall(listPinnedRequest, id, _callback);
        return localVarCall;
    }

    private ApiResponse<ListPinnedResponse> listUserPinWithHttpInfo(ListPinnedRequest listPinnedRequest, String id) throws ApiException {
        Call localVarCall = this.listUserPinValidateBeforeCall(listPinnedRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<ListPinnedResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listUserPinAsync(ListPinnedRequest listPinnedRequest, String id, ApiCallback<ListPinnedResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserPinValidateBeforeCall(listPinnedRequest, id, _callback);
        Type localVarReturnType = new TypeToken<ListPinnedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserPinRequest listUserPin(ListPinnedRequest listPinnedRequest, String id) {
        return new APIlistUserPinRequest(listPinnedRequest, id);
    }

    private Call listUserPinnedListsCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/pinned_lists".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (listFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserPinnedListsValidateBeforeCall(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserPinnedLists(Async)");
        }
        Call localVarCall = this.listUserPinnedListsCall(id, listFields, expansions, userFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdPinnedListsResponse> listUserPinnedListsWithHttpInfo(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        Call localVarCall = this.listUserPinnedListsValidateBeforeCall(id, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdPinnedListsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listUserPinnedListsAsync(String id, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback<Get2UsersIdPinnedListsResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserPinnedListsValidateBeforeCall(id, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdPinnedListsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserPinnedListsRequest listUserPinnedLists(String id) {
        return new APIlistUserPinnedListsRequest(id);
    }

    private Call listUserUnfollowCall(String id, String listId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/followed_lists/{list_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{list_id\\}", this.localVarApiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserUnfollowValidateBeforeCall(String id, String listId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserUnfollow(Async)");
        }
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listUserUnfollow(Async)");
        }
        Call localVarCall = this.listUserUnfollowCall(id, listId, _callback);
        return localVarCall;
    }

    private ApiResponse<ListFollowedResponse> listUserUnfollowWithHttpInfo(String id, String listId) throws ApiException {
        Call localVarCall = this.listUserUnfollowValidateBeforeCall(id, listId, null);
        try {
            Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listUserUnfollowAsync(String id, String listId, ApiCallback<ListFollowedResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserUnfollowValidateBeforeCall(id, listId, _callback);
        Type localVarReturnType = new TypeToken<ListFollowedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserUnfollowRequest listUserUnfollow(String id, String listId) {
        return new APIlistUserUnfollowRequest(id, listId);
    }

    private Call listUserUnpinCall(String id, String listId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/pinned_lists/{list_id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{list_id\\}", this.localVarApiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listUserUnpinValidateBeforeCall(String id, String listId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listUserUnpin(Async)");
        }
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling listUserUnpin(Async)");
        }
        Call localVarCall = this.listUserUnpinCall(id, listId, _callback);
        return localVarCall;
    }

    private ApiResponse<ListUnpinResponse> listUserUnpinWithHttpInfo(String id, String listId) throws ApiException {
        Call localVarCall = this.listUserUnpinValidateBeforeCall(id, listId, null);
        try {
            Type localVarReturnType = new TypeToken<ListUnpinResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listUserUnpinAsync(String id, String listId, ApiCallback<ListUnpinResponse> _callback) throws ApiException {
        Call localVarCall = this.listUserUnpinValidateBeforeCall(id, listId, _callback);
        Type localVarReturnType = new TypeToken<ListUnpinResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserUnpinRequest listUserUnpin(String id, String listId) {
        return new APIlistUserUnpinRequest(id, listId);
    }

    private Call userFollowedListsCall(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/followed_lists".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (listFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "list.fields", listFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call userFollowedListsValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling userFollowedLists(Async)");
        }
        Call localVarCall = this.userFollowedListsCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdFollowedListsResponse> userFollowedListsWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields) throws ApiException {
        Call localVarCall = this.userFollowedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdFollowedListsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call userFollowedListsAsync(String id, Integer maxResults, String paginationToken, Set<String> listFields, Set<String> expansions, Set<String> userFields, ApiCallback<Get2UsersIdFollowedListsResponse> _callback) throws ApiException {
        Call localVarCall = this.userFollowedListsValidateBeforeCall(id, maxResults, paginationToken, listFields, expansions, userFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdFollowedListsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIuserFollowedListsRequest userFollowedLists(String id) {
        return new APIuserFollowedListsRequest(id);
    }

    public class APIuserFollowedListsRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> listFields;
        private Set<String> expansions;
        private Set<String> userFields;

        private APIuserFollowedListsRequest(String id) {
            this.id = id;
        }

        public APIuserFollowedListsRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIuserFollowedListsRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIuserFollowedListsRequest listFields(Set<String> listFields) {
            this.listFields = listFields;
            return this;
        }

        public APIuserFollowedListsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIuserFollowedListsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.userFollowedListsCall(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields, _callback);
        }

        public Get2UsersIdFollowedListsResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.userFollowedListsWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields);
            return (Get2UsersIdFollowedListsResponse)localVarResp.getData();
        }

        public Get2UsersIdFollowedListsResponse execute(Integer retries) throws ApiException {
            Get2UsersIdFollowedListsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdFollowedListsResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.userFollowedListsWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdFollowedListsResponse> _callback) throws ApiException {
            return ListsApi.this.userFollowedListsAsync(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields, _callback);
        }
    }

    public class APIlistUserUnpinRequest {
        private final String id;
        private final String listId;

        private APIlistUserUnpinRequest(String id, String listId) {
            this.id = id;
            this.listId = listId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listUserUnpinCall(this.id, this.listId, _callback);
        }

        public ListUnpinResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listUserUnpinWithHttpInfo(this.id, this.listId);
            return (ListUnpinResponse)localVarResp.getData();
        }

        public ListUnpinResponse execute(Integer retries) throws ApiException {
            ListUnpinResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<ListUnpinResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listUserUnpinWithHttpInfo(this.id, this.listId);
        }

        public Call executeAsync(ApiCallback<ListUnpinResponse> _callback) throws ApiException {
            return ListsApi.this.listUserUnpinAsync(this.id, this.listId, _callback);
        }
    }

    public class APIlistUserUnfollowRequest {
        private final String id;
        private final String listId;

        private APIlistUserUnfollowRequest(String id, String listId) {
            this.id = id;
            this.listId = listId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listUserUnfollowCall(this.id, this.listId, _callback);
        }

        public ListFollowedResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listUserUnfollowWithHttpInfo(this.id, this.listId);
            return (ListFollowedResponse)localVarResp.getData();
        }

        public ListFollowedResponse execute(Integer retries) throws ApiException {
            ListFollowedResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<ListFollowedResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listUserUnfollowWithHttpInfo(this.id, this.listId);
        }

        public Call executeAsync(ApiCallback<ListFollowedResponse> _callback) throws ApiException {
            return ListsApi.this.listUserUnfollowAsync(this.id, this.listId, _callback);
        }
    }

    public class APIlistUserPinnedListsRequest {
        private final String id;
        private Set<String> listFields;
        private Set<String> expansions;
        private Set<String> userFields;

        private APIlistUserPinnedListsRequest(String id) {
            this.id = id;
        }

        public APIlistUserPinnedListsRequest listFields(Set<String> listFields) {
            this.listFields = listFields;
            return this;
        }

        public APIlistUserPinnedListsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIlistUserPinnedListsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listUserPinnedListsCall(this.id, this.listFields, this.expansions, this.userFields, _callback);
        }

        public Get2UsersIdPinnedListsResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listUserPinnedListsWithHttpInfo(this.id, this.listFields, this.expansions, this.userFields);
            return (Get2UsersIdPinnedListsResponse)localVarResp.getData();
        }

        public Get2UsersIdPinnedListsResponse execute(Integer retries) throws ApiException {
            Get2UsersIdPinnedListsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdPinnedListsResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listUserPinnedListsWithHttpInfo(this.id, this.listFields, this.expansions, this.userFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdPinnedListsResponse> _callback) throws ApiException {
            return ListsApi.this.listUserPinnedListsAsync(this.id, this.listFields, this.expansions, this.userFields, _callback);
        }
    }

    public class APIlistUserPinRequest {
        private final ListPinnedRequest listPinnedRequest;
        private final String id;

        private APIlistUserPinRequest(ListPinnedRequest listPinnedRequest, String id) {
            this.listPinnedRequest = listPinnedRequest;
            this.id = id;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listUserPinCall(this.listPinnedRequest, this.id, _callback);
        }

        public ListPinnedResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listUserPinWithHttpInfo(this.listPinnedRequest, this.id);
            return (ListPinnedResponse)localVarResp.getData();
        }

        public ListPinnedResponse execute(Integer retries) throws ApiException {
            ListPinnedResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<ListPinnedResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listUserPinWithHttpInfo(this.listPinnedRequest, this.id);
        }

        public Call executeAsync(ApiCallback<ListPinnedResponse> _callback) throws ApiException {
            return ListsApi.this.listUserPinAsync(this.listPinnedRequest, this.id, _callback);
        }
    }

    public class APIlistUserOwnedListsRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> listFields;
        private Set<String> expansions;
        private Set<String> userFields;

        private APIlistUserOwnedListsRequest(String id) {
            this.id = id;
        }

        public APIlistUserOwnedListsRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIlistUserOwnedListsRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIlistUserOwnedListsRequest listFields(Set<String> listFields) {
            this.listFields = listFields;
            return this;
        }

        public APIlistUserOwnedListsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIlistUserOwnedListsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listUserOwnedListsCall(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields, _callback);
        }

        public Get2UsersIdOwnedListsResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listUserOwnedListsWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields);
            return (Get2UsersIdOwnedListsResponse)localVarResp.getData();
        }

        public Get2UsersIdOwnedListsResponse execute(Integer retries) throws ApiException {
            Get2UsersIdOwnedListsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdOwnedListsResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listUserOwnedListsWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdOwnedListsResponse> _callback) throws ApiException {
            return ListsApi.this.listUserOwnedListsAsync(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields, _callback);
        }
    }

    public class APIlistUserFollowRequest {
        private final String id;
        private ListFollowedRequest listFollowedRequest;

        private APIlistUserFollowRequest(String id) {
            this.id = id;
        }

        public APIlistUserFollowRequest listFollowedRequest(ListFollowedRequest listFollowedRequest) {
            this.listFollowedRequest = listFollowedRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listUserFollowCall(this.listFollowedRequest, this.id, _callback);
        }

        public ListFollowedResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listUserFollowWithHttpInfo(this.listFollowedRequest, this.id);
            return (ListFollowedResponse)localVarResp.getData();
        }

        public ListFollowedResponse execute(Integer retries) throws ApiException {
            ListFollowedResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<ListFollowedResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listUserFollowWithHttpInfo(this.listFollowedRequest, this.id);
        }

        public Call executeAsync(ApiCallback<ListFollowedResponse> _callback) throws ApiException {
            return ListsApi.this.listUserFollowAsync(this.listFollowedRequest, this.id, _callback);
        }
    }

    public class APIlistRemoveMemberRequest {
        private final String id;
        private final String userId;

        private APIlistRemoveMemberRequest(String id, String userId) {
            this.id = id;
            this.userId = userId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listRemoveMemberCall(this.id, this.userId, _callback);
        }

        public ListMutateResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listRemoveMemberWithHttpInfo(this.id, this.userId);
            return (ListMutateResponse)localVarResp.getData();
        }

        public ListMutateResponse execute(Integer retries) throws ApiException {
            ListMutateResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<ListMutateResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listRemoveMemberWithHttpInfo(this.id, this.userId);
        }

        public Call executeAsync(ApiCallback<ListMutateResponse> _callback) throws ApiException {
            return ListsApi.this.listRemoveMemberAsync(this.id, this.userId, _callback);
        }
    }

    public class APIlistIdUpdateRequest {
        private final String id;
        private ListUpdateRequest listUpdateRequest;

        private APIlistIdUpdateRequest(String id) {
            this.id = id;
        }

        public APIlistIdUpdateRequest listUpdateRequest(ListUpdateRequest listUpdateRequest) {
            this.listUpdateRequest = listUpdateRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listIdUpdateCall(this.listUpdateRequest, this.id, _callback);
        }

        public ListUpdateResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listIdUpdateWithHttpInfo(this.listUpdateRequest, this.id);
            return (ListUpdateResponse)localVarResp.getData();
        }

        public ListUpdateResponse execute(Integer retries) throws ApiException {
            ListUpdateResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<ListUpdateResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listIdUpdateWithHttpInfo(this.listUpdateRequest, this.id);
        }

        public Call executeAsync(ApiCallback<ListUpdateResponse> _callback) throws ApiException {
            return ListsApi.this.listIdUpdateAsync(this.listUpdateRequest, this.id, _callback);
        }
    }

    public class APIlistIdGetRequest {
        private final String id;
        private Set<String> listFields;
        private Set<String> expansions;
        private Set<String> userFields;

        private APIlistIdGetRequest(String id) {
            this.id = id;
        }

        public APIlistIdGetRequest listFields(Set<String> listFields) {
            this.listFields = listFields;
            return this;
        }

        public APIlistIdGetRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIlistIdGetRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listIdGetCall(this.id, this.listFields, this.expansions, this.userFields, _callback);
        }

        public Get2ListsIdResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listIdGetWithHttpInfo(this.id, this.listFields, this.expansions, this.userFields);
            return (Get2ListsIdResponse)localVarResp.getData();
        }

        public Get2ListsIdResponse execute(Integer retries) throws ApiException {
            Get2ListsIdResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2ListsIdResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listIdGetWithHttpInfo(this.id, this.listFields, this.expansions, this.userFields);
        }

        public Call executeAsync(ApiCallback<Get2ListsIdResponse> _callback) throws ApiException {
            return ListsApi.this.listIdGetAsync(this.id, this.listFields, this.expansions, this.userFields, _callback);
        }
    }

    public class APIlistIdDeleteRequest {
        private final String id;

        private APIlistIdDeleteRequest(String id) {
            this.id = id;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listIdDeleteCall(this.id, _callback);
        }

        public ListDeleteResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listIdDeleteWithHttpInfo(this.id);
            return (ListDeleteResponse)localVarResp.getData();
        }

        public ListDeleteResponse execute(Integer retries) throws ApiException {
            ListDeleteResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<ListDeleteResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listIdDeleteWithHttpInfo(this.id);
        }

        public Call executeAsync(ApiCallback<ListDeleteResponse> _callback) throws ApiException {
            return ListsApi.this.listIdDeleteAsync(this.id, _callback);
        }
    }

    public class APIlistIdCreateRequest {
        private ListCreateRequest listCreateRequest;

        private APIlistIdCreateRequest() {
        }

        public APIlistIdCreateRequest listCreateRequest(ListCreateRequest listCreateRequest) {
            this.listCreateRequest = listCreateRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listIdCreateCall(this.listCreateRequest, _callback);
        }

        public ListCreateResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listIdCreateWithHttpInfo(this.listCreateRequest);
            return (ListCreateResponse)localVarResp.getData();
        }

        public ListCreateResponse execute(Integer retries) throws ApiException {
            ListCreateResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<ListCreateResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listIdCreateWithHttpInfo(this.listCreateRequest);
        }

        public Call executeAsync(ApiCallback<ListCreateResponse> _callback) throws ApiException {
            return ListsApi.this.listIdCreateAsync(this.listCreateRequest, _callback);
        }
    }

    public class APIlistAddMemberRequest {
        private final String id;
        private ListAddUserRequest listAddUserRequest;

        private APIlistAddMemberRequest(String id) {
            this.id = id;
        }

        public APIlistAddMemberRequest listAddUserRequest(ListAddUserRequest listAddUserRequest) {
            this.listAddUserRequest = listAddUserRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.listAddMemberCall(this.listAddUserRequest, this.id, _callback);
        }

        public ListMutateResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.listAddMemberWithHttpInfo(this.listAddUserRequest, this.id);
            return (ListMutateResponse)localVarResp.getData();
        }

        public ListMutateResponse execute(Integer retries) throws ApiException {
            ListMutateResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<ListMutateResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.listAddMemberWithHttpInfo(this.listAddUserRequest, this.id);
        }

        public Call executeAsync(ApiCallback<ListMutateResponse> _callback) throws ApiException {
            return ListsApi.this.listAddMemberAsync(this.listAddUserRequest, this.id, _callback);
        }
    }

    public class APIgetUserListMembershipsRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> listFields;
        private Set<String> expansions;
        private Set<String> userFields;

        private APIgetUserListMembershipsRequest(String id) {
            this.id = id;
        }

        public APIgetUserListMembershipsRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIgetUserListMembershipsRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIgetUserListMembershipsRequest listFields(Set<String> listFields) {
            this.listFields = listFields;
            return this;
        }

        public APIgetUserListMembershipsRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIgetUserListMembershipsRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ListsApi.this.getUserListMembershipsCall(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields, _callback);
        }

        public Get2UsersIdListMembershipsResponse execute() throws ApiException {
            ApiResponse localVarResp = ListsApi.this.getUserListMembershipsWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields);
            return (Get2UsersIdListMembershipsResponse)localVarResp.getData();
        }

        public Get2UsersIdListMembershipsResponse execute(Integer retries) throws ApiException {
            Get2UsersIdListMembershipsResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (ListsApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdListMembershipsResponse> executeWithHttpInfo() throws ApiException {
            return ListsApi.this.getUserListMembershipsWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdListMembershipsResponse> _callback) throws ApiException {
            return ListsApi.this.getUserListMembershipsAsync(this.id, this.maxResults, this.paginationToken, this.listFields, this.expansions, this.userFields, _callback);
        }
    }
}

