/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.google.gson.reflect.TypeToken;
import com.twitter.clientlib.ApiCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.ApiResponse;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.api.ApiCommon;
import com.twitter.clientlib.model.BlockUserMutationResponse;
import com.twitter.clientlib.model.BlockUserRequest;
import com.twitter.clientlib.model.Get2ListsIdFollowersResponse;
import com.twitter.clientlib.model.Get2ListsIdMembersResponse;
import com.twitter.clientlib.model.Get2TweetsIdLikingUsersResponse;
import com.twitter.clientlib.model.Get2TweetsIdRetweetedByResponse;
import com.twitter.clientlib.model.Get2UsersByResponse;
import com.twitter.clientlib.model.Get2UsersByUsernameUsernameResponse;
import com.twitter.clientlib.model.Get2UsersIdBlockingResponse;
import com.twitter.clientlib.model.Get2UsersIdFollowersResponse;
import com.twitter.clientlib.model.Get2UsersIdFollowingResponse;
import com.twitter.clientlib.model.Get2UsersIdMutingResponse;
import com.twitter.clientlib.model.Get2UsersIdResponse;
import com.twitter.clientlib.model.Get2UsersMeResponse;
import com.twitter.clientlib.model.Get2UsersResponse;
import com.twitter.clientlib.model.MuteUserMutationResponse;
import com.twitter.clientlib.model.MuteUserRequest;
import com.twitter.clientlib.model.ProblemOrError;
import com.twitter.clientlib.model.UsersFollowingCreateRequest;
import com.twitter.clientlib.model.UsersFollowingCreateResponse;
import com.twitter.clientlib.model.UsersFollowingDeleteResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import okhttp3.Call;

public class UsersApi
extends ApiCommon {
    private Call findMyUserCall(Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/me";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findMyUserValidateBeforeCall(Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.findMyUserCall(userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersMeResponse> findMyUserWithHttpInfo(Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.findMyUserValidateBeforeCall(userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersMeResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findMyUserAsync(Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2UsersMeResponse> _callback) throws ApiException {
        Call localVarCall = this.findMyUserValidateBeforeCall(userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersMeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindMyUserRequest findMyUser() {
        return new APIfindMyUserRequest();
    }

    private Call findUserByIdCall(String id, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findUserByIdValidateBeforeCall(String id, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling findUserById(Async)");
        }
        Call localVarCall = this.findUserByIdCall(id, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdResponse> findUserByIdWithHttpInfo(String id, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.findUserByIdValidateBeforeCall(id, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findUserByIdAsync(String id, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2UsersIdResponse> _callback) throws ApiException {
        Call localVarCall = this.findUserByIdValidateBeforeCall(id, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindUserByIdRequest findUserById(String id) {
        return new APIfindUserByIdRequest(id);
    }

    private Call findUserByUsernameCall(String username, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/by/username/{username}".replaceAll("\\{username\\}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findUserByUsernameValidateBeforeCall(String username, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling findUserByUsername(Async)");
        }
        Call localVarCall = this.findUserByUsernameCall(username, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersByUsernameUsernameResponse> findUserByUsernameWithHttpInfo(String username, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.findUserByUsernameValidateBeforeCall(username, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersByUsernameUsernameResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findUserByUsernameAsync(String username, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2UsersByUsernameUsernameResponse> _callback) throws ApiException {
        Call localVarCall = this.findUserByUsernameValidateBeforeCall(username, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersByUsernameUsernameResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindUserByUsernameRequest findUserByUsername(String username) {
        return new APIfindUserByUsernameRequest(username);
    }

    private Call findUsersByIdCall(List<String> ids, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ids != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "ids", ids));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findUsersByIdValidateBeforeCall(List<String> ids, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling findUsersById(Async)");
        }
        Call localVarCall = this.findUsersByIdCall(ids, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersResponse> findUsersByIdWithHttpInfo(List<String> ids, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.findUsersByIdValidateBeforeCall(ids, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findUsersByIdAsync(List<String> ids, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2UsersResponse> _callback) throws ApiException {
        Call localVarCall = this.findUsersByIdValidateBeforeCall(ids, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindUsersByIdRequest findUsersById(List<String> ids) {
        return new APIfindUsersByIdRequest(ids);
    }

    private Call findUsersByUsernameCall(List<String> usernames, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/by";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (usernames != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "usernames", usernames));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call findUsersByUsernameValidateBeforeCall(List<String> usernames, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (usernames == null) {
            throw new ApiException("Missing the required parameter 'usernames' when calling findUsersByUsername(Async)");
        }
        Call localVarCall = this.findUsersByUsernameCall(usernames, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersByResponse> findUsersByUsernameWithHttpInfo(List<String> usernames, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.findUsersByUsernameValidateBeforeCall(usernames, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersByResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call findUsersByUsernameAsync(List<String> usernames, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2UsersByResponse> _callback) throws ApiException {
        Call localVarCall = this.findUsersByUsernameValidateBeforeCall(usernames, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersByResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindUsersByUsernameRequest findUsersByUsername(List<String> usernames) {
        return new APIfindUsersByUsernameRequest(usernames);
    }

    private Call listGetFollowersCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}/followers".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listGetFollowersValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listGetFollowers(Async)");
        }
        Call localVarCall = this.listGetFollowersCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2ListsIdFollowersResponse> listGetFollowersWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.listGetFollowersValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2ListsIdFollowersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listGetFollowersAsync(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2ListsIdFollowersResponse> _callback) throws ApiException {
        Call localVarCall = this.listGetFollowersValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2ListsIdFollowersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistGetFollowersRequest listGetFollowers(String id) {
        return new APIlistGetFollowersRequest(id);
    }

    private Call listGetMembersCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/lists/{id}/members".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call listGetMembersValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling listGetMembers(Async)");
        }
        Call localVarCall = this.listGetMembersCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2ListsIdMembersResponse> listGetMembersWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.listGetMembersValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2ListsIdMembersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call listGetMembersAsync(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2ListsIdMembersResponse> _callback) throws ApiException {
        Call localVarCall = this.listGetMembersValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2ListsIdMembersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistGetMembersRequest listGetMembers(String id) {
        return new APIlistGetMembersRequest(id);
    }

    private Call tweetsIdLikingUsersCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/{id}/liking_users".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetsIdLikingUsersValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling tweetsIdLikingUsers(Async)");
        }
        Call localVarCall = this.tweetsIdLikingUsersCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2TweetsIdLikingUsersResponse> tweetsIdLikingUsersWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.tweetsIdLikingUsersValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2TweetsIdLikingUsersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call tweetsIdLikingUsersAsync(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2TweetsIdLikingUsersResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetsIdLikingUsersValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2TweetsIdLikingUsersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APItweetsIdLikingUsersRequest tweetsIdLikingUsers(String id) {
        return new APItweetsIdLikingUsersRequest(id);
    }

    private Call tweetsIdRetweetingUsersCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/tweets/{id}/retweeted_by".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call tweetsIdRetweetingUsersValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling tweetsIdRetweetingUsers(Async)");
        }
        Call localVarCall = this.tweetsIdRetweetingUsersCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2TweetsIdRetweetedByResponse> tweetsIdRetweetingUsersWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.tweetsIdRetweetingUsersValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2TweetsIdRetweetedByResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call tweetsIdRetweetingUsersAsync(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2TweetsIdRetweetedByResponse> _callback) throws ApiException {
        Call localVarCall = this.tweetsIdRetweetingUsersValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2TweetsIdRetweetedByResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APItweetsIdRetweetingUsersRequest tweetsIdRetweetingUsers(String id) {
        return new APItweetsIdRetweetingUsersRequest(id);
    }

    private Call usersIdBlockCall(BlockUserRequest blockUserRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        BlockUserRequest localVarPostBody = blockUserRequest;
        String localVarPath = "/2/users/{id}/blocking".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdBlockValidateBeforeCall(BlockUserRequest blockUserRequest, String id, ApiCallback _callback) throws ApiException {
        if (blockUserRequest == null) {
            throw new ApiException("Missing the required parameter 'blockUserRequest' when calling usersIdBlock(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdBlock(Async)");
        }
        Call localVarCall = this.usersIdBlockCall(blockUserRequest, id, _callback);
        return localVarCall;
    }

    private ApiResponse<BlockUserMutationResponse> usersIdBlockWithHttpInfo(BlockUserRequest blockUserRequest, String id) throws ApiException {
        Call localVarCall = this.usersIdBlockValidateBeforeCall(blockUserRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<BlockUserMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdBlockAsync(BlockUserRequest blockUserRequest, String id, ApiCallback<BlockUserMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdBlockValidateBeforeCall(blockUserRequest, id, _callback);
        Type localVarReturnType = new TypeToken<BlockUserMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdBlockRequest usersIdBlock(BlockUserRequest blockUserRequest, String id) {
        return new APIusersIdBlockRequest(blockUserRequest, id);
    }

    private Call usersIdBlockingCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/blocking".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdBlockingValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdBlocking(Async)");
        }
        Call localVarCall = this.usersIdBlockingCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdBlockingResponse> usersIdBlockingWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.usersIdBlockingValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdBlockingResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdBlockingAsync(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2UsersIdBlockingResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdBlockingValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdBlockingResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdBlockingRequest usersIdBlocking(String id) {
        return new APIusersIdBlockingRequest(id);
    }

    private Call usersIdFollowCall(UsersFollowingCreateRequest usersFollowingCreateRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        UsersFollowingCreateRequest localVarPostBody = usersFollowingCreateRequest;
        String localVarPath = "/2/users/{id}/following".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdFollowValidateBeforeCall(UsersFollowingCreateRequest usersFollowingCreateRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdFollow(Async)");
        }
        Call localVarCall = this.usersIdFollowCall(usersFollowingCreateRequest, id, _callback);
        return localVarCall;
    }

    private ApiResponse<UsersFollowingCreateResponse> usersIdFollowWithHttpInfo(UsersFollowingCreateRequest usersFollowingCreateRequest, String id) throws ApiException {
        Call localVarCall = this.usersIdFollowValidateBeforeCall(usersFollowingCreateRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<UsersFollowingCreateResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdFollowAsync(UsersFollowingCreateRequest usersFollowingCreateRequest, String id, ApiCallback<UsersFollowingCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdFollowValidateBeforeCall(usersFollowingCreateRequest, id, _callback);
        Type localVarReturnType = new TypeToken<UsersFollowingCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdFollowRequest usersIdFollow(String id) {
        return new APIusersIdFollowRequest(id);
    }

    private Call usersIdFollowersCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/followers".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdFollowersValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdFollowers(Async)");
        }
        Call localVarCall = this.usersIdFollowersCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdFollowersResponse> usersIdFollowersWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.usersIdFollowersValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdFollowersResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdFollowersAsync(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2UsersIdFollowersResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdFollowersValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdFollowersResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdFollowersRequest usersIdFollowers(String id) {
        return new APIusersIdFollowersRequest(id);
    }

    private Call usersIdFollowingCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/following".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken", "OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdFollowingValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdFollowing(Async)");
        }
        Call localVarCall = this.usersIdFollowingCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdFollowingResponse> usersIdFollowingWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.usersIdFollowingValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdFollowingResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdFollowingAsync(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2UsersIdFollowingResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdFollowingValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdFollowingResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdFollowingRequest usersIdFollowing(String id) {
        return new APIusersIdFollowingRequest(id);
    }

    private Call usersIdMuteCall(MuteUserRequest muteUserRequest, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        MuteUserRequest localVarPostBody = muteUserRequest;
        String localVarPath = "/2/users/{id}/muting".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdMuteValidateBeforeCall(MuteUserRequest muteUserRequest, String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdMute(Async)");
        }
        Call localVarCall = this.usersIdMuteCall(muteUserRequest, id, _callback);
        return localVarCall;
    }

    private ApiResponse<MuteUserMutationResponse> usersIdMuteWithHttpInfo(MuteUserRequest muteUserRequest, String id) throws ApiException {
        Call localVarCall = this.usersIdMuteValidateBeforeCall(muteUserRequest, id, null);
        try {
            Type localVarReturnType = new TypeToken<MuteUserMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdMuteAsync(MuteUserRequest muteUserRequest, String id, ApiCallback<MuteUserMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdMuteValidateBeforeCall(muteUserRequest, id, _callback);
        Type localVarReturnType = new TypeToken<MuteUserMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdMuteRequest usersIdMute(String id) {
        return new APIusersIdMuteRequest(id);
    }

    private Call usersIdMutingCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{id}/muting".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("max_results", maxResults));
        }
        if (paginationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination_token", paginationToken));
        }
        if (userFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "user.fields", userFields));
        }
        if (expansions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expansions", expansions));
        }
        if (tweetFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tweet.fields", tweetFields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdMutingValidateBeforeCall(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling usersIdMuting(Async)");
        }
        Call localVarCall = this.usersIdMutingCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        return localVarCall;
    }

    private ApiResponse<Get2UsersIdMutingResponse> usersIdMutingWithHttpInfo(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields) throws ApiException {
        Call localVarCall = this.usersIdMutingValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, null);
        try {
            Type localVarReturnType = new TypeToken<Get2UsersIdMutingResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdMutingAsync(String id, Integer maxResults, String paginationToken, Set<String> userFields, Set<String> expansions, Set<String> tweetFields, ApiCallback<Get2UsersIdMutingResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdMutingValidateBeforeCall(id, maxResults, paginationToken, userFields, expansions, tweetFields, _callback);
        Type localVarReturnType = new TypeToken<Get2UsersIdMutingResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdMutingRequest usersIdMuting(String id) {
        return new APIusersIdMutingRequest(id);
    }

    private Call usersIdUnblockCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{source_user_id}/blocking/{target_user_id}".replaceAll("\\{source_user_id\\}", this.localVarApiClient.escapeString(sourceUserId.toString())).replaceAll("\\{target_user_id\\}", this.localVarApiClient.escapeString(targetUserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdUnblockValidateBeforeCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        if (sourceUserId == null) {
            throw new ApiException("Missing the required parameter 'sourceUserId' when calling usersIdUnblock(Async)");
        }
        if (targetUserId == null) {
            throw new ApiException("Missing the required parameter 'targetUserId' when calling usersIdUnblock(Async)");
        }
        Call localVarCall = this.usersIdUnblockCall(sourceUserId, targetUserId, _callback);
        return localVarCall;
    }

    private ApiResponse<BlockUserMutationResponse> usersIdUnblockWithHttpInfo(String sourceUserId, String targetUserId) throws ApiException {
        Call localVarCall = this.usersIdUnblockValidateBeforeCall(sourceUserId, targetUserId, null);
        try {
            Type localVarReturnType = new TypeToken<BlockUserMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdUnblockAsync(String sourceUserId, String targetUserId, ApiCallback<BlockUserMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdUnblockValidateBeforeCall(sourceUserId, targetUserId, _callback);
        Type localVarReturnType = new TypeToken<BlockUserMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdUnblockRequest usersIdUnblock(String sourceUserId, String targetUserId) {
        return new APIusersIdUnblockRequest(sourceUserId, targetUserId);
    }

    private Call usersIdUnfollowCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{source_user_id}/following/{target_user_id}".replaceAll("\\{source_user_id\\}", this.localVarApiClient.escapeString(sourceUserId.toString())).replaceAll("\\{target_user_id\\}", this.localVarApiClient.escapeString(targetUserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdUnfollowValidateBeforeCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        if (sourceUserId == null) {
            throw new ApiException("Missing the required parameter 'sourceUserId' when calling usersIdUnfollow(Async)");
        }
        if (targetUserId == null) {
            throw new ApiException("Missing the required parameter 'targetUserId' when calling usersIdUnfollow(Async)");
        }
        Call localVarCall = this.usersIdUnfollowCall(sourceUserId, targetUserId, _callback);
        return localVarCall;
    }

    private ApiResponse<UsersFollowingDeleteResponse> usersIdUnfollowWithHttpInfo(String sourceUserId, String targetUserId) throws ApiException {
        Call localVarCall = this.usersIdUnfollowValidateBeforeCall(sourceUserId, targetUserId, null);
        try {
            Type localVarReturnType = new TypeToken<UsersFollowingDeleteResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdUnfollowAsync(String sourceUserId, String targetUserId, ApiCallback<UsersFollowingDeleteResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdUnfollowValidateBeforeCall(sourceUserId, targetUserId, _callback);
        Type localVarReturnType = new TypeToken<UsersFollowingDeleteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdUnfollowRequest usersIdUnfollow(String sourceUserId, String targetUserId) {
        return new APIusersIdUnfollowRequest(sourceUserId, targetUserId);
    }

    private Call usersIdUnmuteCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        Object localVarPostBody = null;
        String localVarPath = "/2/users/{source_user_id}/muting/{target_user_id}".replaceAll("\\{source_user_id\\}", this.localVarApiClient.escapeString(sourceUserId.toString())).replaceAll("\\{target_user_id\\}", this.localVarApiClient.escapeString(targetUserId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"OAuth2UserToken", "UserToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, this.reduceAuthNames(localVarAuthNames), _callback);
    }

    private Call usersIdUnmuteValidateBeforeCall(String sourceUserId, String targetUserId, ApiCallback _callback) throws ApiException {
        if (sourceUserId == null) {
            throw new ApiException("Missing the required parameter 'sourceUserId' when calling usersIdUnmute(Async)");
        }
        if (targetUserId == null) {
            throw new ApiException("Missing the required parameter 'targetUserId' when calling usersIdUnmute(Async)");
        }
        Call localVarCall = this.usersIdUnmuteCall(sourceUserId, targetUserId, _callback);
        return localVarCall;
    }

    private ApiResponse<MuteUserMutationResponse> usersIdUnmuteWithHttpInfo(String sourceUserId, String targetUserId) throws ApiException {
        Call localVarCall = this.usersIdUnmuteValidateBeforeCall(sourceUserId, targetUserId, null);
        try {
            Type localVarReturnType = new TypeToken<MuteUserMutationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((ProblemOrError)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ProblemOrError>(){}.getType()));
            throw e;
        }
    }

    private Call usersIdUnmuteAsync(String sourceUserId, String targetUserId, ApiCallback<MuteUserMutationResponse> _callback) throws ApiException {
        Call localVarCall = this.usersIdUnmuteValidateBeforeCall(sourceUserId, targetUserId, _callback);
        Type localVarReturnType = new TypeToken<MuteUserMutationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIusersIdUnmuteRequest usersIdUnmute(String sourceUserId, String targetUserId) {
        return new APIusersIdUnmuteRequest(sourceUserId, targetUserId);
    }

    public class APIusersIdUnmuteRequest {
        private final String sourceUserId;
        private final String targetUserId;

        private APIusersIdUnmuteRequest(String sourceUserId, String targetUserId) {
            this.sourceUserId = sourceUserId;
            this.targetUserId = targetUserId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.usersIdUnmuteCall(this.sourceUserId, this.targetUserId, _callback);
        }

        public MuteUserMutationResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.usersIdUnmuteWithHttpInfo(this.sourceUserId, this.targetUserId);
            return (MuteUserMutationResponse)localVarResp.getData();
        }

        public MuteUserMutationResponse execute(Integer retries) throws ApiException {
            MuteUserMutationResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<MuteUserMutationResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.usersIdUnmuteWithHttpInfo(this.sourceUserId, this.targetUserId);
        }

        public Call executeAsync(ApiCallback<MuteUserMutationResponse> _callback) throws ApiException {
            return UsersApi.this.usersIdUnmuteAsync(this.sourceUserId, this.targetUserId, _callback);
        }
    }

    public class APIusersIdUnfollowRequest {
        private final String sourceUserId;
        private final String targetUserId;

        private APIusersIdUnfollowRequest(String sourceUserId, String targetUserId) {
            this.sourceUserId = sourceUserId;
            this.targetUserId = targetUserId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.usersIdUnfollowCall(this.sourceUserId, this.targetUserId, _callback);
        }

        public UsersFollowingDeleteResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.usersIdUnfollowWithHttpInfo(this.sourceUserId, this.targetUserId);
            return (UsersFollowingDeleteResponse)localVarResp.getData();
        }

        public UsersFollowingDeleteResponse execute(Integer retries) throws ApiException {
            UsersFollowingDeleteResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<UsersFollowingDeleteResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.usersIdUnfollowWithHttpInfo(this.sourceUserId, this.targetUserId);
        }

        public Call executeAsync(ApiCallback<UsersFollowingDeleteResponse> _callback) throws ApiException {
            return UsersApi.this.usersIdUnfollowAsync(this.sourceUserId, this.targetUserId, _callback);
        }
    }

    public class APIusersIdUnblockRequest {
        private final String sourceUserId;
        private final String targetUserId;

        private APIusersIdUnblockRequest(String sourceUserId, String targetUserId) {
            this.sourceUserId = sourceUserId;
            this.targetUserId = targetUserId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.usersIdUnblockCall(this.sourceUserId, this.targetUserId, _callback);
        }

        public BlockUserMutationResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.usersIdUnblockWithHttpInfo(this.sourceUserId, this.targetUserId);
            return (BlockUserMutationResponse)localVarResp.getData();
        }

        public BlockUserMutationResponse execute(Integer retries) throws ApiException {
            BlockUserMutationResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<BlockUserMutationResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.usersIdUnblockWithHttpInfo(this.sourceUserId, this.targetUserId);
        }

        public Call executeAsync(ApiCallback<BlockUserMutationResponse> _callback) throws ApiException {
            return UsersApi.this.usersIdUnblockAsync(this.sourceUserId, this.targetUserId, _callback);
        }
    }

    public class APIusersIdMutingRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIusersIdMutingRequest(String id) {
            this.id = id;
        }

        public APIusersIdMutingRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIusersIdMutingRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIusersIdMutingRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIusersIdMutingRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIusersIdMutingRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.usersIdMutingCall(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2UsersIdMutingResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.usersIdMutingWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
            return (Get2UsersIdMutingResponse)localVarResp.getData();
        }

        public Get2UsersIdMutingResponse execute(Integer retries) throws ApiException {
            Get2UsersIdMutingResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdMutingResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.usersIdMutingWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdMutingResponse> _callback) throws ApiException {
            return UsersApi.this.usersIdMutingAsync(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIusersIdMuteRequest {
        private final String id;
        private MuteUserRequest muteUserRequest;

        private APIusersIdMuteRequest(String id) {
            this.id = id;
        }

        public APIusersIdMuteRequest muteUserRequest(MuteUserRequest muteUserRequest) {
            this.muteUserRequest = muteUserRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.usersIdMuteCall(this.muteUserRequest, this.id, _callback);
        }

        public MuteUserMutationResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.usersIdMuteWithHttpInfo(this.muteUserRequest, this.id);
            return (MuteUserMutationResponse)localVarResp.getData();
        }

        public MuteUserMutationResponse execute(Integer retries) throws ApiException {
            MuteUserMutationResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<MuteUserMutationResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.usersIdMuteWithHttpInfo(this.muteUserRequest, this.id);
        }

        public Call executeAsync(ApiCallback<MuteUserMutationResponse> _callback) throws ApiException {
            return UsersApi.this.usersIdMuteAsync(this.muteUserRequest, this.id, _callback);
        }
    }

    public class APIusersIdFollowingRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIusersIdFollowingRequest(String id) {
            this.id = id;
        }

        public APIusersIdFollowingRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIusersIdFollowingRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIusersIdFollowingRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIusersIdFollowingRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIusersIdFollowingRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.usersIdFollowingCall(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2UsersIdFollowingResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.usersIdFollowingWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
            return (Get2UsersIdFollowingResponse)localVarResp.getData();
        }

        public Get2UsersIdFollowingResponse execute(Integer retries) throws ApiException {
            Get2UsersIdFollowingResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdFollowingResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.usersIdFollowingWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdFollowingResponse> _callback) throws ApiException {
            return UsersApi.this.usersIdFollowingAsync(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIusersIdFollowersRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIusersIdFollowersRequest(String id) {
            this.id = id;
        }

        public APIusersIdFollowersRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIusersIdFollowersRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIusersIdFollowersRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIusersIdFollowersRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIusersIdFollowersRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.usersIdFollowersCall(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2UsersIdFollowersResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.usersIdFollowersWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
            return (Get2UsersIdFollowersResponse)localVarResp.getData();
        }

        public Get2UsersIdFollowersResponse execute(Integer retries) throws ApiException {
            Get2UsersIdFollowersResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdFollowersResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.usersIdFollowersWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdFollowersResponse> _callback) throws ApiException {
            return UsersApi.this.usersIdFollowersAsync(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIusersIdFollowRequest {
        private final String id;
        private UsersFollowingCreateRequest usersFollowingCreateRequest;

        private APIusersIdFollowRequest(String id) {
            this.id = id;
        }

        public APIusersIdFollowRequest usersFollowingCreateRequest(UsersFollowingCreateRequest usersFollowingCreateRequest) {
            this.usersFollowingCreateRequest = usersFollowingCreateRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.usersIdFollowCall(this.usersFollowingCreateRequest, this.id, _callback);
        }

        public UsersFollowingCreateResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.usersIdFollowWithHttpInfo(this.usersFollowingCreateRequest, this.id);
            return (UsersFollowingCreateResponse)localVarResp.getData();
        }

        public UsersFollowingCreateResponse execute(Integer retries) throws ApiException {
            UsersFollowingCreateResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<UsersFollowingCreateResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.usersIdFollowWithHttpInfo(this.usersFollowingCreateRequest, this.id);
        }

        public Call executeAsync(ApiCallback<UsersFollowingCreateResponse> _callback) throws ApiException {
            return UsersApi.this.usersIdFollowAsync(this.usersFollowingCreateRequest, this.id, _callback);
        }
    }

    public class APIusersIdBlockingRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIusersIdBlockingRequest(String id) {
            this.id = id;
        }

        public APIusersIdBlockingRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIusersIdBlockingRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIusersIdBlockingRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIusersIdBlockingRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIusersIdBlockingRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.usersIdBlockingCall(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2UsersIdBlockingResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.usersIdBlockingWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
            return (Get2UsersIdBlockingResponse)localVarResp.getData();
        }

        public Get2UsersIdBlockingResponse execute(Integer retries) throws ApiException {
            Get2UsersIdBlockingResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdBlockingResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.usersIdBlockingWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdBlockingResponse> _callback) throws ApiException {
            return UsersApi.this.usersIdBlockingAsync(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIusersIdBlockRequest {
        private final BlockUserRequest blockUserRequest;
        private final String id;

        private APIusersIdBlockRequest(BlockUserRequest blockUserRequest, String id) {
            this.blockUserRequest = blockUserRequest;
            this.id = id;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.usersIdBlockCall(this.blockUserRequest, this.id, _callback);
        }

        public BlockUserMutationResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.usersIdBlockWithHttpInfo(this.blockUserRequest, this.id);
            return (BlockUserMutationResponse)localVarResp.getData();
        }

        public BlockUserMutationResponse execute(Integer retries) throws ApiException {
            BlockUserMutationResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<BlockUserMutationResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.usersIdBlockWithHttpInfo(this.blockUserRequest, this.id);
        }

        public Call executeAsync(ApiCallback<BlockUserMutationResponse> _callback) throws ApiException {
            return UsersApi.this.usersIdBlockAsync(this.blockUserRequest, this.id, _callback);
        }
    }

    public class APItweetsIdRetweetingUsersRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APItweetsIdRetweetingUsersRequest(String id) {
            this.id = id;
        }

        public APItweetsIdRetweetingUsersRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APItweetsIdRetweetingUsersRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APItweetsIdRetweetingUsersRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APItweetsIdRetweetingUsersRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APItweetsIdRetweetingUsersRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.tweetsIdRetweetingUsersCall(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2TweetsIdRetweetedByResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.tweetsIdRetweetingUsersWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
            return (Get2TweetsIdRetweetedByResponse)localVarResp.getData();
        }

        public Get2TweetsIdRetweetedByResponse execute(Integer retries) throws ApiException {
            Get2TweetsIdRetweetedByResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2TweetsIdRetweetedByResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.tweetsIdRetweetingUsersWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2TweetsIdRetweetedByResponse> _callback) throws ApiException {
            return UsersApi.this.tweetsIdRetweetingUsersAsync(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APItweetsIdLikingUsersRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APItweetsIdLikingUsersRequest(String id) {
            this.id = id;
        }

        public APItweetsIdLikingUsersRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APItweetsIdLikingUsersRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APItweetsIdLikingUsersRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APItweetsIdLikingUsersRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APItweetsIdLikingUsersRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.tweetsIdLikingUsersCall(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2TweetsIdLikingUsersResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.tweetsIdLikingUsersWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
            return (Get2TweetsIdLikingUsersResponse)localVarResp.getData();
        }

        public Get2TweetsIdLikingUsersResponse execute(Integer retries) throws ApiException {
            Get2TweetsIdLikingUsersResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2TweetsIdLikingUsersResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.tweetsIdLikingUsersWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2TweetsIdLikingUsersResponse> _callback) throws ApiException {
            return UsersApi.this.tweetsIdLikingUsersAsync(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIlistGetMembersRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIlistGetMembersRequest(String id) {
            this.id = id;
        }

        public APIlistGetMembersRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIlistGetMembersRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIlistGetMembersRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIlistGetMembersRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIlistGetMembersRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.listGetMembersCall(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2ListsIdMembersResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.listGetMembersWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
            return (Get2ListsIdMembersResponse)localVarResp.getData();
        }

        public Get2ListsIdMembersResponse execute(Integer retries) throws ApiException {
            Get2ListsIdMembersResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2ListsIdMembersResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.listGetMembersWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2ListsIdMembersResponse> _callback) throws ApiException {
            return UsersApi.this.listGetMembersAsync(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIlistGetFollowersRequest {
        private final String id;
        private Integer maxResults;
        private String paginationToken;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIlistGetFollowersRequest(String id) {
            this.id = id;
        }

        public APIlistGetFollowersRequest maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public APIlistGetFollowersRequest paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public APIlistGetFollowersRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIlistGetFollowersRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIlistGetFollowersRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.listGetFollowersCall(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2ListsIdFollowersResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.listGetFollowersWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
            return (Get2ListsIdFollowersResponse)localVarResp.getData();
        }

        public Get2ListsIdFollowersResponse execute(Integer retries) throws ApiException {
            Get2ListsIdFollowersResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2ListsIdFollowersResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.listGetFollowersWithHttpInfo(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2ListsIdFollowersResponse> _callback) throws ApiException {
            return UsersApi.this.listGetFollowersAsync(this.id, this.maxResults, this.paginationToken, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIfindUsersByUsernameRequest {
        private final List<String> usernames;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIfindUsersByUsernameRequest(List<String> usernames) {
            this.usernames = usernames;
        }

        public APIfindUsersByUsernameRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindUsersByUsernameRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindUsersByUsernameRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.findUsersByUsernameCall(this.usernames, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2UsersByResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.findUsersByUsernameWithHttpInfo(this.usernames, this.userFields, this.expansions, this.tweetFields);
            return (Get2UsersByResponse)localVarResp.getData();
        }

        public Get2UsersByResponse execute(Integer retries) throws ApiException {
            Get2UsersByResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersByResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.findUsersByUsernameWithHttpInfo(this.usernames, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersByResponse> _callback) throws ApiException {
            return UsersApi.this.findUsersByUsernameAsync(this.usernames, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIfindUsersByIdRequest {
        private final List<String> ids;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIfindUsersByIdRequest(List<String> ids) {
            this.ids = ids;
        }

        public APIfindUsersByIdRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindUsersByIdRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindUsersByIdRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.findUsersByIdCall(this.ids, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2UsersResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.findUsersByIdWithHttpInfo(this.ids, this.userFields, this.expansions, this.tweetFields);
            return (Get2UsersResponse)localVarResp.getData();
        }

        public Get2UsersResponse execute(Integer retries) throws ApiException {
            Get2UsersResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.findUsersByIdWithHttpInfo(this.ids, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersResponse> _callback) throws ApiException {
            return UsersApi.this.findUsersByIdAsync(this.ids, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIfindUserByUsernameRequest {
        private final String username;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIfindUserByUsernameRequest(String username) {
            this.username = username;
        }

        public APIfindUserByUsernameRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindUserByUsernameRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindUserByUsernameRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.findUserByUsernameCall(this.username, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2UsersByUsernameUsernameResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.findUserByUsernameWithHttpInfo(this.username, this.userFields, this.expansions, this.tweetFields);
            return (Get2UsersByUsernameUsernameResponse)localVarResp.getData();
        }

        public Get2UsersByUsernameUsernameResponse execute(Integer retries) throws ApiException {
            Get2UsersByUsernameUsernameResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersByUsernameUsernameResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.findUserByUsernameWithHttpInfo(this.username, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersByUsernameUsernameResponse> _callback) throws ApiException {
            return UsersApi.this.findUserByUsernameAsync(this.username, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIfindUserByIdRequest {
        private final String id;
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIfindUserByIdRequest(String id) {
            this.id = id;
        }

        public APIfindUserByIdRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindUserByIdRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindUserByIdRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.findUserByIdCall(this.id, this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2UsersIdResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.findUserByIdWithHttpInfo(this.id, this.userFields, this.expansions, this.tweetFields);
            return (Get2UsersIdResponse)localVarResp.getData();
        }

        public Get2UsersIdResponse execute(Integer retries) throws ApiException {
            Get2UsersIdResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersIdResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.findUserByIdWithHttpInfo(this.id, this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersIdResponse> _callback) throws ApiException {
            return UsersApi.this.findUserByIdAsync(this.id, this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }

    public class APIfindMyUserRequest {
        private Set<String> userFields;
        private Set<String> expansions;
        private Set<String> tweetFields;

        private APIfindMyUserRequest() {
        }

        public APIfindMyUserRequest userFields(Set<String> userFields) {
            this.userFields = userFields;
            return this;
        }

        public APIfindMyUserRequest expansions(Set<String> expansions) {
            this.expansions = expansions;
            return this;
        }

        public APIfindMyUserRequest tweetFields(Set<String> tweetFields) {
            this.tweetFields = tweetFields;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UsersApi.this.findMyUserCall(this.userFields, this.expansions, this.tweetFields, _callback);
        }

        public Get2UsersMeResponse execute() throws ApiException {
            ApiResponse localVarResp = UsersApi.this.findMyUserWithHttpInfo(this.userFields, this.expansions, this.tweetFields);
            return (Get2UsersMeResponse)localVarResp.getData();
        }

        public Get2UsersMeResponse execute(Integer retries) throws ApiException {
            Get2UsersMeResponse localVarResp;
            try {
                localVarResp = this.execute();
            }
            catch (ApiException e) {
                if (UsersApi.this.handleRateLimit(e, retries)) {
                    return this.execute(retries - 1);
                }
                throw e;
            }
            return localVarResp;
        }

        public ApiResponse<Get2UsersMeResponse> executeWithHttpInfo() throws ApiException {
            return UsersApi.this.findMyUserWithHttpInfo(this.userFields, this.expansions, this.tweetFields);
        }

        public Call executeAsync(ApiCallback<Get2UsersMeResponse> _callback) throws ApiException {
            return UsersApi.this.findMyUserAsync(this.userFields, this.expansions, this.tweetFields, _callback);
        }
    }
}

