/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Problem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A problem that indicates your client is forbidden from making this request.")
public class ClientForbiddenProblem
extends Problem {
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private ReasonEnum reason;
    public static final String SERIALIZED_NAME_REGISTRATION_URL = "registration_url";
    @SerializedName(value="registration_url")
    private URL registrationUrl;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ClientForbiddenProblem() {
        this.type = this.getClass().getSimpleName();
    }

    public ClientForbiddenProblem reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public ClientForbiddenProblem registrationUrl(URL registrationUrl) {
        this.registrationUrl = registrationUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public URL getRegistrationUrl() {
        return this.registrationUrl;
    }

    public void setRegistrationUrl(URL registrationUrl) {
        this.registrationUrl = registrationUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientForbiddenProblem clientForbiddenProblem = (ClientForbiddenProblem)o;
        return Objects.equals((Object)this.reason, (Object)clientForbiddenProblem.reason) && Objects.equals(this.registrationUrl, clientForbiddenProblem.registrationUrl) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.registrationUrl, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientForbiddenProblem {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    registrationUrl: ").append(this.toIndentedString(this.registrationUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static ClientForbiddenProblem fromJson(String jsonString) throws IOException {
        return (ClientForbiddenProblem)JSON.getGson().fromJson(jsonString, ClientForbiddenProblem.class);
    }

    @Override
    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add("detail");
        openapiFields.add("status");
        openapiFields.add("title");
        openapiFields.add("type");
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_REGISTRATION_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add("title");
        openapiRequiredFields.add("type");
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ClientForbiddenProblem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ClientForbiddenProblem.class));
            return new TypeAdapter<ClientForbiddenProblem>(){

                public void write(JsonWriter out, ClientForbiddenProblem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ClientForbiddenProblem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ClientForbiddenProblem.validateJsonObject(jsonObj);
                    return (ClientForbiddenProblem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReasonEnum {
        OFFICIAL_CLIENT_FORBIDDEN("official-client-forbidden"),
        CLIENT_NOT_ENROLLED("client-not-enrolled");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReasonEnum> {
            public void write(JsonWriter jsonWriter, ReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReasonEnum.fromValue(value);
            }
        }
    }
}

