/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.integration.ApiTester;
import com.twitter.clientlib.model.BookmarkAddRequest;
import com.twitter.clientlib.model.BookmarkMutationResponse;
import com.twitter.clientlib.model.Get2UsersIdBookmarksResponse;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.Tweet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiBookmarksTester
extends ApiTester {
    @BeforeAll
    public void init() {
        this.initApiInstance();
    }

    @Test
    public void getUsersIdBookmarksTest() throws ApiException {
        Get2UsersIdBookmarksResponse result = this.apiInstance.bookmarks().getUsersIdBookmarks(this.userId).maxResults(this.maxResults).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        this.checkTweetData((Tweet)result.getData().get(0));
        this.checkTweetIncludes(result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getUsersIdBookmarksErrorTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.bookmarks().getUsersIdBookmarks("9999999999999").maxResults(this.maxResults).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void createDeleteBookmarkTest() throws ApiException {
        BookmarkAddRequest req = new BookmarkAddRequest();
        req.setTweetId(this.tweetIdPopular);
        BookmarkMutationResponse result = this.apiInstance.bookmarks().postUsersIdBookmarks(req, this.userId).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getBookmarked());
        BookmarkMutationResponse deleteResponse = this.apiInstance.bookmarks().usersIdBookmarksDelete(this.userId, this.tweetIdPopular).execute();
        this.checkErrors(false, deleteResponse.getErrors());
        Assertions.assertNotNull((Object)deleteResponse.getData());
        Assertions.assertFalse((boolean)deleteResponse.getData().getBookmarked());
    }

    @Test
    public void createTwiceBookmarkTest() throws ApiException {
        BookmarkAddRequest req = new BookmarkAddRequest();
        req.setTweetId(this.tweetIdPopular);
        this.apiInstance.bookmarks().postUsersIdBookmarks(req, this.userId);
        BookmarkMutationResponse result = this.apiInstance.bookmarks().postUsersIdBookmarks(req, this.userId).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getBookmarked());
        BookmarkMutationResponse deleteResponse = this.apiInstance.bookmarks().usersIdBookmarksDelete(this.userId, this.tweetIdPopular).execute();
        this.checkErrors(false, deleteResponse.getErrors());
        Assertions.assertNotNull((Object)deleteResponse.getData());
        Assertions.assertFalse((boolean)deleteResponse.getData().getBookmarked());
    }

    @Test
    public void usersIdBookmarksDeleteTweetNotFoundTest() throws ApiException {
        BookmarkMutationResponse result = this.apiInstance.bookmarks().usersIdBookmarksDelete(this.userId, this.tweetIdNotFound).execute();
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getBookmarked());
        this.checkErrors(false, result.getErrors());
    }

    @Test
    public void usersIdBookmarksDeleteUserNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.bookmarks().usersIdBookmarksDelete("9999999999999", this.tweetId).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void createDeleteTweetErrorTest() throws ApiException {
        BookmarkAddRequest req = new BookmarkAddRequest();
        req.setTweetId(this.tweetIdNotFound);
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.bookmarks().postUsersIdBookmarks(req, this.userId).execute());
        this.checkGenericProblem(exception.getErrorObject().getProblem(), "You cannot bookmark a Tweet that does not exist.", "Bad Request", 400);
    }
}

