/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.integration.ApiTester;
import com.twitter.clientlib.model.Get2SpacesByCreatorIdsResponse;
import com.twitter.clientlib.model.Get2SpacesIdResponse;
import com.twitter.clientlib.model.Get2SpacesIdTweetsResponse;
import com.twitter.clientlib.model.Get2SpacesResponse;
import com.twitter.clientlib.model.Get2SpacesSearchResponse;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.Space;
import com.twitter.clientlib.model.Tweet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiSpacesTester
extends ApiTester {
    private final Set<String> spaceFields = new HashSet<String>(Arrays.asList("creator_id", "id", "created_at", "title"));
    private final Set<String> spaceExpansions = new HashSet<String>(Arrays.asList("invited_user_ids", "speaker_ids", "creator_id", "host_ids"));
    private String spaceId;
    private List<String> spacesIds;
    private final String spaceIdNotFound = "1234567890abcd";
    private final List<String> spacesIdsNotFound = Arrays.asList("1234567890abcd");
    private final String spaceEndedId = "1ZkKzbpRMWdKv";
    private final String querySpaces = "Crypto";
    private final String querySpacesNotFound = "zaqwsx12";
    private final String stateAll = "all";

    public Space randomSpace(String query) throws ApiException {
        Space space = null;
        Get2SpacesSearchResponse result = this.apiInstance.spaces().searchSpaces(query).state("all").maxResults(this.maxResults).spaceFields(this.spaceFields).expansions(this.spaceExpansions).execute();
        if (result.getData() != null && result.getData().size() > 0) {
            space = (Space)result.getData().get(0);
        }
        return space;
    }

    @BeforeAll
    public void init() throws ApiException {
        this.initApiInstance();
        Space space = this.randomSpace("Crypto");
        if (space != null) {
            this.spaceId = space.getId();
            this.spacesIds = Arrays.asList(this.spaceId);
        }
    }

    @Test
    public void searchSpacesTest() throws ApiException {
        Get2SpacesSearchResponse result = this.apiInstance.spaces().searchSpaces("Crypto").state("all").maxResults(this.maxResults).spaceFields(this.spaceFields).expansions(this.spaceExpansions).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkSpaceData((Space)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
    }

    @Test
    public void searchSpacesNoSpacesTest() throws ApiException {
        Get2SpacesSearchResponse result = this.apiInstance.spaces().searchSpaces("zaqwsx12").state("all").maxResults(this.maxResults).spaceFields(this.spaceFields).expansions(this.spaceExpansions).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
    }

    @Test
    public void findSpacesByIdsTest() throws ApiException {
        Get2SpacesResponse result = this.apiInstance.spaces().findSpacesByIds(this.spacesIds).spaceFields(this.spaceFields).expansions(this.spaceExpansions).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkSpaceData((Space)result.getData().get(0));
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
    }

    @Test
    public void findSpacesByIdErrorTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().findSpacesByIds(this.spacesIdsNotFound).spaceFields(this.spaceFields).expansions(this.spaceExpansions).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `ids` query parameter value [1234567890abcd] does not match", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void findSpaceByIdTest() throws ApiException {
        Get2SpacesIdResponse result = this.apiInstance.spaces().findSpaceById(this.spaceId).spaceFields(this.spaceFields).expansions(this.spaceExpansions).execute();
        this.checkErrors(false, result.getErrors());
        this.checkSpaceData(result.getData());
        Assertions.assertNotNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getIncludes().getUsers());
    }

    @Test
    public void findSpaceByIdErrorTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().findSpaceById("1234567890abcd").spaceFields(this.spaceFields).expansions(this.spaceExpansions).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [1234567890abcd] does not match", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void findSpacesByCreatorIdsTest() throws ApiException {
        Get2SpacesByCreatorIdsResponse result = this.apiInstance.spaces().findSpacesByCreatorIds(this.usersIds).spaceFields(this.spaceFields).expansions(this.spaceExpansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getMeta());
        if (result.getData() != null) {
            this.checkSpaceData((Space)result.getData().get(0));
            Assertions.assertNotNull((Object)result.getIncludes());
            Assertions.assertNotNull((Object)result.getIncludes().getUsers());
            Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
        } else {
            Assertions.assertNotNull((Object)result.getMeta());
            Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
        }
    }

    @Test
    public void findSpacesByCreatorIdsCreatorNotFoundTest() throws ApiException {
        Get2SpacesByCreatorIdsResponse result = this.apiInstance.spaces().findSpacesByCreatorIds(this.usersIdsNotFound).spaceFields(this.spaceFields).expansions(this.spaceExpansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
    }

    @Test
    public void spaceBuyersNotSpaceOwnerTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().spaceBuyers(this.spaceId).userFields(this.userFields).execute());
        this.checkGenericProblem(exception.getErrorObject().getProblem(), "You do not have access to this information as you do not own the space.", "Forbidden", 403);
    }

    @Test
    public void spaceBuyersUserNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().spaceBuyers("1234567890abcd").userFields(this.userFields).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [1234567890abcd] does not match", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void spaceTweetsTest() throws ApiException {
        Get2SpacesIdTweetsResponse result = this.apiInstance.spaces().spaceTweets(this.spaceId).maxResults(this.maxResults).tweetFields(this.tweetFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getMeta());
        if (result.getData() != null) {
            this.checkTweetData((Tweet)result.getData().get(0));
            Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
        } else {
            Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
        }
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void spaceTweetsSpaceEndedTest() throws ApiException {
        Get2SpacesIdTweetsResponse get2SpacesIdTweetsResponse = this.apiInstance.spaces().spaceTweets("1ZkKzbpRMWdKv").maxResults(this.maxResults).tweetFields(this.tweetFields).execute();
        this.checkErrors(true, get2SpacesIdTweetsResponse.getErrors());
        List problems = get2SpacesIdTweetsResponse.getErrors();
        Assertions.assertEquals((int)1, (int)problems.size());
        this.checkResourceNotFoundProblem((Problem)problems.get(0), "1ZkKzbpRMWdKv", "Not Found Error", "id");
    }

    @Test
    public void spaceTweetsSpaceNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.spaces().spaceTweets("1234567890abcd").maxResults(this.maxResults).tweetFields(this.tweetFields).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [1234567890abcd] does not match", "Invalid Request", "One or more parameters to your request was invalid.");
    }
}

