/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.TwitterCredentialsBearer;
import com.twitter.clientlib.TwitterCredentialsOAuth2;
import com.twitter.clientlib.api.TwitterApi;
import com.twitter.clientlib.model.ComplianceJob;
import com.twitter.clientlib.model.DuplicateRuleProblem;
import com.twitter.clientlib.model.Expansions;
import com.twitter.clientlib.model.FieldUnauthorizedProblem;
import com.twitter.clientlib.model.GenericProblem;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.InvalidRequestProblemAllOfErrors;
import com.twitter.clientlib.model.ModelList;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.ResourceNotFoundProblem;
import com.twitter.clientlib.model.Space;
import com.twitter.clientlib.model.Tweet;
import com.twitter.clientlib.model.User;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;

public abstract class ApiTester {
    protected TwitterApi apiInstance;
    protected final Integer maxResults = 15;
    protected final Set<String> tweetFields = new HashSet<String>(Arrays.asList("author_id", "id", "created_at"));
    protected Set<String> expansions = new HashSet<String>(Collections.singletonList("author_id"));
    protected String tweetId = "20";
    protected String tweetIdNotFound = "12119879112120";
    protected String tweetIdPopular = "1354143047324299264";
    protected final Set<String> userFields = new HashSet<String>(Collections.singletonList("username"));
    protected final String userId = System.getenv("YOUR_TWITTER_USER_ID");
    protected final String popularUserId = "250831586";
    protected final String userNotExists = "9999999999999";
    protected final List<String> usersIds = Arrays.asList("250831586");
    protected final List<String> usersIdsNotFound = Arrays.asList("9999999999999");
    protected final Set<String> excludedTweetFields = new HashSet<String>(Arrays.asList("non_public_metrics", "promoted_metrics", "organic_metrics", "created_at"));
    protected final Set<String> excludedUserFields = new HashSet<String>(Arrays.asList("url", "profile_image_url", "description", "created_at"));

    protected void initApiInstance() {
        this.apiInstance = new TwitterApi(new TwitterCredentialsOAuth2(System.getenv("TWITTER_OAUTH2_CLIENT_ID"), System.getenv("TWITTER_OAUTH2_CLIENT_SECRET"), System.getenv("TWITTER_OAUTH2_ACCESS_TOKEN"), System.getenv("TWITTER_OAUTH2_REFRESH_TOKEN")));
    }

    protected void initApiInstanceBearer() {
        this.apiInstance = new TwitterApi(new TwitterCredentialsBearer(System.getenv("TWITTER_BEARER_TOKEN")));
    }

    protected void checkApiExceptionProblem(ApiException e, Class problemType, String message, String title, String detail) {
        Assertions.assertTrue((boolean)e.getErrorObject().getProblem().getClass().getName().equals(problemType.getName()));
        InvalidRequestProblem problem = (InvalidRequestProblem)e.getErrorObject().getProblem();
        Assertions.assertNotNull((Object)problem.getErrors());
        Assertions.assertNotNull(problem.getErrors().get(0));
        Assertions.assertNotNull((Object)((InvalidRequestProblemAllOfErrors)problem.getErrors().get(0)).getMessage());
        Assertions.assertTrue((boolean)((InvalidRequestProblemAllOfErrors)problem.getErrors().get(0)).getMessage().contains(message));
        Assertions.assertEquals((Object)problem.getTitle(), (Object)title);
        Assertions.assertEquals((Object)problem.getDetail(), (Object)detail);
    }

    protected void checkErrors(boolean assertTrue, List<Problem> errors) {
        boolean hasErrors;
        boolean bl = hasErrors = errors != null && errors.size() > 0;
        if (assertTrue) {
            Assertions.assertTrue((boolean)hasErrors);
        } else {
            Assertions.assertFalse((boolean)hasErrors);
        }
    }

    protected void checkTweetData(Tweet tweet) {
        Assertions.assertNotNull((Object)tweet);
        Assertions.assertNotNull((Object)tweet.getText());
        Assertions.assertNotNull((Object)tweet.getAuthorId());
        Assertions.assertNotNull((Object)tweet.getCreatedAt());
    }

    protected void checkTweetDataExclude(Tweet tweet) {
        Assertions.assertNotNull((Object)tweet);
        Assertions.assertNotNull((Object)tweet.getText());
        Assertions.assertNotNull((Object)tweet.getAuthorId());
        Assertions.assertNull((Object)tweet.getCreatedAt());
        Assertions.assertNull((Object)tweet.getNonPublicMetrics());
        Assertions.assertNull((Object)tweet.getPromotedMetrics());
        Assertions.assertNull((Object)tweet.getOrganicMetrics());
    }

    protected void checkTweetIncludes(Expansions expansions) {
        Assertions.assertNotNull((Object)expansions);
        Assertions.assertNotNull((Object)expansions.getUsers());
        Assertions.assertNotNull(expansions.getUsers().get(0));
        Assertions.assertNotNull((Object)((User)expansions.getUsers().get(0)).getUsername());
    }

    protected void checkUserData(User user) {
        Assertions.assertNotNull((Object)user);
        Assertions.assertNotNull((Object)user.getId());
        Assertions.assertNotNull((Object)user.getUsername());
        Assertions.assertNotNull((Object)user.getName());
    }

    protected void checkUserDataExclude(User user) {
        Assertions.assertNotNull((Object)user);
        Assertions.assertNotNull((Object)user.getId());
        Assertions.assertNotNull((Object)user.getUsername());
        Assertions.assertNotNull((Object)user.getName());
        Assertions.assertNull((Object)user.getCreatedAt());
        Assertions.assertNull((Object)user.getDescription());
        Assertions.assertNull((Object)user.getUrl());
        Assertions.assertNull((Object)user.getProfileImageUrl());
    }

    protected void checkSpaceData(Space space) {
        Assertions.assertNotNull((Object)space);
        Assertions.assertNotNull((Object)space.getId());
        Assertions.assertNotNull((Object)space.getCreatedAt());
        Assertions.assertNotNull((Object)space.getCreatorId());
        Assertions.assertNotNull((Object)space.getTitle());
    }

    protected void checkListData(ModelList list) {
        Assertions.assertNotNull((Object)list);
        Assertions.assertNotNull((Object)list.getId());
        Assertions.assertNotNull((Object)list.getCreatedAt());
        Assertions.assertNotNull((Object)list.getDescription());
        Assertions.assertNotNull((Object)list.getOwnerId());
        Assertions.assertNotNull((Object)list.getFollowerCount());
    }

    protected void checkComplianceJobData(ComplianceJob complianceJob) {
        Assertions.assertNotNull((Object)complianceJob);
        Assertions.assertNotNull((Object)complianceJob.getType());
        Assertions.assertNotNull((Object)complianceJob.getId());
        Assertions.assertNotNull((Object)complianceJob.getCreatedAt());
    }

    protected void checkModelListData(ModelList modelList) {
        Assertions.assertNotNull((Object)modelList);
        Assertions.assertNotNull((Object)modelList.getName());
        Assertions.assertNotNull((Object)modelList.getId());
        Assertions.assertNotNull((Object)modelList.getCreatedAt());
    }

    protected void checkResourceNotFoundProblem(Problem problem, String value, String title, String parameter) {
        Assertions.assertTrue((boolean)(problem instanceof ResourceNotFoundProblem));
        ResourceNotFoundProblem resourceNotFoundProblem = (ResourceNotFoundProblem)problem;
        Assertions.assertTrue((boolean)resourceNotFoundProblem.getTitle().equals(title));
        Assertions.assertEquals((Object)parameter, (Object)resourceNotFoundProblem.getParameter());
        Assertions.assertEquals((Object)value, (Object)resourceNotFoundProblem.getValue());
    }

    protected void checkGenericProblem(Problem problem, String detail, String title, Integer status) {
        Assertions.assertTrue((boolean)(problem instanceof GenericProblem));
        GenericProblem genericProblem = (GenericProblem)problem;
        Assertions.assertTrue((boolean)genericProblem.getTitle().equals(title));
        Assertions.assertEquals((Object)detail, (Object)genericProblem.getDetail());
        Assertions.assertEquals((Integer)status, (Integer)genericProblem.getStatus());
    }

    protected void checkInvalidRequestProblem(Problem problem, String detail, String title, String firstErrorMessage) {
        Assertions.assertTrue((boolean)(problem instanceof InvalidRequestProblem));
        InvalidRequestProblem invalidRequestProblem = (InvalidRequestProblem)problem;
        Assertions.assertTrue((boolean)invalidRequestProblem.getTitle().equals(title));
        Assertions.assertEquals((Object)detail, (Object)invalidRequestProblem.getDetail());
        Assertions.assertEquals((Object)firstErrorMessage, (Object)((InvalidRequestProblemAllOfErrors)invalidRequestProblem.getErrors().get(0)).getMessage());
    }

    protected void checkDuplicateRuleProblem(Problem problem, String detail, String value) {
        Assertions.assertTrue((boolean)(problem instanceof DuplicateRuleProblem));
        DuplicateRuleProblem duplicateProblem = (DuplicateRuleProblem)problem;
        Assertions.assertTrue((boolean)duplicateProblem.getTitle().equals("DuplicateRule"));
        Assertions.assertEquals((Object)value, (Object)duplicateProblem.getValue());
    }

    protected void checkFieldUnauthorizedProblem(Problem problem, String title, String field) {
        Assertions.assertTrue((boolean)(problem instanceof FieldUnauthorizedProblem));
        FieldUnauthorizedProblem fieldUnauthorizedProblem = (FieldUnauthorizedProblem)problem;
        Assertions.assertTrue((boolean)fieldUnauthorizedProblem.getTitle().equals(title));
        Assertions.assertEquals((Object)field, (Object)fieldUnauthorizedProblem.getField());
    }
}

