/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.integration.ApiTester;
import com.twitter.clientlib.model.AddOrDeleteRulesRequest;
import com.twitter.clientlib.model.AddOrDeleteRulesResponse;
import com.twitter.clientlib.model.AddRulesRequest;
import com.twitter.clientlib.model.DeleteRulesRequest;
import com.twitter.clientlib.model.DeleteRulesRequestDelete;
import com.twitter.clientlib.model.Get2TweetsCountsRecentResponse;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.Rule;
import com.twitter.clientlib.model.RuleNoId;
import com.twitter.clientlib.model.SearchCount;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiTweetBearerTester
extends ApiTester {
    private List<String> tweetIds;
    private List<String> tweetIdsNotFound;
    private String query;
    private String queryNotFound;
    private String ruleValue;

    public ApiTweetBearerTester() {
        this.tweetIds = Arrays.asList(this.tweetId);
        this.tweetIdsNotFound = Arrays.asList(this.tweetIdNotFound);
        this.query = "dog OR cat";
        this.queryNotFound = "queryNotFound zaq12wsx cde34rfv";
        this.ruleValue = "song";
    }

    @BeforeAll
    public void init() {
        this.initApiInstanceBearer();
    }

    private AddOrDeleteRulesResponse addRule(String ruleStrValue) throws ApiException {
        AddOrDeleteRulesRequest request = new AddOrDeleteRulesRequest();
        AddRulesRequest add = new AddRulesRequest();
        RuleNoId rule = new RuleNoId();
        rule.setValue(ruleStrValue);
        add.addAddItem(rule);
        request.setActualInstance((Object)add);
        return this.apiInstance.tweets().addOrDeleteRules(request).dryRun(Boolean.valueOf(false)).execute();
    }

    private AddOrDeleteRulesResponse deleteRule(String ruleStrValue) throws ApiException {
        AddOrDeleteRulesRequest request = new AddOrDeleteRulesRequest();
        DeleteRulesRequest dr = new DeleteRulesRequest();
        DeleteRulesRequestDelete drd = new DeleteRulesRequestDelete();
        drd.setValues(Arrays.asList(ruleStrValue));
        dr.setDelete(drd);
        request.setActualInstance((Object)dr);
        return this.apiInstance.tweets().addOrDeleteRules(request).dryRun(Boolean.valueOf(false)).execute();
    }

    @Test
    public void addOrDeleteRulesAddTest() throws ApiException {
        try {
            AddOrDeleteRulesResponse result = this.addRule(this.ruleValue);
            Assertions.assertNotNull((Object)result.getData());
            Assertions.assertNotNull(result.getData().get(0));
            Assertions.assertEquals((Object)((Rule)result.getData().get(0)).getValue(), (Object)this.ruleValue);
            Assertions.assertNotNull((Object)result.getMeta());
            Assertions.assertNotNull((Object)result.getMeta().getSent());
        }
        finally {
            this.deleteRule(this.ruleValue);
        }
    }

    @Test
    public void addOrDeleteRulesDoubleDeleteTest() throws ApiException {
        try {
            this.addRule(this.ruleValue);
            this.deleteRule(this.ruleValue);
            AddOrDeleteRulesResponse result = this.deleteRule(this.ruleValue);
            this.checkErrors(true, result.getErrors());
            Assertions.assertNull((Object)result.getData());
            Assertions.assertNotNull((Object)result.getMeta());
            Assertions.assertNotNull((Object)result.getMeta().getSent());
            Assertions.assertNotNull((Object)result.getMeta().getSummary());
            Assertions.assertNotNull((Object)result.getMeta().getSummary().getRulesRequestSummaryOneOf1());
            Assertions.assertEquals((int)result.getMeta().getSummary().getRulesRequestSummaryOneOf1().getDeleted(), (int)0);
            this.checkInvalidRequestProblem((Problem)result.getErrors().get(0), "One or more parameters to your request was invalid.", "Invalid Request", "Rule does not exist");
        }
        finally {
            this.deleteRule(this.ruleValue);
        }
    }

    @Test
    public void addOrDeleteRulesDeleteTest() throws ApiException {
        try {
            this.addRule(this.ruleValue);
            AddOrDeleteRulesResponse result = this.deleteRule(this.ruleValue);
            this.checkErrors(false, result.getErrors());
            Assertions.assertNull((Object)result.getData());
            Assertions.assertNotNull((Object)result.getMeta());
            Assertions.assertNotNull((Object)result.getMeta().getSent());
            Assertions.assertNotNull((Object)result.getMeta().getSummary());
            Assertions.assertNotNull((Object)result.getMeta().getSummary().getRulesRequestSummaryOneOf1());
            Assertions.assertEquals((int)result.getMeta().getSummary().getRulesRequestSummaryOneOf1().getDeleted(), (int)1);
        }
        finally {
            this.deleteRule(this.ruleValue);
        }
    }

    @Test
    public void addOrDeleteRulesAddDuplicateTest() throws ApiException {
        try {
            this.addRule(this.ruleValue);
            AddOrDeleteRulesResponse result = this.addRule(this.ruleValue);
            this.checkErrors(true, result.getErrors());
            Assertions.assertNull((Object)result.getData());
            Assertions.assertNotNull((Object)result.getMeta());
            Assertions.assertNotNull((Object)result.getMeta().getSent());
            Assertions.assertNotNull((Object)result.getMeta().getSummary());
            Assertions.assertNotNull((Object)result.getMeta().getSummary().getRulesRequestSummaryOneOf());
            Assertions.assertTrue((result.getMeta().getSummary().getRulesRequestSummaryOneOf().getInvalid() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((result.getMeta().getSummary().getRulesRequestSummaryOneOf().getNotCreated() > 0 ? 1 : 0) != 0);
            this.checkDuplicateRuleProblem((Problem)result.getErrors().get(0), null, this.ruleValue);
        }
        finally {
            this.deleteRule(this.ruleValue);
        }
    }

    @Test
    public void tweetCountsRecentSearchNotFoundTest() throws ApiException {
        Get2TweetsCountsRecentResponse result = this.apiInstance.tweets().tweetCountsRecentSearch(this.queryNotFound).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertNotNull(result.getData().get(0));
        Assertions.assertEquals((int)0, (int)((SearchCount)result.getData().get(0)).getTweetCount());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertEquals((int)0, (int)result.getMeta().getTotalTweetCount());
    }

    @Test
    public void tweetCountsRecentSearchTest() throws ApiException {
        Get2TweetsCountsRecentResponse result = this.apiInstance.tweets().tweetCountsRecentSearch(this.query).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertNotNull(result.getData().get(0));
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getTotalTweetCount() > 0 ? 1 : 0) != 0);
    }
}

