/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.integration.ApiTester;
import com.twitter.clientlib.model.Get2TweetsIdLikingUsersResponse;
import com.twitter.clientlib.model.Get2TweetsIdResponse;
import com.twitter.clientlib.model.Get2TweetsIdRetweetedByResponse;
import com.twitter.clientlib.model.Get2TweetsResponse;
import com.twitter.clientlib.model.Get2TweetsSearchRecentResponse;
import com.twitter.clientlib.model.Get2UsersIdLikedTweetsResponse;
import com.twitter.clientlib.model.Get2UsersIdMentionsResponse;
import com.twitter.clientlib.model.Get2UsersIdTimelinesReverseChronologicalResponse;
import com.twitter.clientlib.model.Get2UsersIdTweetsResponse;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.Tweet;
import com.twitter.clientlib.model.TweetCreateRequest;
import com.twitter.clientlib.model.TweetCreateRequestMedia;
import com.twitter.clientlib.model.TweetCreateResponse;
import com.twitter.clientlib.model.TweetCreateResponseData;
import com.twitter.clientlib.model.TweetDeleteResponse;
import com.twitter.clientlib.model.TweetDeleteResponseData;
import com.twitter.clientlib.model.User;
import com.twitter.clientlib.model.UsersLikesCreateRequest;
import com.twitter.clientlib.model.UsersLikesCreateResponse;
import com.twitter.clientlib.model.UsersLikesDeleteResponse;
import com.twitter.clientlib.model.UsersRetweetsCreateRequest;
import com.twitter.clientlib.model.UsersRetweetsCreateResponse;
import com.twitter.clientlib.model.UsersRetweetsDeleteResponse;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiTweetTester
extends ApiTester {
    private List<String> tweetIds;
    private List<String> tweetIdsNotFound;
    private String query;
    private String queryNotFound;
    private String ruleValue;

    public ApiTweetTester() {
        this.tweetIds = Arrays.asList(this.tweetId);
        this.tweetIdsNotFound = Arrays.asList(this.tweetIdNotFound);
        this.query = "dog OR cat";
        this.queryNotFound = "queryNotFound zaq12wsx cde34rfv";
        this.ruleValue = "song";
    }

    @BeforeAll
    public void init() {
        this.initApiInstance();
    }

    @Test
    public void findTweetByIdTest() throws ApiException {
        Get2TweetsIdResponse result = this.apiInstance.tweets().findTweetById(this.tweetId).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        this.checkTweetData(result.getData());
        this.checkTweetIncludes(result.getIncludes());
    }

    @Test
    public void findTweetByIdErrorTest() throws ApiException {
        Get2TweetsIdResponse result = this.apiInstance.tweets().findTweetById(this.tweetIdNotFound).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), this.tweetIdNotFound, "Not Found Error", "id");
    }

    @Test
    public void findTweetByIdExcludeInputFieldsTest() throws ApiException {
        Get2TweetsIdResponse result = this.apiInstance.tweets().findTweetById(this.tweetId).tweetFields(this.excludedTweetFields).excludeInputFields().execute();
        this.checkErrors(false, result.getErrors());
        this.checkTweetDataExclude(result.getData());
        this.checkTweetIncludes(result.getIncludes());
        this.checkUserData((User)result.getIncludes().getUsers().get(0));
    }

    @Test
    public void findTweetByIdExcludeInputFieldsErrorTest() throws ApiException {
        Get2TweetsIdResponse result = this.apiInstance.tweets().findTweetById(this.tweetId).excludeInputFields().execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkFieldUnauthorizedProblem((Problem)result.getErrors().get(0), "Field Authorization Error", "non_public_metrics.impression_count");
    }

    @Test
    public void findTweetsByIdTest() throws ApiException {
        Get2TweetsResponse result = this.apiInstance.tweets().findTweetsById(this.tweetIds).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkTweetData((Tweet)result.getData().get(0));
        this.checkTweetIncludes(result.getIncludes());
    }

    @Test
    public void findTweetsByIdErrorTest() throws ApiException {
        Get2TweetsResponse result = this.apiInstance.tweets().findTweetsById(this.tweetIdsNotFound).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), this.tweetIdNotFound, "Not Found Error", "ids");
    }

    @Test
    public void tweetsRecentSearchTest() throws ApiException {
        Get2TweetsSearchRecentResponse result = this.apiInstance.tweets().tweetsRecentSearch(this.query).maxResults(this.maxResults).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkTweetData((Tweet)result.getData().get(0));
        this.checkTweetIncludes(result.getIncludes());
    }

    @Test
    public void tweetsRecentSearchNoTweetFoundTest() throws ApiException {
        Get2TweetsSearchRecentResponse result = this.apiInstance.tweets().tweetsRecentSearch(this.queryNotFound).maxResults(this.maxResults).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
    }

    @Test
    public void createDeleteTweetTest() throws ApiException {
        TweetCreateRequest req = new TweetCreateRequest();
        req.setText("createTweetTest");
        TweetCreateResponse result = this.apiInstance.tweets().createTweet(req).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        TweetCreateResponseData tweet = result.getData();
        Assertions.assertNotNull((Object)tweet.getText());
        Assertions.assertNotNull((Object)tweet.getId());
        String toDeleteId = tweet.getId();
        TweetDeleteResponse deleteResponse = this.apiInstance.tweets().deleteTweetById(toDeleteId).execute();
        this.checkErrors(false, deleteResponse.getErrors());
        Assertions.assertNotNull((Object)deleteResponse.getData());
        TweetDeleteResponseData deleteData = deleteResponse.getData();
        Assertions.assertTrue((boolean)deleteData.getDeleted());
    }

    @Test
    public void deleteTweetByIdhTweetNotFoundTest() throws ApiException {
        TweetDeleteResponse result = this.apiInstance.tweets().deleteTweetById(this.tweetIdNotFound).execute();
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getDeleted());
        this.checkErrors(false, result.getErrors());
    }

    @Test
    public void createDeleteTweetErrorTest() throws ApiException {
        TweetCreateRequest req = new TweetCreateRequest();
        req.setText("createTweetTest");
        TweetCreateRequestMedia media = new TweetCreateRequestMedia();
        media.setMediaIds(Arrays.asList(this.tweetIdNotFound));
        req.setMedia(media);
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.tweets().createTweet(req).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "Your media IDs are invalid.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdTweetsTest() throws ApiException {
        Get2UsersIdTweetsResponse result = this.apiInstance.tweets().usersIdTweets(this.userId).maxResults(this.maxResults).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkTweetData((Tweet)result.getData().get(0));
        this.checkTweetIncludes(result.getIncludes());
    }

    @Test
    public void usersIdTweetsNotFoundTest() throws ApiException {
        Get2UsersIdTweetsResponse result = this.apiInstance.tweets().usersIdTweets("9999999999999").maxResults(this.maxResults).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void usersIdMentionsTest() throws ApiException {
        Get2UsersIdMentionsResponse result = this.apiInstance.tweets().usersIdMentions("250831586").maxResults(this.maxResults).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkTweetData((Tweet)result.getData().get(0));
        this.checkTweetIncludes(result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void usersIdMentionsNotFoundTest() throws ApiException {
        Get2UsersIdMentionsResponse result = this.apiInstance.tweets().usersIdMentions("9999999999999").maxResults(this.maxResults).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void tweetsIdRetweetingUsersTest() throws ApiException {
        Get2TweetsIdRetweetedByResponse result = this.apiInstance.users().tweetsIdRetweetingUsers(this.tweetIdPopular).maxResults(this.maxResults).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        User user = (User)result.getData().get(0);
        this.checkUserData(user);
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void tweetsIdRetweetingUsersNotFoundTest() throws ApiException {
        Get2TweetsIdRetweetedByResponse result = this.apiInstance.users().tweetsIdRetweetingUsers(this.tweetIdNotFound).maxResults(this.maxResults).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), this.tweetIdNotFound, "Not Found Error", "id");
    }

    @Test
    public void usersIdRetweetsTest() throws ApiException {
        UsersRetweetsCreateRequest usersRetweetsCreateRequest = new UsersRetweetsCreateRequest();
        usersRetweetsCreateRequest.setTweetId(this.tweetIdPopular);
        UsersRetweetsCreateResponse result = this.apiInstance.tweets().usersIdRetweets(this.userId).usersRetweetsCreateRequest(usersRetweetsCreateRequest).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getRetweeted());
    }

    @Test
    public void usersIdRetweetsNotFoundTest() throws ApiException {
        UsersRetweetsCreateRequest usersRetweetsCreateRequest = new UsersRetweetsCreateRequest();
        usersRetweetsCreateRequest.setTweetId(this.tweetIdNotFound);
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.tweets().usersIdRetweets(this.userId).usersRetweetsCreateRequest(usersRetweetsCreateRequest).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "This Tweet cannot be found.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnretweetsTest() throws ApiException {
        UsersRetweetsDeleteResponse result = this.apiInstance.tweets().usersIdUnretweets(this.userId, this.tweetIdPopular).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getRetweeted());
    }

    @Test
    public void usersIdUnretweetsNotFoundTest() throws ApiException {
        UsersRetweetsDeleteResponse result = this.apiInstance.tweets().usersIdUnretweets(this.userId, this.tweetIdPopular).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getRetweeted());
    }

    @Test
    public void tweetsIdLikingUsersTest() throws ApiException {
        Get2TweetsIdLikingUsersResponse result = this.apiInstance.users().tweetsIdLikingUsers(this.tweetIdPopular).maxResults(this.maxResults).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        User user = (User)result.getData().get(0);
        this.checkUserData(user);
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void tweetsIdLikingUsersNotFoundTest() throws ApiException {
        Get2TweetsIdLikingUsersResponse result = this.apiInstance.users().tweetsIdLikingUsers(this.tweetIdNotFound).maxResults(this.maxResults).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), this.tweetIdNotFound, "Not Found Error", "id");
    }

    @Test
    public void usersIdLikedTweetsTest() throws ApiException {
        Get2UsersIdLikedTweetsResponse result = this.apiInstance.tweets().usersIdLikedTweets("250831586").maxResults(this.maxResults).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkTweetData((Tweet)result.getData().get(0));
        this.checkTweetIncludes(result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void usersIdLikedTweetsNotFoundTest() throws ApiException {
        Get2UsersIdLikedTweetsResponse result = this.apiInstance.tweets().usersIdLikedTweets(this.tweetIdNotFound).maxResults(this.maxResults).tweetFields(this.tweetFields).expansions(this.expansions).userFields(this.userFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), this.tweetIdNotFound, "Not Found Error", "id");
    }

    @Test
    public void usersIdUnlikeTest() throws ApiException {
        UsersLikesDeleteResponse result = this.apiInstance.tweets().usersIdUnlike(this.userId, this.tweetIdPopular).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getLiked());
    }

    @Test
    public void usersIdLikeTest() throws ApiException {
        UsersLikesCreateRequest usersLikesCreateRequest = new UsersLikesCreateRequest();
        usersLikesCreateRequest.setTweetId(this.tweetIdPopular);
        UsersLikesCreateResponse result = this.apiInstance.tweets().usersIdLike(this.userId).usersLikesCreateRequest(usersLikesCreateRequest).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getLiked());
    }

    @Test
    public void usersIdLikeTweetNotFoundTest() throws ApiException {
        UsersLikesCreateRequest usersLikesCreateRequest = new UsersLikesCreateRequest();
        usersLikesCreateRequest.setTweetId(this.tweetIdNotFound);
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.tweets().usersIdLike(this.userId).usersLikesCreateRequest(usersLikesCreateRequest).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "This tweet cannot be found.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdLikeUserNotFoundTest() throws ApiException {
        UsersLikesCreateRequest usersLikesCreateRequest = new UsersLikesCreateRequest();
        usersLikesCreateRequest.setTweetId(this.tweetIdPopular);
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.tweets().usersIdLike("9999999999999").usersLikesCreateRequest(usersLikesCreateRequest).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user [" + this.userId + "]", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdTimelineTest() throws ApiException {
        Get2UsersIdTimelinesReverseChronologicalResponse result = this.apiInstance.tweets().usersIdTimeline(this.userId).userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkTweetData((Tweet)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void usersIdTimelineErrorTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.tweets().usersIdTimeline("9999999999999").userFields(this.userFields).tweetFields(this.tweetFields).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user [" + this.userId + "]", "Invalid Request", "One or more parameters to your request was invalid.");
    }
}

