/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.integration;

import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.integration.ApiTester;
import com.twitter.clientlib.model.BlockUserMutationResponse;
import com.twitter.clientlib.model.BlockUserRequest;
import com.twitter.clientlib.model.Get2ListsIdFollowersResponse;
import com.twitter.clientlib.model.Get2UsersByResponse;
import com.twitter.clientlib.model.Get2UsersByUsernameUsernameResponse;
import com.twitter.clientlib.model.Get2UsersIdBlockingResponse;
import com.twitter.clientlib.model.Get2UsersIdFollowersResponse;
import com.twitter.clientlib.model.Get2UsersIdFollowingResponse;
import com.twitter.clientlib.model.Get2UsersIdMutingResponse;
import com.twitter.clientlib.model.Get2UsersIdResponse;
import com.twitter.clientlib.model.Get2UsersMeResponse;
import com.twitter.clientlib.model.Get2UsersResponse;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.MuteUserMutationResponse;
import com.twitter.clientlib.model.MuteUserRequest;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.User;
import com.twitter.clientlib.model.UsersFollowingCreateRequest;
import com.twitter.clientlib.model.UsersFollowingCreateResponse;
import com.twitter.clientlib.model.UsersFollowingDeleteResponse;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ApiUserTester
extends ApiTester {
    private final String popularUsername = "TheRock";
    private final String usernameNotFound = "cprttfdgq";
    private final String listId = "84839422";
    private final String listIdNotFound = "11111112";
    private final List<String> usernames = Arrays.asList("TheRock");
    private final List<String> usernamesNotFounds = Arrays.asList("cprttfdgq");

    @BeforeAll
    public void init() {
        this.initApiInstance();
    }

    @Test
    public void findUserByIdTest() throws ApiException {
        Get2UsersIdResponse result = this.apiInstance.users().findUserById(this.userId).userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(false, result.getErrors());
        this.checkUserData(result.getData());
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void findUserByIdErrorTest() throws ApiException {
        Get2UsersIdResponse result = this.apiInstance.users().findUserById("9999999999999").userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
    }

    @Test
    public void findUserByIdExcludeInputFieldsTest() throws ApiException {
        Get2UsersIdResponse result = this.apiInstance.users().findUserById(this.userId).excludeInputFields().userFields(this.excludedUserFields).tweetFields(this.excludedTweetFields).execute();
        this.checkErrors(false, result.getErrors());
        this.checkUserDataExclude(result.getData());
    }

    @Test
    public void findUsersByIdTest() throws ApiException {
        Get2UsersResponse result = this.apiInstance.users().findUsersById(this.usersIds).userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void findUsersByIdErrorTest() throws ApiException {
        Get2UsersResponse result = this.apiInstance.users().findUsersById(this.usersIdsNotFound).userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "ids");
    }

    @Test
    public void findUserByUsernameTest() throws ApiException {
        Get2UsersByUsernameUsernameResponse result = this.apiInstance.users().findUserByUsername("TheRock").userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData(result.getData());
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void findUserByUsernameFoundTest() throws ApiException {
        Get2UsersByUsernameUsernameResponse result = this.apiInstance.users().findUserByUsername("cprttfdgq").userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "cprttfdgq", "Not Found Error", "username");
    }

    @Test
    public void findUsersByUsernameTest() throws ApiException {
        Get2UsersByResponse result = this.apiInstance.users().findUsersByUsername(this.usernames).userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void findUsersByUsernameNotFoundTest() throws ApiException {
        Get2UsersByResponse result = this.apiInstance.users().findUsersByUsername(this.usernamesNotFounds).userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "cprttfdgq", "Not Found Error", "usernames");
    }

    @Test
    public void findMyUserTest() throws ApiException {
        Get2UsersMeResponse result = this.apiInstance.users().findMyUser().userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData(result.getData());
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void usersIdFollowingTest() throws ApiException {
        Get2UsersIdFollowingResponse result = this.apiInstance.users().usersIdFollowing("250831586").maxResults(this.maxResults).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void usersIdFollowingNotFoundTest() throws ApiException {
        Get2UsersIdFollowingResponse result = this.apiInstance.users().usersIdFollowing("9999999999999").maxResults(this.maxResults).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
        Assertions.assertNull((Object)result.getMeta());
    }

    @Test
    public void usersIdFollowersTest() throws ApiException {
        Get2UsersIdFollowersResponse result = this.apiInstance.users().usersIdFollowers("250831586").maxResults(this.maxResults).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
        Assertions.assertNotNull((Object)result.getMeta());
        Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void usersIdFollowersNotFoundTest() throws ApiException {
        Get2UsersIdFollowersResponse result = this.apiInstance.users().usersIdFollowers("9999999999999").maxResults(this.maxResults).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "9999999999999", "Not Found Error", "id");
        Assertions.assertNull((Object)result.getMeta());
    }

    @Test
    public void usersIdFollowTest() throws ApiException {
        UsersFollowingCreateRequest request = new UsersFollowingCreateRequest();
        request.setTargetUserId("250831586");
        UsersFollowingCreateResponse result = this.apiInstance.users().usersIdFollow(this.userId).usersFollowingCreateRequest(request).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getFollowing());
        Assertions.assertFalse((boolean)result.getData().getPendingFollow());
    }

    @Test
    public void usersIdFollowFollowingNotFoundTest() throws ApiException {
        UsersFollowingCreateRequest request = new UsersFollowingCreateRequest();
        request.setTargetUserId("9999999999999");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdFollow(this.userId).usersFollowingCreateRequest(request).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot follow an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdFollowFollowerNotFoundTest() throws ApiException {
        UsersFollowingCreateRequest request = new UsersFollowingCreateRequest();
        request.setTargetUserId("250831586");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdFollow("9999999999999").usersFollowingCreateRequest(request).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnfollowTest() throws ApiException {
        UsersFollowingDeleteResponse result = this.apiInstance.users().usersIdUnfollow(this.userId, "250831586").execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getFollowing());
    }

    @Test
    public void usersIdUnfollowFollowingNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnfollow(this.userId, "9999999999999").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot unfollow an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnfollowFollowerNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnfollow("9999999999999", "250831586").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `source_user_id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdBlockingTest() throws ApiException {
        Get2UsersIdBlockingResponse result = this.apiInstance.users().usersIdBlocking(this.userId).maxResults(this.maxResults).execute();
        this.checkErrors(false, result.getErrors());
        if (result.getData() != null) {
            this.checkUserData((User)result.getData().get(0));
            Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
        } else {
            Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
            Assertions.assertNull((Object)result.getIncludes());
        }
        Assertions.assertNotNull((Object)result.getMeta());
    }

    @Test
    public void usersIdBlockingNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdBlocking("9999999999999").maxResults(this.maxResults).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdBlockTest() throws ApiException {
        BlockUserRequest request = new BlockUserRequest();
        request.setTargetUserId("250831586");
        BlockUserMutationResponse result = this.apiInstance.users().usersIdBlock(request, this.userId).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getBlocking());
    }

    @Test
    public void usersIdBlockBlockedNotFoundTest() throws ApiException {
        BlockUserRequest request = new BlockUserRequest();
        request.setTargetUserId("9999999999999");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdBlock(request, this.userId).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot block an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdBlockBlockingNotFoundTest() throws ApiException {
        BlockUserRequest request = new BlockUserRequest();
        request.setTargetUserId("250831586");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdBlock(request, "9999999999999").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnblockTest() throws ApiException {
        BlockUserMutationResponse result = this.apiInstance.users().usersIdUnblock(this.userId, "250831586").execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getBlocking());
    }

    @Test
    public void usersIdUnblockBlockedNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnblock(this.userId, "9999999999999").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot unblock an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnblockBlockingNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnblock("9999999999999", "250831586").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `source_user_id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdMutingTest() throws ApiException {
        Get2UsersIdMutingResponse result = this.apiInstance.users().usersIdMuting(this.userId).maxResults(this.maxResults).execute();
        this.checkErrors(false, result.getErrors());
        if (result.getData() != null) {
            this.checkUserData((User)result.getData().get(0));
            Assertions.assertTrue((result.getMeta().getResultCount() > 0 ? 1 : 0) != 0);
        } else {
            Assertions.assertEquals((int)0, (int)result.getMeta().getResultCount());
            Assertions.assertNull((Object)result.getIncludes());
        }
        Assertions.assertNotNull((Object)result.getMeta());
    }

    @Test
    public void usersIdMutingNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> {
            Get2UsersIdMutingResponse result = this.apiInstance.users().usersIdMuting("9999999999999").maxResults(this.maxResults).execute();
        });
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdMuteTest() throws ApiException {
        MuteUserRequest request = new MuteUserRequest();
        request.setTargetUserId("250831586");
        MuteUserMutationResponse result = this.apiInstance.users().usersIdMute(this.userId).muteUserRequest(request).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertTrue((boolean)result.getData().getMuting());
    }

    @Test
    public void usersIdMuteMutedNotFoundTest() throws ApiException {
        MuteUserRequest request = new MuteUserRequest();
        request.setTargetUserId("9999999999999");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdMute(this.userId).muteUserRequest(request).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot mute an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdMuteMutingNotFoundTest() throws ApiException {
        MuteUserRequest request = new MuteUserRequest();
        request.setTargetUserId("250831586");
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdMute("9999999999999").muteUserRequest(request).execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnmuteTest() throws ApiException {
        MuteUserMutationResponse result = this.apiInstance.users().usersIdUnmute(this.userId, "250831586").execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        Assertions.assertFalse((boolean)result.getData().getMuting());
    }

    @Test
    public void usersIdUnmuteMutedNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnmute(this.userId, "9999999999999").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "You cannot unmute an account that is not active.", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void usersIdUnmuteMutingNotFoundTest() throws ApiException {
        ApiException exception = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.apiInstance.users().usersIdUnmute("9999999999999", "250831586").execute());
        this.checkApiExceptionProblem(exception, InvalidRequestProblem.class, "The `source_user_id` query parameter value [9999999999999] must be the same as the authenticating user", "Invalid Request", "One or more parameters to your request was invalid.");
    }

    @Test
    public void listGetFollowersTest() throws ApiException {
        Get2ListsIdFollowersResponse result = this.apiInstance.users().listGetFollowers("84839422").userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(false, result.getErrors());
        Assertions.assertNotNull((Object)result.getData());
        this.checkUserData((User)result.getData().get(0));
        Assertions.assertNull((Object)result.getIncludes());
    }

    @Test
    public void listGetFollowersErrorTest() throws ApiException {
        Get2ListsIdFollowersResponse result = this.apiInstance.users().listGetFollowers("11111112").userFields(this.userFields).tweetFields(this.tweetFields).execute();
        this.checkErrors(true, result.getErrors());
        Assertions.assertNull((Object)result.getData());
        this.checkResourceNotFoundProblem((Problem)result.getErrors().get(0), "11111112", "Not Found Error", "id");
    }
}

