/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.TweetComplianceSchemaTweet;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TweetComplianceSchema {
    public static final String SERIALIZED_NAME_EVENT_AT = "event_at";
    @SerializedName(value="event_at")
    private OffsetDateTime eventAt;
    public static final String SERIALIZED_NAME_QUOTE_TWEET_ID = "quote_tweet_id";
    @SerializedName(value="quote_tweet_id")
    private String quoteTweetId;
    public static final String SERIALIZED_NAME_TWEET = "tweet";
    @SerializedName(value="tweet")
    private TweetComplianceSchemaTweet tweet;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetComplianceSchema eventAt(OffsetDateTime eventAt) {
        this.eventAt = eventAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2021-07-06T18:40:40Z", required=true, value="Event time.")
    public OffsetDateTime getEventAt() {
        return this.eventAt;
    }

    public void setEventAt(OffsetDateTime eventAt) {
        this.eventAt = eventAt;
    }

    public TweetComplianceSchema quoteTweetId(String quoteTweetId) {
        this.quoteTweetId = quoteTweetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1346889436626259968", value="Unique identifier of this Tweet. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getQuoteTweetId() {
        return this.quoteTweetId;
    }

    public void setQuoteTweetId(String quoteTweetId) {
        this.quoteTweetId = quoteTweetId;
    }

    public TweetComplianceSchema tweet(TweetComplianceSchemaTweet tweet) {
        this.tweet = tweet;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public TweetComplianceSchemaTweet getTweet() {
        return this.tweet;
    }

    public void setTweet(TweetComplianceSchemaTweet tweet) {
        this.tweet = tweet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetComplianceSchema tweetComplianceSchema = (TweetComplianceSchema)o;
        return Objects.equals(this.eventAt, tweetComplianceSchema.eventAt) && Objects.equals(this.quoteTweetId, tweetComplianceSchema.quoteTweetId) && Objects.equals(this.tweet, tweetComplianceSchema.tweet);
    }

    public int hashCode() {
        return Objects.hash(this.eventAt, this.quoteTweetId, this.tweet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetComplianceSchema {\n");
        sb.append("    eventAt: ").append(this.toIndentedString(this.eventAt)).append("\n");
        sb.append("    quoteTweetId: ").append(this.toIndentedString(this.quoteTweetId)).append("\n");
        sb.append("    tweet: ").append(this.toIndentedString(this.tweet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QUOTE_TWEET_ID) != null && !jsonObj.get(SERIALIZED_NAME_QUOTE_TWEET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `quote_tweet_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QUOTE_TWEET_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TWEET) != null) {
            TweetComplianceSchemaTweet.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TWEET));
        }
    }

    public static TweetComplianceSchema fromJson(String jsonString) throws IOException {
        return (TweetComplianceSchema)JSON.getGson().fromJson(jsonString, TweetComplianceSchema.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EVENT_AT);
        openapiFields.add(SERIALIZED_NAME_QUOTE_TWEET_ID);
        openapiFields.add(SERIALIZED_NAME_TWEET);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_TWEET);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetComplianceSchema.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetComplianceSchema.class));
            return new TypeAdapter<TweetComplianceSchema>(){

                public void write(JsonWriter out, TweetComplianceSchema value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetComplianceSchema read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetComplianceSchema.validateJsonObject(jsonObj);
                    return (TweetComplianceSchema)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

