/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TweetEditControls {
    public static final String SERIALIZED_NAME_EDITABLE_UNTIL = "editable_until";
    @SerializedName(value="editable_until")
    private OffsetDateTime editableUntil;
    public static final String SERIALIZED_NAME_EDITS_REMAINING = "edits_remaining";
    @SerializedName(value="edits_remaining")
    private Integer editsRemaining;
    public static final String SERIALIZED_NAME_IS_EDIT_ELIGIBLE = "is_edit_eligible";
    @SerializedName(value="is_edit_eligible")
    private Boolean isEditEligible;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetEditControls editableUntil(OffsetDateTime editableUntil) {
        this.editableUntil = editableUntil;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2021-01-06T18:40:40Z", required=true, value="Time when Tweet is no longer editable.")
    public OffsetDateTime getEditableUntil() {
        return this.editableUntil;
    }

    public void setEditableUntil(OffsetDateTime editableUntil) {
        this.editableUntil = editableUntil;
    }

    public TweetEditControls editsRemaining(Integer editsRemaining) {
        this.editsRemaining = editsRemaining;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of times this Tweet can be edited.")
    public Integer getEditsRemaining() {
        return this.editsRemaining;
    }

    public void setEditsRemaining(Integer editsRemaining) {
        this.editsRemaining = editsRemaining;
    }

    public TweetEditControls isEditEligible(Boolean isEditEligible) {
        this.isEditEligible = isEditEligible;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="false", required=true, value="Indicates if this Tweet is eligible to be edited.")
    public Boolean getIsEditEligible() {
        return this.isEditEligible;
    }

    public void setIsEditEligible(Boolean isEditEligible) {
        this.isEditEligible = isEditEligible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetEditControls tweetEditControls = (TweetEditControls)o;
        return Objects.equals(this.editableUntil, tweetEditControls.editableUntil) && Objects.equals(this.editsRemaining, tweetEditControls.editsRemaining) && Objects.equals(this.isEditEligible, tweetEditControls.isEditEligible);
    }

    public int hashCode() {
        return Objects.hash(this.editableUntil, this.editsRemaining, this.isEditEligible);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetEditControls {\n");
        sb.append("    editableUntil: ").append(this.toIndentedString(this.editableUntil)).append("\n");
        sb.append("    editsRemaining: ").append(this.toIndentedString(this.editsRemaining)).append("\n");
        sb.append("    isEditEligible: ").append(this.toIndentedString(this.isEditEligible)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static TweetEditControls fromJson(String jsonString) throws IOException {
        return (TweetEditControls)JSON.getGson().fromJson(jsonString, TweetEditControls.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EDITABLE_UNTIL);
        openapiFields.add(SERIALIZED_NAME_EDITS_REMAINING);
        openapiFields.add(SERIALIZED_NAME_IS_EDIT_ELIGIBLE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_EDITABLE_UNTIL);
        openapiRequiredFields.add(SERIALIZED_NAME_EDITS_REMAINING);
        openapiRequiredFields.add(SERIALIZED_NAME_IS_EDIT_ELIGIBLE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetEditControls.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetEditControls.class));
            return new TypeAdapter<TweetEditControls>(){

                public void write(JsonWriter out, TweetEditControls value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetEditControls read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetEditControls.validateJsonObject(jsonObj);
                    return (TweetEditControls)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

