/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.UrlImage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represent the portion of text recognized as a URL.")
public class UrlFields {
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DISPLAY_URL = "display_url";
    @SerializedName(value="display_url")
    private String displayUrl;
    public static final String SERIALIZED_NAME_EXPANDED_URL = "expanded_url";
    @SerializedName(value="expanded_url")
    private URL expandedUrl;
    public static final String SERIALIZED_NAME_IMAGES = "images";
    @SerializedName(value="images")
    private List<UrlImage> images = null;
    public static final String SERIALIZED_NAME_MEDIA_KEY = "media_key";
    @SerializedName(value="media_key")
    private String mediaKey;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private Integer status;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_UNWOUND_URL = "unwound_url";
    @SerializedName(value="unwound_url")
    private URL unwoundUrl;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private URL url;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UrlFields description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is a description of the website.", value="Description of the URL landing page.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UrlFields displayUrl(String displayUrl) {
        this.displayUrl = displayUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="twittercommunity.com/t/introducing-\u2026", value="The URL as displayed in the Twitter client.")
    public String getDisplayUrl() {
        return this.displayUrl;
    }

    public void setDisplayUrl(String displayUrl) {
        this.displayUrl = displayUrl;
    }

    public UrlFields expandedUrl(URL expandedUrl) {
        this.expandedUrl = expandedUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://developer.twitter.com/en/docs/twitter-api", value="A validly formatted URL.")
    public URL getExpandedUrl() {
        return this.expandedUrl;
    }

    public void setExpandedUrl(URL expandedUrl) {
        this.expandedUrl = expandedUrl;
    }

    public UrlFields images(List<UrlImage> images) {
        this.images = images;
        return this;
    }

    public UrlFields addImagesItem(UrlImage imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<UrlImage>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<UrlImage> getImages() {
        return this.images;
    }

    public void setImages(List<UrlImage> images) {
        this.images = images;
    }

    public UrlFields mediaKey(String mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Media Key identifier for this attachment.")
    public String getMediaKey() {
        return this.mediaKey;
    }

    public void setMediaKey(String mediaKey) {
        this.mediaKey = mediaKey;
    }

    public UrlFields status(Integer status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HTTP Status Code.")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public UrlFields title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Introducing the v2 follow lookup endpoints", value="Title of the page the URL points to.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UrlFields unwoundUrl(URL unwoundUrl) {
        this.unwoundUrl = unwoundUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://twittercommunity.com/t/introducing-the-v2-follow-lookup-endpoints/147118", value="Fully resolved url.")
    public URL getUnwoundUrl() {
        return this.unwoundUrl;
    }

    public void setUnwoundUrl(URL unwoundUrl) {
        this.unwoundUrl = unwoundUrl;
    }

    public UrlFields url(URL url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://developer.twitter.com/en/docs/twitter-api", required=true, value="A validly formatted URL.")
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlFields urlFields = (UrlFields)o;
        return Objects.equals(this.description, urlFields.description) && Objects.equals(this.displayUrl, urlFields.displayUrl) && Objects.equals(this.expandedUrl, urlFields.expandedUrl) && Objects.equals(this.images, urlFields.images) && Objects.equals(this.mediaKey, urlFields.mediaKey) && Objects.equals(this.status, urlFields.status) && Objects.equals(this.title, urlFields.title) && Objects.equals(this.unwoundUrl, urlFields.unwoundUrl) && Objects.equals(this.url, urlFields.url);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.displayUrl, this.expandedUrl, this.images, this.mediaKey, this.status, this.title, this.unwoundUrl, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UrlFields {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayUrl: ").append(this.toIndentedString(this.displayUrl)).append("\n");
        sb.append("    expandedUrl: ").append(this.toIndentedString(this.expandedUrl)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    mediaKey: ").append(this.toIndentedString(this.mediaKey)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    unwoundUrl: ").append(this.toIndentedString(this.unwoundUrl)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DISPLAY_URL) != null && !jsonObj.get(SERIALIZED_NAME_DISPLAY_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `display_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DISPLAY_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPANDED_URL) != null && !jsonObj.get(SERIALIZED_NAME_EXPANDED_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expanded_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPANDED_URL).toString()));
        }
        JsonArray jsonArrayimages = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGES);
        if (jsonArrayimages != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IMAGES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `images` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGES).toString()));
            }
            for (int i = 0; i < jsonArrayimages.size(); ++i) {
                UrlImage.validateJsonObject(jsonArrayimages.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_MEDIA_KEY) != null && !jsonObj.get(SERIALIZED_NAME_MEDIA_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `media_key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEDIA_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNWOUND_URL) != null && !jsonObj.get(SERIALIZED_NAME_UNWOUND_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unwound_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNWOUND_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
    }

    public static UrlFields fromJson(String jsonString) throws IOException {
        return (UrlFields)JSON.getGson().fromJson(jsonString, UrlFields.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_DISPLAY_URL);
        openapiFields.add(SERIALIZED_NAME_EXPANDED_URL);
        openapiFields.add(SERIALIZED_NAME_IMAGES);
        openapiFields.add(SERIALIZED_NAME_MEDIA_KEY);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_UNWOUND_URL);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_URL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UrlFields.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UrlFields.class));
            return new TypeAdapter<UrlFields>(){

                public void write(JsonWriter out, UrlFields value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UrlFields read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UrlFields.validateJsonObject(jsonObj);
                    return (UrlFields)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

