/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cherami.example;

import java.nio.ByteBuffer;

public class AppData {
    private static int HEADER_SIZE = 12;
    public final long id;
    public final byte[] payload;

    public AppData(long id, byte[] payload) {
        this.id = id;
        this.payload = payload;
    }

    public byte[] serialize() {
        ByteBuffer buf = ByteBuffer.allocate(HEADER_SIZE + this.payload.length);
        buf.putLong(this.id);
        buf.putInt(this.payload.length);
        buf.put(this.payload);
        buf.flip();
        return buf.array();
    }

    public static AppData deserialize(byte[] bytes) {
        if (bytes.length < HEADER_SIZE) {
            throw new RuntimeException("Packet size too small");
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        long id = buf.getLong();
        int length = buf.getInt();
        byte[] payload = new byte[length];
        buf.get(payload);
        return new AppData(id, payload);
    }
}

