/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cherami.example;

import java.util.Random;

public class Config {
    public final String ip;
    public final int port;
    public final String destinationPath;
    public final String consumergroupName;
    public final int nPublishers;
    public final int nConsumers;
    public final int nMessagesToSend;
    public final int messageSize;
    public final boolean useAsync;

    Config(String ip, int port, String dstPath, String cgName, int nPublishers, int nConsumers, int nMessagesToSend, int messageSize, boolean useAsync) {
        this.ip = ip;
        this.port = port;
        this.destinationPath = dstPath;
        this.consumergroupName = cgName;
        this.nPublishers = nPublishers;
        this.nConsumers = nConsumers;
        this.nMessagesToSend = nMessagesToSend / nPublishers;
        this.messageSize = messageSize;
        this.useAsync = useAsync;
    }

    private static void printHelp() {
        System.out.println("Usage: java com.uber.cherami.example.Demo\n\t--endpoint=[frontEndIP:Port]   Cherami server ip address and port number\n\t--nMsgsToSend=[nMsgsToSend]    Total number of messages to publish\n\t--msgSize=[msgSize]            Size of each published message\n\t--nPublishers=[nPublishers]    Number of publisher threads, optional\n\t--nConsumers=[nConsumers]      Number of consumer threads, optional\n\t--useAsync=[true]              Use async api, defaults to sync api\n\t--help                         Prints this message");
    }

    private static void parseError(String arg) {
        System.out.println("ParseError: " + arg);
        Config.printHelp();
        System.exit(1);
    }

    public static Config parse(String[] args) {
        if (args.length < 2) {
            Config.parseError("Not enough arguments");
        }
        int send = 0;
        int size = 0;
        int port = 0;
        int nPublishers = 1;
        int nConsumers = 1;
        boolean useAsync = false;
        String ip = "";
        try {
            block18: for (int i = 0; i < args.length; ++i) {
                String[] nameValue = args[i].split("=");
                if (nameValue.length != 2) {
                    Config.parseError(nameValue[0]);
                }
                switch (nameValue[0]) {
                    case "--nMsgsToSend": {
                        send = Integer.parseInt(nameValue[1]);
                        continue block18;
                    }
                    case "--msgSize": {
                        size = Integer.parseInt(nameValue[1]);
                        continue block18;
                    }
                    case "--nPublishers": {
                        nPublishers = Integer.parseInt(nameValue[1]);
                        continue block18;
                    }
                    case "--nConsumers": {
                        nConsumers = Integer.parseInt(nameValue[1]);
                        continue block18;
                    }
                    case "--useAsync": {
                        useAsync = true;
                        continue block18;
                    }
                    case "--endpoint": {
                        String[] ipPort = nameValue[1].split(":");
                        if (ipPort.length != 2) {
                            Config.parseError(nameValue[0]);
                        }
                        ip = ipPort[0];
                        port = Integer.parseInt(ipPort[1]);
                        continue block18;
                    }
                    default: {
                        Config.parseError("Unknown arg " + nameValue[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            Config.parseError(e.getMessage());
        }
        if (send == 0 || size == 0) {
            Config.parseError("--nMsgsToSend and --msgSize must be greater than zero");
        }
        String dstPath = String.format("/test/java.example_%d", new Random().nextInt(Integer.MAX_VALUE));
        String cgName = String.format("%s_reader", dstPath);
        return new Config(ip, port, dstPath, cgName, nPublishers, nConsumers, send, size, useAsync);
    }
}

