/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cherami.example;

import com.uber.cherami.ChecksumOption;
import com.uber.cherami.ConsumerGroupDescription;
import com.uber.cherami.CreateConsumerGroupRequest;
import com.uber.cherami.CreateDestinationRequest;
import com.uber.cherami.DeleteConsumerGroupRequest;
import com.uber.cherami.DeleteDestinationRequest;
import com.uber.cherami.DestinationDescription;
import com.uber.cherami.DestinationType;
import com.uber.cherami.client.CheramiClient;
import com.uber.cherami.client.ClientOptions;
import com.uber.cherami.example.Async;
import com.uber.cherami.example.Config;
import com.uber.cherami.example.Context;
import com.uber.cherami.example.Daemon;
import com.uber.cherami.example.Sync;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class Demo
implements Runnable {
    private static final int CONSUMED_MESSAGES_RETENTION_SECONDS = 3600;
    private static final int UNCONSUMED_MESSAGES_RETENTION_SECONDS = 7200;
    private final Context context;

    public Demo(Config config) {
        this.context = new Context(config, Demo.buildClient(config));
    }

    @Override
    public void run() {
        int i;
        final Config config = this.context.config;
        Demo.doSetup(this.context.client, config.destinationPath, config.consumergroupName);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Demo.doTearDown(((Demo)Demo.this).context.client, config.destinationPath, config.consumergroupName);
                try {
                    ((Demo)Demo.this).context.client.close();
                }
                catch (Exception e) {
                    System.out.println("Exception closing cheramiClient " + e);
                }
            }
        });
        Daemon[] consumers = new Daemon[config.nConsumers];
        for (int i2 = 0; i2 < config.nConsumers; ++i2) {
            String name = "consumer-" + i2;
            consumers[i2] = this.createConsumer(name);
            consumers[i2].start();
        }
        Daemon[] publishers = new Daemon[config.nPublishers];
        for (int i3 = 0; i3 < config.nPublishers; ++i3) {
            String name = "publisher-" + i3;
            publishers[i3] = this.createPublisher(name);
            publishers[i3].start();
        }
        long startTimeMillis = System.currentTimeMillis();
        long nMessagesToReceive = config.nPublishers * config.nMessagesToSend;
        while ((long)this.context.consumedMsgIds.size() < nMessagesToReceive) {
            Demo.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        System.out.println("Stopping publishers and consumers...");
        for (i = 0; i < config.nPublishers; ++i) {
            publishers[i].stop();
        }
        for (i = 0; i < config.nConsumers; ++i) {
            consumers[i].stop();
        }
        this.context.stats.print(System.currentTimeMillis() - startTimeMillis);
        System.exit(0);
    }

    private Daemon createPublisher(String name) {
        if (this.context.config.useAsync) {
            return new Async.Publisher(name, this.context);
        }
        return new Sync.Publisher(name, this.context);
    }

    private Daemon createConsumer(String name) {
        if (this.context.config.useAsync) {
            return new Async.Consumer(name, this.context);
        }
        return new Sync.Consumer(name, this.context);
    }

    private static CheramiClient buildClient(Config config) {
        try {
            ClientOptions options = new ClientOptions.Builder().setDeploymentStr("staging").build();
            if (!config.ip.isEmpty()) {
                return new CheramiClient.Builder(config.ip, config.port).setClientOptions(options).build();
            }
            return new CheramiClient.Builder().setClientOptions(options).build();
        }
        catch (Exception e) {
            System.out.println("Failed to create CheramiClient:" + e);
            throw new RuntimeException(e);
        }
    }

    private static void doSetup(CheramiClient client, String dstPath, String cgName) {
        try {
            CreateDestinationRequest dstRequest = new CreateDestinationRequest();
            dstRequest.setPath(dstPath);
            dstRequest.setType(DestinationType.PLAIN);
            dstRequest.setUnconsumedMessagesRetention(7200);
            dstRequest.setConsumedMessagesRetention(3600);
            dstRequest.setOwnerEmail("cherami-client-example@uber.com");
            dstRequest.setChecksumOption(ChecksumOption.CRC32IEEE);
            DestinationDescription producer = client.createDestination(dstRequest);
            System.out.println("Created Destination:\n" + producer);
            CreateConsumerGroupRequest cgRequest = new CreateConsumerGroupRequest();
            cgRequest.setDestinationPath(dstPath);
            cgRequest.setConsumerGroupName(cgName);
            cgRequest.setOwnerEmail("cherami-client-example@uber.com");
            cgRequest.setMaxDeliveryCount(3);
            cgRequest.setSkipOlderMessagesInSeconds(3600);
            cgRequest.setLockTimeoutInSeconds(60);
            cgRequest.setStartFrom(System.nanoTime());
            ConsumerGroupDescription consumerGroup = client.createConsumerGroup(cgRequest);
            System.out.println("Created Consumer Group:\n" + consumerGroup);
        }
        catch (Exception e) {
            System.out.println("Error setting up destination and consumer group:" + e);
            throw new RuntimeException(e);
        }
    }

    private static void doTearDown(CheramiClient client, String dstPath, String cgName) {
        DeleteConsumerGroupRequest cgRequest = new DeleteConsumerGroupRequest();
        cgRequest.setDestinationPath(dstPath);
        cgRequest.setConsumerGroupName(cgName);
        try {
            client.deleteConsumerGroup(cgRequest);
            System.out.println("Deleted ConsumerGroup " + cgName);
        }
        catch (Exception e) {
            System.out.println("Error deleting consumer group:" + e);
        }
        DeleteDestinationRequest dstRequest = new DeleteDestinationRequest();
        dstRequest.setPath(dstPath);
        try {
            client.deleteDestination(dstRequest);
            System.out.println("Deleted Destination " + dstPath);
        }
        catch (Exception e) {
            System.out.println("Error deleting destination:" + e);
        }
        try {
            client.close();
        }
        catch (IOException e) {
            System.out.println("Error closing CheramiClient:" + e);
        }
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Config config = Config.parse(args);
        new Demo(config).run();
    }
}

