/*
 * Decompiled with CFR 0.152.
 */
package com.uber.cherami.example;

import java.util.concurrent.atomic.AtomicLong;

public class Stats {
    public AtomicLong messagesOutCount = new AtomicLong();
    public AtomicLong bytesOutCount = new AtomicLong();
    public AtomicLong messagesInCount = new AtomicLong();
    public AtomicLong messagesInDupCount = new AtomicLong();
    public AtomicLong bytesInCount = new AtomicLong();
    public AtomicLong messagesOutErrCount = new AtomicLong();
    public AtomicLong messagesOutThrottledCount = new AtomicLong();
    public final Latency writeLatency = new Latency();
    public final Latency readLatency = new Latency();

    public void print(long totalReportedTimeMillis) {
        System.out.println("\n-------METRICS------------");
        System.out.println("messagesOut:              " + this.messagesOutCount.get());
        System.out.println("bytesOut:                 " + this.bytesOutCount.get());
        System.out.println("messagesOutThrottled:     " + this.messagesOutThrottledCount.get());
        System.out.println("messagesOutErr:           " + this.messagesOutErrCount.get());
        System.out.println("messagesIn:               " + this.messagesInCount.get());
        System.out.println("messagesInDups:           " + this.messagesInDupCount.get());
        System.out.println("bytesIn:                  " + this.bytesInCount.get());
        System.out.println("publisherMsgThroughput:   " + this.writeMsgThroughput(totalReportedTimeMillis) + " msgs/sec");
        System.out.println("publisherBytesThroughput: " + this.writeBytesThroughput(totalReportedTimeMillis) + " bytes/sec");
        System.out.println("consumerMsgThroughput:    " + this.readMsgThroughput(totalReportedTimeMillis) + " msgs/sec");
        System.out.println("consumerBytesThroughput:  " + this.readBytesThroughput(totalReportedTimeMillis) + " bytes/sec");
        System.out.println("publishLatency (ms):      " + this.writeLatency);
        System.out.println("consumeLatency (ms):      " + this.readLatency);
    }

    private long writeBytesThroughput(long totalReportedTimeMillis) {
        return this.bytesOutCount.get() / totalReportedTimeMillis * 1000L;
    }

    private long writeMsgThroughput(long totalReportedTimeMillis) {
        return this.messagesOutCount.get() / totalReportedTimeMillis * 1000L;
    }

    private long readBytesThroughput(long totalReportedTimeMillis) {
        return this.bytesInCount.get() / totalReportedTimeMillis * 1000L;
    }

    private long readMsgThroughput(long totalReportedTimeMillis) {
        return this.messagesInCount.get() / totalReportedTimeMillis * 1000L;
    }

    public static class Profiler {
        private long startTimeMillis;

        public void start() {
            this.startTimeMillis = System.currentTimeMillis();
        }

        public long elapsed() {
            return System.currentTimeMillis() - this.startTimeMillis;
        }
    }

    public static class Latency {
        private long count;
        private long max;
        private long sum;
        private long min = Long.MAX_VALUE;

        public synchronized void add(long value) {
            ++this.count;
            this.sum += value;
            if (value < this.min) {
                this.min = value;
            } else if (value > this.max) {
                this.max = value;
            }
        }

        public long avg() {
            return this.count == 0L ? 0L : this.sum / this.count;
        }

        public long min() {
            return this.min == Long.MAX_VALUE ? 0L : this.min;
        }

        public String toString() {
            return "sum:" + this.sum + ",avg:" + this.avg() + ",min:" + this.min() + ",max:" + this.max;
        }
    }
}

