/*
 * Decompiled with CFR 0.152.
 */
package com.undefinedlabs.scope.rules.sql.provider.internal;

import com.undefinedlabs.scope.rules.sql.model.PreparedStatementQueryParameter;
import com.undefinedlabs.scope.tracing.sender.internal.serializers.ObjectMapperFactory;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum PreparedStatementQueryUtils {
    INSTANCE;


    public String generateParamKey(int sqlParamIndex) {
        return "?".concat(String.valueOf(sqlParamIndex));
    }

    public String extractSqlMethod(String sqlStatement) {
        if (StringUtils.isEmpty((CharSequence)sqlStatement)) {
            return null;
        }
        String[] chuncks = sqlStatement.split(" ", 2);
        return chuncks.length > 0 ? chuncks[0] : null;
    }

    public String generateSqlParamsAsString(Map<String, PreparedStatementQueryParameter> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return ObjectMapperFactory.newConfiguredObjectMapper().writeValueAsString(map);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String buildSql(String sqlStatement, Map<String, PreparedStatementQueryParameter> parametersMap) {
        if (StringUtils.isEmpty((CharSequence)sqlStatement)) {
            return null;
        }
        if (parametersMap == null || parametersMap.isEmpty()) {
            return sqlStatement;
        }
        String sql = sqlStatement;
        for (PreparedStatementQueryParameter sqlParam : parametersMap.values()) {
            sql = sql.replaceFirst("\\?", sqlParam.getValue());
        }
        return sql;
    }
}

