/*
 * Decompiled with CFR 0.152.
 */
package com.undefinedlabs.scope.rules.sql.provider.internal.mysql;

import com.undefinedlabs.scope.rules.sql.model.PreparedStatementQuery;
import com.undefinedlabs.scope.rules.sql.model.PreparedStatementQueryParameter;
import com.undefinedlabs.scope.rules.sql.provider.PreparedStatementQueryProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.PreparedStatementQueryUtils;
import com.undefinedlabs.scope.tracing.jdk.reflection.ReflectionContext;
import java.sql.PreparedStatement;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.reflect.MethodUtils;

public enum MySQLClientPreparedStatementQueryProvider implements PreparedStatementQueryProvider
{
    INSTANCE;

    public static final String CLIENT_PREPARED_STATEMENT_CLASS_NAME = "com.mysql.cj.jdbc.ClientPreparedStatement";
    public static final String CALLABLE_PREPARED_STATEMENT_CLASS_NAME = "com.mysql.cj.jdbc.CallableStatement";
    public static final String SERVER_PREPARED_STATEMENT_CLASS_NAME = "com.mysql.cj.jdbc.ServerPreparedStatement";

    @Override
    public PreparedStatementQuery create(PreparedStatement preparedStatement) {
        if (preparedStatement == null || !ReflectionContext.INSTANCE.getScopeClass(CLIENT_PREPARED_STATEMENT_CLASS_NAME).isAssignableFrom(preparedStatement.getClass())) {
            return PreparedStatementQuery.EMPTY;
        }
        try {
            String sqlPreparedStatement = (String)MethodUtils.invokeMethod((Object)preparedStatement, (String)"getPreparedSql");
            String sql = (String)MethodUtils.invokeMethod((Object)preparedStatement, (String)"asSql");
            String sqlMethod = PreparedStatementQueryUtils.INSTANCE.extractSqlMethod(sqlPreparedStatement);
            Object queryBindings = MethodUtils.invokeMethod((Object)preparedStatement, (String)"getQueryBindings");
            Object[] bindValues = (Object[])MethodUtils.invokeMethod((Object)queryBindings, (String)"getBindValues");
            LinkedHashMap<String, PreparedStatementQueryParameter> parametersMap = new LinkedHashMap<String, PreparedStatementQueryParameter>();
            for (int i = 0; i < bindValues.length; ++i) {
                Object bindValue = bindValues[i];
                Object type = MethodUtils.invokeMethod((Object)bindValue, (String)"getMysqlType");
                String typeName = (String)MethodUtils.invokeMethod((Object)type, (String)"getName");
                String typeClassName = (String)MethodUtils.invokeMethod((Object)type, (String)"getClassName");
                byte[] value = (byte[])MethodUtils.invokeMethod((Object)bindValue, (String)"getByteValue");
                int paramIndex = i + 1;
                String paramKey = PreparedStatementQueryUtils.INSTANCE.generateParamKey(paramIndex);
                parametersMap.put(paramKey, new PreparedStatementQueryParameter(typeName, typeClassName, new String(value)));
            }
            PreparedStatementQuery.Builder builder = PreparedStatementQuery.newBuilder();
            builder.withSqlStatement(sql);
            builder.withSqlMethod(sqlMethod);
            builder.withSqlPreparedStatement(parametersMap.isEmpty() ? null : sqlPreparedStatement);
            builder.withSqlParameterMap(parametersMap.isEmpty() ? null : parametersMap);
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

