/*
 * Decompiled with CFR 0.152.
 */
package com.undefinedlabs.scope.rules.sql.provider.internal.mysql;

import com.undefinedlabs.scope.rules.sql.model.ConnectionInfo;
import com.undefinedlabs.scope.rules.sql.provider.ConnectionInfoProvider;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.apache.commons.lang3.reflect.MethodUtils;

public class MySQLConnectionImplInfoProvider
implements ConnectionInfoProvider {
    public static final String JDBC_CONNECTION_CLASS_NAME = "com.mysql.cj.jdbc.ConnectionImpl";

    @Override
    public ConnectionInfo extractInfo(Connection connection) {
        if (connection == null || !connection.getClass().getName().contains(JDBC_CONNECTION_CLASS_NAME)) {
            return ConnectionInfo.EMPTY;
        }
        try {
            String url = (String)MethodUtils.invokeMethod((Object)connection, (String)"getURL");
            String user = (String)MethodUtils.invokeMethod((Object)connection, (String)"getUser");
            String catalog = (String)MethodUtils.invokeMethod((Object)connection, (String)"getCatalog");
            DatabaseMetaData metaData = (DatabaseMetaData)MethodUtils.invokeMethod((Object)connection, (String)"getMetaData");
            ConnectionInfo.Builder builder = ConnectionInfo.newBuilder();
            builder.withUrl(url).withUserName(user).withInstance(catalog).withProductName(metaData.getDatabaseProductName()).withProductVersion(metaData.getDatabaseProductVersion()).withDriverName(metaData.getDriverName()).withDriverVersion(metaData.getDriverVersion());
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

