package com.undefinedlabs.scope.rules.sql.provider.internal.mysql;

import com.undefinedlabs.scope.rules.sql.model.ConnectionInfo;
import com.undefinedlabs.scope.rules.sql.provider.ConnectionInfoProvider;
import com.undefinedlabs.scope.utils.tag.TagValues;
import org.apache.commons.lang3.reflect.MethodUtils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;

public class MySQLConnectionImplInfoProvider implements ConnectionInfoProvider {

    public static final String JDBC_CONNECTION_CLASS_NAME = "com.mysql.cj.jdbc.ConnectionImpl";

    @Override
    public ConnectionInfo extractInfo(Connection connection) {
        if(connection == null || !connection.getClass().getName().contains(JDBC_CONNECTION_CLASS_NAME)){
            return ConnectionInfo.EMPTY;
        }

        try {
            final String url = (String) MethodUtils.invokeMethod(connection, "getURL");
            final String user = (String) MethodUtils.invokeMethod(connection, "getUser");
            final String catalog = (String) MethodUtils.invokeMethod(connection, "getCatalog");
            final DatabaseMetaData metaData = (DatabaseMetaData) MethodUtils.invokeMethod(connection, "getMetaData");

            final ConnectionInfo.Builder builder = ConnectionInfo.newBuilder();
            builder.withUrl(url)
                    .withUserName(user)
                    .withInstance(catalog)
                    .withProductName(metaData.getDatabaseProductName())
                    .withProductVersion(metaData.getDatabaseProductVersion())
                    .withDriverName(metaData.getDriverName())
                    .withDriverVersion(metaData.getDriverVersion())
                    .withPeerService(TagValues.DB.Service.MYSQL);

            return builder.build();

        } catch(Exception e){
            throw new RuntimeException(e);
        }
    }
}
