/*
 * Decompiled with CFR 0.152.
 */
package com.undefinedlabs.scope.rules;

import com.undefinedlabs.scope.ScopeGlobalTracer;
import com.undefinedlabs.scope.events.EventFieldsFactory;
import com.undefinedlabs.scope.events.exception.ThrowableEvent;
import com.undefinedlabs.scope.rules.AbstractScopeAgentRule;
import com.undefinedlabs.scope.rules.sql.model.ConnectionInfo;
import com.undefinedlabs.scope.rules.sql.provider.ConnectionInfoProviderRegistry;
import com.undefinedlabs.scope.rules.transformer.ScopeAgentAdvicedTransformer;
import com.undefinedlabs.scope.utils.sourcecode.ExceptionSourceCodeFactory;
import com.undefinedlabs.scope.utils.sourcecode.ExceptionSourceCodeFrame;
import com.undefinedlabs.scope.utils.tag.TagKeys;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ConnectionScopeAgentRule
extends AbstractScopeAgentRule {
    protected Iterable<? extends AgentBuilder> transformers() {
        Class instrumentedClass = this.lookUp("java.sql.Connection");
        return instrumentedClass != null ? Collections.singleton(this.newAgentBuilder().type((ElementMatcher)ElementMatchers.isSubTypeOf((Class)instrumentedClass)).transform((AgentBuilder.Transformer)new ScopeAgentAdvicedTransformer(ConnectionAdvice.class, (ElementMatcher)ElementMatchers.named((String)"commit"))).type((ElementMatcher)ElementMatchers.isSubTypeOf((Class)instrumentedClass)).transform((AgentBuilder.Transformer)new ScopeAgentAdvicedTransformer(ConnectionAdvice.class, (ElementMatcher)ElementMatchers.named((String)"rollback"))).type((ElementMatcher)ElementMatchers.isSubTypeOf((Class)instrumentedClass)).transform((AgentBuilder.Transformer)new ScopeAgentAdvicedTransformer(ConnectionAdvice.class, (ElementMatcher)ElementMatchers.named((String)"close")))) : this.emptyCollection();
    }

    public static class ConnectionAdvice {
        @Advice.OnMethodEnter
        public static Span enter(@Advice.This Object thiz, @Advice.Origin(value="#m") Object methodName) {
            Connection connection = (Connection)thiz;
            ConnectionInfo connectionInfo = ConnectionInfoProviderRegistry.INSTANCE.getProvider(connection).extractInfo(connection);
            if (ConnectionInfo.EMPTY.equals(connectionInfo)) {
                return null;
            }
            Tracer tracer = ScopeGlobalTracer.get();
            Span previousSpan = tracer.activeSpan();
            if (previousSpan == null) {
                return null;
            }
            try {
                String method = (String)methodName;
                Span span = tracer.buildSpan(connectionInfo.getProductName() + ":" + method).withTag(TagKeys.COMPONENT, "java-sql").withTag(TagKeys.SPAN_KIND, "client").withTag("db.conn", connectionInfo.getUrl()).withTag(TagKeys.DB.DB_STATEMENT, method).withTag("db.params", (String)null).withTag(TagKeys.DB.DB_TYPE, "sql").withTag(TagKeys.DB.DB_USER, connectionInfo.getUserName()).withTag(TagKeys.DB.DB_INSTANCE, connection.getCatalog()).withTag("db.product", connectionInfo.getProductName()).withTag("db.product_version", connectionInfo.getProductVersion()).withTag("db.driver", connectionInfo.getDriverName()).withTag("db.driver_version", connectionInfo.getDriverVersion()).withTag(TagKeys.Network.PEER_SERVICE, connectionInfo.getPeerService()).start();
                return span;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Advice.OnMethodExit(onThrowable=SQLException.class)
        public static void exit(@Advice.This Object thiz, @Advice.Enter Object spanObj, @Advice.Thrown Throwable throwable) {
            if (spanObj == null) {
                return;
            }
            Span span = (Span)spanObj;
            if (throwable != null) {
                span.setTag("error", true);
                ExceptionSourceCodeFrame exceptionSourceCodeFrame = ExceptionSourceCodeFactory.INSTANCE.createFrame(throwable);
                ThrowableEvent.Builder throwableEventBuilder = ThrowableEvent.newBuilder();
                throwableEventBuilder.withEventType("error").withThrowable(exceptionSourceCodeFrame.getUserThrowable()).withSource(exceptionSourceCodeFrame.getSourceCodeFrame().getLinkPathWithMethodLine());
                span.log(EventFieldsFactory.INSTANCE.createFields(throwableEventBuilder.build()));
            }
            span.finish();
        }
    }
}

