package com.undefinedlabs.scope.rules.sql.provider;

import com.undefinedlabs.scope.rules.sql.provider.internal.NoopPreparedStatementQueryProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.h2.H2JdbcPreparedStatementQueryProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.mysql.MySQLClientPreparedStatementQueryProvider;

import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;

public enum PreparedStatementQueryProviderRegistry {

    INSTANCE;

    private static final PreparedStatementQueryProvider NOOP_PROVIDER = new NoopPreparedStatementQueryProvider();
    private static final Map<String, PreparedStatementQueryProvider> PROVIDERS = new HashMap<>();

    static {
        PROVIDERS.put(H2JdbcPreparedStatementQueryProvider.JDBC_PREPARED_STATEMENT_CLASS_NAME, H2JdbcPreparedStatementQueryProvider.INSTANCE);

        PROVIDERS.put(MySQLClientPreparedStatementQueryProvider.CLIENT_PREPARED_STATEMENT_CLASS_NAME, MySQLClientPreparedStatementQueryProvider.INSTANCE);
        PROVIDERS.put(MySQLClientPreparedStatementQueryProvider.SERVER_PREPARED_STATEMENT_CLASS_NAME, MySQLClientPreparedStatementQueryProvider.INSTANCE);
        PROVIDERS.put(MySQLClientPreparedStatementQueryProvider.CALLABLE_PREPARED_STATEMENT_CLASS_NAME, MySQLClientPreparedStatementQueryProvider.INSTANCE);
    }

    public PreparedStatementQueryProvider getProvider(final PreparedStatement preparedStatement) {
        return preparedStatement != null ? getProvider(preparedStatement.getClass().getName()) : NOOP_PROVIDER;
    }

    PreparedStatementQueryProvider getProvider(final String preparedStatementClassName) {
        return PROVIDERS.get(preparedStatementClassName) != null ? PROVIDERS.get(preparedStatementClassName) : NOOP_PROVIDER;
    }
}
