package com.undefinedlabs.scope.rules.sql.provider.internal.h2;

import com.undefinedlabs.scope.rules.sql.model.ConnectionInfo;
import com.undefinedlabs.scope.rules.sql.provider.ConnectionInfoProvider;
import com.undefinedlabs.scope.utils.tag.TagValues;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class H2JdbcConnectionInfoProvider implements ConnectionInfoProvider {

    public static final String JDBC_CONNECTION_CLASS_NAME = "org.h2.jdbc.JdbcConnection";

    @Override
    public ConnectionInfo extractInfo(Connection connection) {
        if (connection == null || !connection.getClass().getName().contains(JDBC_CONNECTION_CLASS_NAME)) {
            return ConnectionInfo.EMPTY;
        }

        try {
            final DatabaseMetaData metaData = connection.getMetaData();
            final ConnectionInfo.Builder builder = ConnectionInfo.newBuilder();
            builder.withUrl(metaData.getURL())
                    .withUserName(metaData.getUserName())
                    .withInstance(connection.getCatalog())
                    .withProductName(metaData.getDatabaseProductName())
                    .withProductVersion(metaData.getDatabaseProductVersion())
                    .withDriverName(metaData.getDriverName())
                    .withDriverVersion(metaData.getDriverVersion())
                    .withPeerService(TagValues.DB.Service.H2);

            return builder.build();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}
