package com.undefinedlabs.scope.rules.sql.provider;

import com.undefinedlabs.scope.rules.sql.provider.internal.NoopConnectionInfoProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.h2.H2JdbcConnectionInfoProvider;
import com.undefinedlabs.scope.rules.sql.provider.internal.mysql.MySQLConnectionImplInfoProvider;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;

public enum ConnectionInfoProviderRegistry {

    INSTANCE;

    private static final ConnectionInfoProvider NOOP_PROVIDER = new NoopConnectionInfoProvider();
    private static final Map<String, ConnectionInfoProvider> PROVIDERS = new HashMap<>();

    static {
        PROVIDERS.put(H2JdbcConnectionInfoProvider.JDBC_CONNECTION_CLASS_NAME, new H2JdbcConnectionInfoProvider());
        PROVIDERS.put(MySQLConnectionImplInfoProvider.JDBC_CONNECTION_CLASS_NAME, new MySQLConnectionImplInfoProvider());
    }

    public ConnectionInfoProvider getProvider(final Connection connection) {
        return connection != null ? getProvider(connection.getClass().getName()) : NOOP_PROVIDER;
    }

    ConnectionInfoProvider getProvider(final String connectionClassName) {
        return PROVIDERS.get(connectionClassName) != null ? PROVIDERS.get(connectionClassName) : NOOP_PROVIDER;
    }

}
