/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.APIClientResponse;
import com.urbanairship.api.client.APIRequestException;
import com.urbanairship.api.client.APIScheduleResponse;
import com.urbanairship.api.client.parse.APIResponseObjectMapper;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleAPIResponseHandler
implements ResponseHandler<APIClientResponse<APIScheduleResponse>> {
    public APIClientResponse<APIScheduleResponse> handleResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 201: {
                return this.handleSuccessfulSchedule(response);
            }
            case 400: 
            case 401: 
            case 403: {
                throw APIRequestException.exceptionForResponse(response);
            }
        }
        if (statusCode >= 200 && statusCode < 300) {
            return this.handleSuccessfulSchedule(response);
        }
        throw APIRequestException.exceptionForResponse(response);
    }

    private APIClientResponse<APIScheduleResponse> handleSuccessfulSchedule(HttpResponse response) throws IOException {
        String jsonPayload = EntityUtils.toString((HttpEntity)response.getEntity());
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        ObjectMapper mapper = APIResponseObjectMapper.getInstance();
        APIScheduleResponse scheduleResponse = (APIScheduleResponse)mapper.readValue(jsonPayload, APIScheduleResponse.class);
        APIClientResponse.Builder<APIScheduleResponse> builder = APIClientResponse.newScheduleResponseBuilder();
        builder.setHttpResponse(response);
        builder.setApiResponse(scheduleResponse);
        return builder.build();
    }
}

