/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.common.parse;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.SetOfStringsDeserializer;
import java.util.Set;
import org.codehaus.jackson.JsonParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetOfAPIDsDeserializer {
    public static final SetOfAPIDsDeserializer INSTANCE = new SetOfAPIDsDeserializer();
    private static final String APID_FORMAT_ERROR_MESSAGE = "%s is not a valid device identifier";
    private static final int UUID_STRING_LENGTH = 36;

    private SetOfAPIDsDeserializer() {
    }

    public Set<String> deserialize(JsonParser parser, String fieldName) {
        Set<String> apids = SetOfStringsDeserializer.INSTANCE.deserialize(parser, fieldName);
        for (String apid : apids) {
            if (apid.length() >= 36) continue;
            throw new APIParsingException(String.format(APID_FORMAT_ERROR_MESSAGE, apid));
        }
        return apids;
    }
}

