/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.audience;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.push.model.audience.CompoundSelector;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorCategory;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.audience.SelectorVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCompoundSelector
implements CompoundSelector {
    private final SelectorType type;
    private final ImmutableList<Selector> children;

    private BasicCompoundSelector(SelectorType type, ImmutableList<Selector> children) {
        this.type = type;
        this.children = children;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public SelectorType getType() {
        return this.type;
    }

    @Override
    public Iterable<Selector> getChildren() {
        return this.children;
    }

    @Override
    public void accept(SelectorVisitor visitor) {
        visitor.enter(this);
        for (Selector child : this.children) {
            child.accept(visitor);
        }
        visitor.exit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicCompoundSelector that = (BasicCompoundSelector)o;
        if (this.type != null ? !this.type.equals((Object)that.type) : that.type != null) {
            return false;
        }
        return !(this.children != null ? !this.children.equals(that.children) : that.children != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BasicCompoundSelector{type=" + this.type.getIdentifier() + ",children=" + this.children.toString() + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private SelectorType type;
        private final ImmutableList.Builder<Selector> selectorsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder setType(SelectorType value) {
            this.type = value;
            return this;
        }

        public Builder addSelector(Selector value) {
            this.selectorsBuilder.add((Object)value);
            return this;
        }

        public Builder addAllSelectors(Iterable<Selector> values) {
            this.selectorsBuilder.addAll(values);
            return this;
        }

        public BasicCompoundSelector build() {
            ImmutableList selectors = this.selectorsBuilder.build();
            Preconditions.checkArgument((!selectors.isEmpty() ? 1 : 0) != 0, (Object)"A compound selector must have at least one child.");
            if (this.type == SelectorType.NOT && selectors.size() > 1) {
                throw new IllegalArgumentException("A 'not' expression can have only one child.");
            }
            for (Selector child : selectors) {
                SelectorType childType = child.getType();
                Preconditions.checkArgument((childType.getCategory() != SelectorCategory.ATOMIC ? 1 : 0) != 0, (Object)"A compound selector cannot an atomic selector.");
            }
            return new BasicCompoundSelector(this.type, selectors);
        }
    }
}

