/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.audience;

import com.urbanairship.api.push.model.audience.SelectorCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SelectorType {
    TAG("tag", SelectorCategory.VALUE),
    ALIAS("alias", SelectorCategory.VALUE),
    SEGMENT("segment", SelectorCategory.VALUE),
    DEVICE_TOKEN("device_token", SelectorCategory.VALUE, true),
    DEVICE_PIN("device_pin", SelectorCategory.VALUE, true),
    APID("apid", SelectorCategory.VALUE, true),
    WNS("wns", SelectorCategory.VALUE, true),
    MPNS("mpns", SelectorCategory.VALUE, true),
    AND("and", SelectorCategory.COMPOUND),
    OR("or", SelectorCategory.COMPOUND),
    NOT("not", SelectorCategory.COMPOUND),
    LOCATION("location", SelectorCategory.LOCATION),
    ALL("all", SelectorCategory.ATOMIC),
    TRIGGERED("triggered", SelectorCategory.ATOMIC);

    private final String identifier;
    private final SelectorCategory category;
    private final boolean isDeviceId;

    private SelectorType(String identifier, SelectorCategory category) {
        this.identifier = identifier;
        this.category = category;
        this.isDeviceId = false;
    }

    private SelectorType(String identifier, SelectorCategory category, boolean isDeviceId) {
        this.identifier = identifier;
        this.category = category;
        this.isDeviceId = isDeviceId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public SelectorCategory getCategory() {
        return this.category;
    }

    public boolean isDeviceId() {
        return this.isDeviceId;
    }

    public static SelectorType getSelectorTypeFromIdentifier(String identifier) {
        for (SelectorType operatorType : SelectorType.values()) {
            if (!operatorType.identifier.equalsIgnoreCase(identifier)) continue;
            return operatorType;
        }
        return null;
    }
}

