/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.audience.location;

import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.audience.SelectorVisitor;
import com.urbanairship.api.push.model.audience.location.DateRange;
import com.urbanairship.api.push.model.audience.location.LocationIdentifier;

public final class LocationSelector
extends PushModelObject
implements Selector {
    private final LocationIdentifier locationIdentifier;
    private final DateRange dateRange;

    private LocationSelector(LocationIdentifier locationIdentifier, DateRange dateRange) {
        this.locationIdentifier = locationIdentifier;
        this.dateRange = dateRange;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public SelectorType getType() {
        return SelectorType.LOCATION;
    }

    public void accept(SelectorVisitor visitor) {
        visitor.enter(this);
        visitor.exit(this);
    }

    public LocationIdentifier getLocationIdentifier() {
        return this.locationIdentifier;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationSelector that = (LocationSelector)o;
        if (this.dateRange != null ? !this.dateRange.equals(that.dateRange) : that.dateRange != null) {
            return false;
        }
        return !(this.locationIdentifier != null ? !this.locationIdentifier.equals(that.locationIdentifier) : that.locationIdentifier != null);
    }

    public int hashCode() {
        int result = this.locationIdentifier != null ? this.locationIdentifier.hashCode() : 0;
        result = 31 * result + (this.dateRange != null ? this.dateRange.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LocationSelector{dateRange=" + this.dateRange + ", locationIdentifier=" + this.locationIdentifier + '}';
    }

    public static class Builder {
        private LocationIdentifier id = null;
        private DateRange range = null;

        private Builder() {
        }

        public Builder setId(LocationIdentifier value) {
            this.id = value;
            return this;
        }

        public Builder setDateRange(DateRange value) {
            this.range = value;
            return this;
        }

        public LocationSelector build() {
            Preconditions.checkNotNull((Object)this.id);
            Preconditions.checkNotNull((Object)this.range);
            return new LocationSelector(this.id, this.range);
        }
    }
}

