/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.audience.location;

import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.audience.location.DateRange;
import com.urbanairship.api.push.model.audience.location.DateRangeUnit;
import com.urbanairship.api.push.model.audience.location.PresenceTimeFrame;
import org.joda.time.DateTime;

public class RecentDateRange
extends PushModelObject
implements DateRange {
    private final DateRangeUnit resolution;
    private final int units;
    private final PresenceTimeFrame timeframe;

    private RecentDateRange(DateRangeUnit resolution, int units, PresenceTimeFrame timeframe) {
        this.resolution = resolution;
        this.units = units;
        this.timeframe = timeframe;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getUnits() {
        return this.units;
    }

    public DateTime getStart() {
        return DateTime.now();
    }

    public DateTime getEnd() {
        return DateTime.now();
    }

    public DateRangeUnit getResolution() {
        return this.resolution;
    }

    public PresenceTimeFrame getTimeframe() {
        return this.timeframe;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecentDateRange that = (RecentDateRange)o;
        if (this.units != that.units) {
            return false;
        }
        if (this.resolution != that.resolution) {
            return false;
        }
        return this.timeframe == that.timeframe;
    }

    public int hashCode() {
        int result = this.resolution != null ? this.resolution.hashCode() : 0;
        result = 31 * result + this.units;
        result = 31 * result + (this.timeframe != null ? this.timeframe.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RecentDateRange{resolution=" + (Object)((Object)this.resolution) + ", units=" + this.units + ", timeframe='" + (Object)((Object)this.timeframe) + '\'' + '}';
    }

    public static class Builder {
        private DateRangeUnit resolution;
        private int units = 0;
        private PresenceTimeFrame timeframe = PresenceTimeFrame.ANYTIME;

        private Builder() {
        }

        public Builder setResolution(DateRangeUnit value) {
            this.resolution = value;
            return this;
        }

        public Builder setUnits(int value) {
            this.units = value;
            return this;
        }

        public Builder setTimeframe(PresenceTimeFrame value) {
            this.timeframe = value;
            return this;
        }

        public RecentDateRange build() {
            Preconditions.checkNotNull((Object)((Object)this.resolution));
            Preconditions.checkArgument((this.units != 0 ? 1 : 0) != 0);
            return new RecentDateRange(this.resolution, this.units, this.timeframe);
        }
    }
}

