/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.google.common.base.Optional;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOSAlertData
extends PushModelObject {
    private final Optional<String> body;
    private final Optional<String> actionLocKey;
    private final Optional<String> locKey;
    private final Optional<List<String>> locArgs;
    private final Optional<String> launchImage;

    private IOSAlertData(Optional<String> body, Optional<String> actionLocKey, Optional<String> locKey, Optional<List<String>> locArgs, Optional<String> launchImage) {
        this.body = body;
        this.actionLocKey = actionLocKey;
        this.locKey = locKey;
        this.locArgs = locArgs;
        this.launchImage = launchImage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isCompound() {
        return this.actionLocKey.isPresent() || this.locKey.isPresent() || this.locArgs.isPresent() || this.launchImage.isPresent();
    }

    public Optional<String> getBody() {
        return this.body;
    }

    public Optional<String> getActionLocKey() {
        return this.actionLocKey;
    }

    public Optional<String> getLocKey() {
        return this.locKey;
    }

    public Optional<List<String>> getLocArgs() {
        return this.locArgs;
    }

    public Optional<String> getLaunchImage() {
        return this.launchImage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOSAlertData that = (IOSAlertData)o;
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.actionLocKey != null ? !this.actionLocKey.equals(that.actionLocKey) : that.actionLocKey != null) {
            return false;
        }
        if (this.locKey != null ? !this.locKey.equals(that.locKey) : that.locKey != null) {
            return false;
        }
        if (this.locArgs != null ? !this.locArgs.equals(that.locArgs) : that.locArgs != null) {
            return false;
        }
        return !(this.launchImage != null ? !this.launchImage.equals(that.launchImage) : that.launchImage != null);
    }

    public int hashCode() {
        int result = this.body != null ? this.body.hashCode() : 0;
        result = 31 * result + (this.actionLocKey != null ? this.actionLocKey.hashCode() : 0);
        result = 31 * result + (this.locKey != null ? this.locKey.hashCode() : 0);
        result = 31 * result + (this.locArgs != null ? this.locArgs.hashCode() : 0);
        result = 31 * result + (this.launchImage != null ? this.launchImage.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IOSAlertData{body=" + this.body + ", actionLocKey=" + this.actionLocKey + ", locKey=" + this.locKey + ", locArgs=" + this.locArgs + ", launchImage=" + this.launchImage + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String body;
        private String actionLocKey;
        private String locKey;
        private List<String> locArgs;
        private String launchImage;

        private Builder() {
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setActionLocKey(String value) {
            this.actionLocKey = value;
            return this;
        }

        public Builder setLocKey(String value) {
            this.locKey = value;
            return this;
        }

        public Builder setLocArgs(List<String> value) {
            this.locArgs = value;
            return this;
        }

        public Builder setLaunchImage(String value) {
            this.launchImage = value;
            return this;
        }

        public IOSAlertData build() {
            return new IOSAlertData(Optional.fromNullable((Object)this.body), Optional.fromNullable((Object)this.actionLocKey), Optional.fromNullable((Object)this.locKey), Optional.fromNullable(this.locArgs), Optional.fromNullable((Object)this.launchImage));
        }
    }
}

