/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOSBadgeData
extends PushModelObject {
    private final Optional<Integer> value;
    private final Type type;

    private IOSBadgeData(Type type, Optional<Integer> value) {
        this.type = type;
        this.value = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Integer> getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOSBadgeData that = (IOSBadgeData)o;
        if (this.type != null ? !this.type.equals((Object)that.type) : that.type != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IOSBadgeData{type=" + (Object)((Object)this.type) + ", value=" + this.value + '}';
    }

    public static class Builder {
        private Type type;
        private Integer value;

        private Builder() {
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setValue(int value) {
            this.value = value;
            return this;
        }

        public IOSBadgeData build() {
            Preconditions.checkNotNull((Object)((Object)this.type));
            return new IOSBadgeData(this.type, Optional.fromNullable((Object)this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        VALUE,
        AUTO,
        INCREMENT,
        DECREMENT;

        private final String id = this.name().toLowerCase();

        public String getIdentifier() {
            return this.id;
        }

        public static Type get(String value) {
            for (Type type : Type.values()) {
                if (!value.equalsIgnoreCase(type.getIdentifier())) continue;
                return type;
            }
            return null;
        }
    }
}

