/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.ios.IOSAlertData;
import com.urbanairship.api.push.model.notification.ios.IOSBadgeData;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOSDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<IOSAlertData> alert;
    private final Optional<ImmutableMap<String, String>> extra;
    private final Optional<String> sound;
    private final Optional<IOSBadgeData> badge;
    private final Optional<Boolean> contentAvailable;

    private IOSDevicePayload(Optional<IOSAlertData> alert, Optional<String> sound, Optional<IOSBadgeData> badge, Optional<Boolean> contentAvailable, Optional<ImmutableMap<String, String>> extra) {
        this.alert = alert;
        this.sound = sound;
        this.badge = badge;
        this.contentAvailable = contentAvailable;
        this.extra = extra;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.IOS;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert.isPresent() ? ((IOSAlertData)this.alert.get()).getBody() : Optional.absent();
    }

    public Optional<IOSAlertData> getAlertData() {
        return this.alert;
    }

    public Optional<String> getSound() {
        return this.sound;
    }

    public Optional<IOSBadgeData> getBadge() {
        return this.badge;
    }

    public Optional<Boolean> getContentAvailable() {
        return this.contentAvailable;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOSDevicePayload that = (IOSDevicePayload)o;
        if (this.alert != null ? !this.alert.equals(that.alert) : that.alert != null) {
            return false;
        }
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.sound != null ? !this.sound.equals(that.sound) : that.sound != null) {
            return false;
        }
        if (this.badge != null ? !this.badge.equals(that.badge) : that.badge != null) {
            return false;
        }
        return !(this.contentAvailable != null ? !this.contentAvailable.equals(that.contentAvailable) : that.contentAvailable != null);
    }

    public int hashCode() {
        int result = this.alert != null ? this.alert.hashCode() : 0;
        result = 31 * result + (this.extra != null ? this.extra.hashCode() : 0);
        result = 31 * result + (this.sound != null ? this.sound.hashCode() : 0);
        result = 31 * result + (this.badge != null ? this.badge.hashCode() : 0);
        result = 31 * result + (this.contentAvailable != null ? this.contentAvailable.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IOSDevicePayload{alert=" + this.alert + ", extra=" + this.extra + ", sound=" + this.sound + ", badge=" + this.badge + ", contentAvailable=" + this.contentAvailable + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private IOSAlertData alert = null;
        private String sound = null;
        private IOSBadgeData badge = null;
        private Boolean contentAvailable = null;
        private ImmutableMap.Builder<String, String> extra = null;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = IOSAlertData.newBuilder().setBody(alert).build();
            return this;
        }

        public Builder setAlert(IOSAlertData alert) {
            this.alert = alert;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setBadge(IOSBadgeData badge) {
            this.badge = badge;
            return this;
        }

        public Builder setContentAvailable(boolean value) {
            this.contentAvailable = value;
            return this;
        }

        public Builder addExtraEntry(String key, String value) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllExtraEntries(Map<String, String> entries) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.putAll(entries);
            return this;
        }

        public IOSDevicePayload build() {
            return new IOSDevicePayload(Optional.fromNullable((Object)this.alert), Optional.fromNullable((Object)this.sound), Optional.fromNullable((Object)this.badge), Optional.fromNullable((Object)this.contentAvailable), this.extra == null ? Optional.absent() : Optional.fromNullable((Object)this.extra.build()));
        }
    }
}

