/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.mpns;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.push.model.notification.mpns.MPNSTileData;
import com.urbanairship.api.push.model.notification.mpns.Validation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPNSCycleTileData
extends MPNSTileData {
    private final Optional<String> smallBackgroundImage;
    private final Optional<ImmutableList<String>> images;

    private MPNSCycleTileData(Optional<String> id, Optional<String> title, Optional<Integer> count, Optional<String> smallBackgroundImage, Optional<ImmutableList<String>> images) {
        super(id, title, count);
        this.smallBackgroundImage = smallBackgroundImage;
        this.images = images;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getTemplate() {
        return "CycleTile";
    }

    public Optional<String> getSmallBackgroundImage() {
        return this.smallBackgroundImage;
    }

    public Optional<ImmutableList<String>> getImages() {
        return this.images;
    }

    public int getImageCount() {
        return this.images.isPresent() ? ((ImmutableList)this.images.get()).size() : 0;
    }

    public String getImage(int i) {
        return this.images.isPresent() ? (String)((ImmutableList)this.images.get()).get(i) : null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MPNSCycleTileData that = (MPNSCycleTileData)o;
        if (this.smallBackgroundImage != null ? !this.smallBackgroundImage.equals(that.smallBackgroundImage) : that.smallBackgroundImage != null) {
            return false;
        }
        return !(this.images != null ? !this.images.equals(that.images) : that.images != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.smallBackgroundImage != null ? this.smallBackgroundImage.hashCode() : 0);
        result = 31 * result + (this.images != null ? this.images.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String id;
        private String title;
        private Integer count;
        private String smallBackgroundImage;
        private ImmutableList.Builder<String> imagesBuilder = ImmutableList.builder();

        public Builder setId(String value) {
            this.id = value;
            return this;
        }

        public Builder setTitle(String value) {
            this.title = value;
            return this;
        }

        public Builder setCount(int value) {
            this.count = new Integer(value);
            return this;
        }

        public Builder setSmallBackgroundImage(String value) {
            this.smallBackgroundImage = value;
            return this;
        }

        public Builder addImage(String value) {
            if (this.imagesBuilder == null) {
                this.imagesBuilder = ImmutableList.builder();
            }
            this.imagesBuilder.add((Object)value);
            return this;
        }

        public Builder addAllImages(Iterable<String> values) {
            if (this.imagesBuilder == null) {
                this.imagesBuilder = ImmutableList.builder();
            }
            this.imagesBuilder.addAll(values);
            return this;
        }

        public Builder clearImages() {
            this.imagesBuilder = null;
            return this;
        }

        public MPNSCycleTileData build() {
            Validation.validateStringValue(this.title, "title");
            ImmutableList images = null;
            if (this.imagesBuilder != null) {
                images = this.imagesBuilder.build();
                for (String image : images) {
                    Validation.validatePath(image, "cycle_image");
                }
            }
            return new MPNSCycleTileData(Optional.fromNullable((Object)this.id), Optional.fromNullable((Object)this.title), Optional.fromNullable((Object)this.count), Optional.fromNullable((Object)this.smallBackgroundImage), Optional.fromNullable((Object)images));
        }
    }
}

