/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.mpns;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.notification.mpns.MPNSTileData;
import com.urbanairship.api.push.model.notification.mpns.Validation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPNSFlipTileData
extends MPNSTileData {
    private final Optional<String> backBackgroundImage;
    private final Optional<String> backContent;
    private final Optional<String> backgroundImage;
    private final Optional<String> backTitle;
    private final Optional<String> smallBackgroundImage;
    private final Optional<String> wideBackBackgroundImage;
    private final Optional<String> wideBackContent;
    private final Optional<String> wideBackgroundImage;

    private MPNSFlipTileData(Optional<String> id, Optional<String> title, Optional<Integer> count, Optional<String> backBackgroundImage, Optional<String> backContent, Optional<String> backgroundImage, Optional<String> backTitle, Optional<String> smallBackgroundImage, Optional<String> wideBackBackgroundImage, Optional<String> wideBackContent, Optional<String> wideBackgroundImage) {
        super(id, title, count);
        this.backBackgroundImage = backBackgroundImage;
        this.backContent = backContent;
        this.backgroundImage = backgroundImage;
        this.backTitle = backTitle;
        this.smallBackgroundImage = smallBackgroundImage;
        this.wideBackBackgroundImage = wideBackBackgroundImage;
        this.wideBackContent = wideBackContent;
        this.wideBackgroundImage = wideBackgroundImage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getTemplate() {
        return "FlipTile";
    }

    public Optional<String> getBackBackgroundImage() {
        return this.backBackgroundImage;
    }

    public Optional<String> getBackContent() {
        return this.backContent;
    }

    public Optional<String> getBackgroundImage() {
        return this.backgroundImage;
    }

    public Optional<String> getBackTitle() {
        return this.backTitle;
    }

    public Optional<String> getSmallBackgroundImage() {
        return this.smallBackgroundImage;
    }

    public Optional<String> getWideBackBackgroundImage() {
        return this.wideBackBackgroundImage;
    }

    public Optional<String> getWideBackContent() {
        return this.wideBackContent;
    }

    public Optional<String> getWideBackgroundImage() {
        return this.wideBackgroundImage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MPNSFlipTileData that = (MPNSFlipTileData)o;
        if (this.backBackgroundImage != null ? !this.backBackgroundImage.equals(that.backBackgroundImage) : that.backBackgroundImage != null) {
            return false;
        }
        if (this.backContent != null ? !this.backContent.equals(that.backContent) : that.backContent != null) {
            return false;
        }
        if (this.backgroundImage != null ? !this.backgroundImage.equals(that.backgroundImage) : that.backgroundImage != null) {
            return false;
        }
        if (this.backTitle != null ? !this.backTitle.equals(that.backTitle) : that.backTitle != null) {
            return false;
        }
        if (this.smallBackgroundImage != null ? !this.smallBackgroundImage.equals(that.smallBackgroundImage) : that.smallBackgroundImage != null) {
            return false;
        }
        if (this.wideBackBackgroundImage != null ? !this.wideBackBackgroundImage.equals(that.wideBackBackgroundImage) : that.wideBackBackgroundImage != null) {
            return false;
        }
        if (this.wideBackContent != null ? !this.wideBackContent.equals(that.wideBackContent) : that.wideBackContent != null) {
            return false;
        }
        return !(this.wideBackgroundImage != null ? !this.wideBackgroundImage.equals(that.wideBackgroundImage) : that.wideBackgroundImage != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.backBackgroundImage != null ? this.backBackgroundImage.hashCode() : 0);
        result = 31 * result + (this.backContent != null ? this.backContent.hashCode() : 0);
        result = 31 * result + (this.backgroundImage != null ? this.backgroundImage.hashCode() : 0);
        result = 31 * result + (this.backTitle != null ? this.backTitle.hashCode() : 0);
        result = 31 * result + (this.smallBackgroundImage != null ? this.smallBackgroundImage.hashCode() : 0);
        result = 31 * result + (this.wideBackBackgroundImage != null ? this.wideBackBackgroundImage.hashCode() : 0);
        result = 31 * result + (this.wideBackContent != null ? this.wideBackContent.hashCode() : 0);
        result = 31 * result + (this.wideBackgroundImage != null ? this.wideBackgroundImage.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String id;
        private String title;
        private Integer count;
        private String backBackgroundImage;
        private String backContent;
        private String backgroundImage;
        private String backTitle;
        private String smallBackgroundImage;
        private String wideBackgroundImage;
        private String wideBackBackgroundImage;
        private String wideBackContent;

        private Builder() {
        }

        public Builder setId(String value) {
            this.id = value;
            return this;
        }

        public Builder setTitle(String value) {
            this.title = value;
            return this;
        }

        public Builder setCount(int value) {
            this.count = new Integer(value);
            return this;
        }

        public Builder setBackBackgroundImage(String value) {
            this.backBackgroundImage = value;
            return this;
        }

        public Builder setBackContent(String value) {
            this.backContent = value;
            return this;
        }

        public Builder setBackgroundImage(String value) {
            this.backgroundImage = value;
            return this;
        }

        public Builder setBackTitle(String value) {
            this.backTitle = value;
            return this;
        }

        public Builder setSmallBackgroundImage(String value) {
            this.smallBackgroundImage = value;
            return this;
        }

        public Builder setWideBackBackgroundImage(String value) {
            this.wideBackBackgroundImage = value;
            return this;
        }

        public Builder setWideBackContent(String value) {
            this.wideBackContent = value;
            return this;
        }

        public Builder setWideBackgroundImage(String value) {
            this.wideBackgroundImage = value;
            return this;
        }

        public MPNSFlipTileData build() {
            Preconditions.checkArgument((this.id != null || this.title != null || this.count != null || this.backBackgroundImage != null || this.backContent != null || this.backgroundImage != null || this.backTitle != null || this.smallBackgroundImage != null || this.wideBackBackgroundImage != null || this.wideBackContent != null || this.wideBackgroundImage != null ? 1 : 0) != 0, (Object)"tile must not be empty");
            Validation.validateStringValue(this.title, "title");
            Validation.validateUriValue(this.backBackgroundImage, "back_background_image");
            Validation.validateStringValue(this.backContent, "back_content");
            Validation.validateUriValue(this.backgroundImage, "background_image");
            Validation.validateStringValue(this.backTitle, "back_title");
            Validation.validateUriValue(this.smallBackgroundImage, "small_background_image");
            Validation.validateUriValue(this.wideBackBackgroundImage, "wide_back_background_image");
            Validation.validateStringValue(this.wideBackContent, "wide_back_content");
            Validation.validateUriValue(this.wideBackgroundImage, "wide_background_image");
            return new MPNSFlipTileData(Optional.fromNullable((Object)this.id), Optional.fromNullable((Object)this.title), Optional.fromNullable((Object)this.count), Optional.fromNullable((Object)this.backBackgroundImage), Optional.fromNullable((Object)this.backContent), Optional.fromNullable((Object)this.backgroundImage), Optional.fromNullable((Object)this.backTitle), Optional.fromNullable((Object)this.smallBackgroundImage), Optional.fromNullable((Object)this.wideBackBackgroundImage), Optional.fromNullable((Object)this.wideBackContent), Optional.fromNullable((Object)this.wideBackgroundImage));
        }
    }
}

