/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.wns;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.notification.wns.WNSBadgeData;
import com.urbanairship.api.push.model.notification.wns.WNSTileData;
import com.urbanairship.api.push.model.notification.wns.WNSToastData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WNSPush {
    private final Type type;
    private final Optional<WNSToastData> toast;
    private final Optional<WNSTileData> tile;
    private final Optional<WNSBadgeData> badge;
    private final Optional<String> tag;
    private final Optional<Integer> ttl;
    private final Optional<CachePolicy> cachePolicy;

    private WNSPush(Type type, Optional<WNSToastData> toast, Optional<WNSTileData> tile, Optional<WNSBadgeData> badge, Optional<String> tag, Optional<Integer> ttl, Optional<CachePolicy> cachePolicy) {
        this.type = type;
        this.toast = toast;
        this.tile = tile;
        this.badge = badge;
        this.tag = tag;
        this.ttl = ttl;
        this.cachePolicy = cachePolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Type getType() {
        return this.type;
    }

    public Optional<WNSToastData> getToast() {
        return this.toast;
    }

    public Optional<WNSTileData> getTile() {
        return this.tile;
    }

    public Optional<WNSBadgeData> getBadge() {
        return this.badge;
    }

    public Optional<String> getTag() {
        return this.tag;
    }

    public Optional<Integer> getTtl() {
        return this.ttl;
    }

    public Optional<CachePolicy> getCachePolicy() {
        return this.cachePolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WNSPush that = (WNSPush)o;
        if (this.type != null ? !this.type.equals((Object)that.type) : that.type != null) {
            return false;
        }
        if (this.toast != null ? !this.toast.equals(that.toast) : that.toast != null) {
            return false;
        }
        if (this.tile != null ? !this.tile.equals(that.tile) : that.tile != null) {
            return false;
        }
        if (this.badge != null ? !this.badge.equals(that.badge) : that.badge != null) {
            return false;
        }
        if (this.tag != null ? !this.tag.equals(that.tag) : that.tag != null) {
            return false;
        }
        if (this.ttl != null ? !this.ttl.equals(that.ttl) : that.ttl != null) {
            return false;
        }
        return !(this.cachePolicy != null ? !this.cachePolicy.equals(that.cachePolicy) : that.cachePolicy != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.toast != null ? this.toast.hashCode() : 0);
        result = 31 * result + (this.tile != null ? this.tile.hashCode() : 0);
        result = 31 * result + (this.badge != null ? this.badge.hashCode() : 0);
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
        result = 31 * result + (this.cachePolicy != null ? this.cachePolicy.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private Type type;
        private WNSToastData toast;
        private WNSTileData tile;
        private WNSBadgeData badge;
        private String tag;
        private Integer ttl;
        private CachePolicy cachePolicy;

        private Builder() {
        }

        public Builder setType(Type value) {
            this.type = value;
            return this;
        }

        public Builder setToast(WNSToastData value) {
            this.toast = value;
            return this;
        }

        public Builder setTile(WNSTileData value) {
            this.tile = value;
            return this;
        }

        public Builder setBadge(WNSBadgeData value) {
            this.badge = value;
            return this;
        }

        public Builder setTag(String value) {
            this.tag = value;
            return this;
        }

        public Builder setTtl(Integer value) {
            this.ttl = value;
            return this;
        }

        public Builder setCachePolicy(CachePolicy value) {
            this.cachePolicy = value;
            return this;
        }

        public WNSPush build() {
            Preconditions.checkArgument((this.type != null && this.type != Type.RAW ? 1 : 0) != 0, (Object)"type must be one of 'toast', 'tile', or 'badge'");
            if (this.type == Type.TOAST) {
                Preconditions.checkArgument((this.toast != null ? 1 : 0) != 0, (Object)"Must supply a value for 'toast'");
            } else if (this.type == Type.TILE) {
                Preconditions.checkArgument((this.tile != null ? 1 : 0) != 0, (Object)"Must supply a value for 'tile'");
            } else if (this.type == Type.BADGE) {
                Preconditions.checkArgument((this.badge != null ? 1 : 0) != 0, (Object)"Must supply a value for 'badge'");
            }
            if (this.ttl != null && this.ttl < 1) {
                throw new IllegalArgumentException(String.format("TTL value must be a positive integer, not %d", (int)this.ttl));
            }
            return new WNSPush(this.type, Optional.fromNullable((Object)this.toast), Optional.fromNullable((Object)this.tile), Optional.fromNullable((Object)this.badge), Optional.fromNullable((Object)this.tag), Optional.fromNullable((Object)this.ttl), Optional.fromNullable((Object)((Object)this.cachePolicy)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CachePolicy {
        CACHE,
        NO_CACHE;

        private final String id = this.name().toLowerCase().replace('_', '-');

        public String getIdentifier() {
            return this.id;
        }

        public static CachePolicy get(String value) {
            for (CachePolicy policy : CachePolicy.values()) {
                if (!value.equalsIgnoreCase(policy.getIdentifier())) continue;
                return policy;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TOAST,
        TILE,
        BADGE,
        RAW;


        public String getIdentifier() {
            return this.name().toLowerCase();
        }

        public static Type get(String value) {
            for (Type type : Type.values()) {
                if (!value.equalsIgnoreCase(type.name())) continue;
                return type;
            }
            return null;
        }
    }
}

