/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.audience;

import com.urbanairship.api.push.model.audience.CompoundSelector;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.ValueSelector;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorSerializer
extends JsonSerializer<Selector> {
    public void serialize(Selector s, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (s instanceof ValueSelector) {
            ValueSelector vs = (ValueSelector)s;
            jgen.writeStartObject();
            jgen.writeStringField(vs.getType().getIdentifier(), vs.getValue());
            if (vs.getAttributes().isPresent()) {
                Map attributes = (Map)vs.getAttributes().get();
                for (String key : attributes.keySet()) {
                    jgen.writeStringField(key, (String)attributes.get(key));
                }
            }
            jgen.writeEndObject();
        } else if (s instanceof CompoundSelector) {
            CompoundSelector cs = (CompoundSelector)s;
            jgen.writeStartObject();
            jgen.writeArrayFieldStart(cs.getType().getIdentifier());
            for (Selector child : cs.getChildren()) {
                this.serialize(child, jgen, provider);
            }
            jgen.writeEndArray();
            jgen.writeEndObject();
        } else {
            jgen.writeString(s.getType().name());
        }
    }
}

