/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.PushPayload;
import com.urbanairship.api.schedule.model.Schedule;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulePayload
extends PushModelObject {
    private final Schedule schedule;
    private final Optional<String> name;
    private final PushPayload pushPayload;

    private SchedulePayload(Schedule schedule, String name, PushPayload pushPayload) {
        this.schedule = schedule;
        this.name = Optional.fromNullable((Object)name);
        this.pushPayload = pushPayload;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public PushPayload getPushPayload() {
        return this.pushPayload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulePayload schedulePayload = (SchedulePayload)o;
        if (this.schedule != null ? !this.schedule.equals(schedulePayload.schedule) : schedulePayload.schedule != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(schedulePayload.name) : schedulePayload.name != null) {
            return false;
        }
        return !(this.pushPayload != null ? !this.pushPayload.equals(schedulePayload.pushPayload) : schedulePayload.pushPayload != null);
    }

    public int hashCode() {
        int result = this.schedule != null ? this.schedule.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.pushPayload != null ? this.pushPayload.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SchedulePayload{schedule='" + this.schedule + '\'' + ", name='" + this.name + '\'' + ", pushPayload='" + this.pushPayload + '\'' + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Schedule schedule = null;
        private String name = null;
        private PushPayload pushPayload = null;

        private Builder() {
        }

        public Builder setSchedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPushPayload(PushPayload pushPayload) {
            this.pushPayload = pushPayload;
            return this;
        }

        public SchedulePayload build() {
            Preconditions.checkNotNull((Object)this.schedule, (Object)"'schedule' must be set");
            Preconditions.checkNotNull((Object)this.pushPayload, (Object)"'audience' must be set");
            if (this.name != null) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.name), (Object)"'name' must be a non-blank string");
            }
            return new SchedulePayload(this.schedule, this.name, this.pushPayload);
        }
    }
}

