/*
 * Copyright 2013 Urban Airship and Contributors
 */

package com.urbanairship.api.common.parse;

import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.module.SimpleModule;
import org.joda.time.DateTime;

public class CommonObjectMapper {

    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final SimpleModule MODULE = new SimpleModule("Common API Module",
                                                                new Version(1, 0, 0, null));
    static {
        MODULE
            .addSerializer(DateTime.class, new DateTimeSerializer());

        MAPPER.registerModule(MODULE);
        MAPPER.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    public static ObjectMapper getInstance() {
        return MAPPER;
    }

    private CommonObjectMapper() { }
}
