/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.client.AppsOpenReportAPIResponseHandler;
import com.urbanairship.api.client.AudienceSegmentAPIResponseHandler;
import com.urbanairship.api.client.ListAllChannelsAPIResponseHandler;
import com.urbanairship.api.client.ListAllSchedulesAPIResponseHandler;
import com.urbanairship.api.client.ListAllSegmentsAPIResponseHandler;
import com.urbanairship.api.client.ListAppStatsAPIResponseHandler;
import com.urbanairship.api.client.ListIndividualPushAPIResponseHandler;
import com.urbanairship.api.client.ListPerPushDetailAPIResponseHandler;
import com.urbanairship.api.client.ListPerPushSeriesResponseHandler;
import com.urbanairship.api.client.ListReportsListingResponseHandler;
import com.urbanairship.api.client.ListScheduleAPIResponseHandler;
import com.urbanairship.api.client.ListSingleChannelAPIResponseHandler;
import com.urbanairship.api.client.ListTagsAPIResponseHandler;
import com.urbanairship.api.client.LocationAPIResponseHandler;
import com.urbanairship.api.client.ProxyInfo;
import com.urbanairship.api.client.PushAPIResponseHandler;
import com.urbanairship.api.client.ScheduleAPIResponseHandler;
import com.urbanairship.api.client.StringAPIResponseHandler;
import com.urbanairship.api.client.TimeInAppReportAPIResponseHandler;
import com.urbanairship.api.client.model.APIClientResponse;
import com.urbanairship.api.client.model.APIListAllChannelsResponse;
import com.urbanairship.api.client.model.APIListAllSchedulesResponse;
import com.urbanairship.api.client.model.APIListAllSegmentsResponse;
import com.urbanairship.api.client.model.APIListSingleChannelResponse;
import com.urbanairship.api.client.model.APIListTagsResponse;
import com.urbanairship.api.client.model.APILocationResponse;
import com.urbanairship.api.client.model.APIPushResponse;
import com.urbanairship.api.client.model.APIReportsPushListingResponse;
import com.urbanairship.api.client.model.APIScheduleResponse;
import com.urbanairship.api.location.model.BoundedBox;
import com.urbanairship.api.location.model.Point;
import com.urbanairship.api.push.model.PushPayload;
import com.urbanairship.api.reports.model.AppStats;
import com.urbanairship.api.reports.model.PerPushDetailResponse;
import com.urbanairship.api.reports.model.PerPushSeriesResponse;
import com.urbanairship.api.reports.model.ReportsAPIOpensResponse;
import com.urbanairship.api.reports.model.ReportsAPITimeInAppResponse;
import com.urbanairship.api.reports.model.SinglePushInfoResponse;
import com.urbanairship.api.schedule.model.SchedulePayload;
import com.urbanairship.api.segments.model.AudienceSegment;
import com.urbanairship.api.tag.model.AddRemoveDeviceFromTagPayload;
import com.urbanairship.api.tag.model.BatchModificationPayload;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.params.BasicHttpParams;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIClient {
    private static final String HOURLY = "HOURLY";
    private static final String MONTHLY = "MONTHLY";
    private static final String DAILY = "DAILY";
    private static final String CONTENT_TYPE_KEY = "Content-type";
    private static final String ACCEPT_KEY = "Accept";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String UA_APPLICATION_JSON = "application/vnd.urbanairship+json;";
    private static final String API_PUSH_PATH = "/api/push/";
    private static final String API_VALIDATE_PATH = "/api/push/validate/";
    private static final String API_SCHEDULE_PATH = "/api/schedules/";
    private static final String API_TAGS_PATH = "/api/tags/";
    private static final String API_TAGS_BATCH_PATH = "/api/tags/batch/";
    private static final String API_LOCATION_PATH = "/api/location/";
    private static final String API_SEGMENTS_PATH = "/api/segments/";
    private static final String API_DEVICE_CHANNELS_PATH = "/api/channels/";
    private static final String API_STATISTICS_PATH = "/api/push/stats/";
    private static final String API_REPORTS_PER_PUSH_DETAIL_PATH = "/api/reports/perpush/detail/";
    private static final String API_REPORTS_PER_PUSH_SERIES_PATH = "/api/reports/perpush/series/";
    private static final String API_REPORTS_PUSH_RESPONSE_PATH = "/api/reports/responses/";
    private static final String API_REPORTS_APPS_OPEN_PATH = "/api/reports/opens/";
    private static final String API_REPORTS_TIME_IN_APP_PATH = "/api/reports/timeinapp/";
    private static final Logger logger = LoggerFactory.getLogger((String)"com.urbanairship.api");
    private final String appKey;
    private final String appSecret;
    private final URI baseURI;
    private final Number version;
    private final HttpHost uaHost;
    private final Optional<ProxyInfo> proxyInfo;
    private final Optional<BasicHttpParams> httpParams;

    private APIClient(String appKey, String appSecret, String baseURI, Number version, Optional<ProxyInfo> proxyInfoOptional, Optional<BasicHttpParams> httpParams) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)appKey), (Object)"App key must be provided.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)appSecret), (Object)"App secret must be provided");
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.baseURI = URI.create(baseURI);
        this.version = version;
        this.uaHost = new HttpHost(URI.create(baseURI).getHost(), 443, "https");
        this.proxyInfo = proxyInfoOptional;
        this.httpParams = httpParams;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<ProxyInfo> getProxyInfo() {
        return this.proxyInfo;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public Optional<BasicHttpParams> getHttpParams() {
        return this.httpParams;
    }

    private String versionedAcceptHeader(Number version) {
        return String.format("%s version=%s;", UA_APPLICATION_JSON, version.toString());
    }

    public String getUserAgent() {
        InputStream stream = this.getClass().getResourceAsStream("/client.properties");
        if (stream == null) {
            return "UNKNOWN";
        }
        Properties props = new Properties();
        try {
            props.load(stream);
            stream.close();
            return "UAJavaLib/" + props.get("client.version");
        }
        catch (IOException e) {
            return "UNKNOWN";
        }
    }

    private Request provisionRequest(Request object) {
        object.config("http.useragent", (Object)this.getUserAgent()).addHeader(CONTENT_TYPE_KEY, CONTENT_TYPE_JSON).addHeader(ACCEPT_KEY, this.versionedAcceptHeader(this.version));
        if (this.httpParams.isPresent()) {
            for (String name : ((BasicHttpParams)this.httpParams.get()).getNames()) {
                object.config(name, ((BasicHttpParams)this.httpParams.get()).getParameter(name));
            }
        }
        if (this.proxyInfo.isPresent()) {
            object.viaProxy(((ProxyInfo)this.proxyInfo.get()).getProxyHost());
        }
        return object;
    }

    private Executor provisionExecutor() {
        Executor executor = Executor.newInstance().auth(this.uaHost, this.appKey, this.appSecret).authPreemptive(this.uaHost);
        if (this.proxyInfo.isPresent()) {
            HttpHost host = ((ProxyInfo)this.proxyInfo.get()).getProxyHost();
            executor.authPreemptiveProxy(host);
            if (((ProxyInfo)this.proxyInfo.get()).getProxyCredentials().isPresent()) {
                executor.auth(host, (Credentials)((ProxyInfo)this.proxyInfo.get()).getProxyCredentials().get());
            }
        }
        return executor;
    }

    public static URI baseURIResolution(URI baseURI, String path) {
        if (!baseURI.getPath().endsWith("/")) {
            try {
                baseURI = new URI(baseURI.toString() + "/");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return baseURI.resolve(path);
    }

    public APIClientResponse<APIPushResponse> push(PushPayload payload) throws IOException {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload required when executing a push operation");
        Request request = this.provisionRequest(Request.Post((URI)APIClient.baseURIResolution(this.baseURI, API_PUSH_PATH)));
        request.bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing push request %s", request));
        }
        return (APIClientResponse)this.provisionExecutor().execute(request).handleResponse((ResponseHandler)new PushAPIResponseHandler());
    }

    public APIClientResponse<APIPushResponse> validate(PushPayload payload) throws IOException {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload required when executing a validate push operation");
        Request request = this.provisionRequest(Request.Post((URI)APIClient.baseURIResolution(this.baseURI, API_VALIDATE_PATH)));
        request.bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing validate push request %s", request));
        }
        return (APIClientResponse)this.provisionExecutor().execute(request).handleResponse((ResponseHandler)new PushAPIResponseHandler());
    }

    public APIClientResponse<APIScheduleResponse> schedule(SchedulePayload payload) throws IOException {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload required when scheduling a push request");
        Request request = this.provisionRequest(Request.Post((URI)APIClient.baseURIResolution(this.baseURI, API_SCHEDULE_PATH)));
        request.bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing schedule request %s", request));
        }
        return (APIClientResponse)this.provisionExecutor().execute(request).handleResponse((ResponseHandler)new ScheduleAPIResponseHandler());
    }

    public APIClientResponse<APIListAllSchedulesResponse> listAllSchedules() throws IOException {
        Request request = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, API_SCHEDULE_PATH)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list all schedules request %s", request));
        }
        return (APIClientResponse)this.provisionExecutor().execute(request).handleResponse((ResponseHandler)new ListAllSchedulesAPIResponseHandler());
    }

    public APIClientResponse<APIListAllSchedulesResponse> listAllSchedules(String start, int limit, String order) throws IOException {
        String path = "/api/schedules?start=" + start + "&limit=" + limit + "&order=" + order;
        Request request = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, path)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list all schedules request %s", request));
        }
        return (APIClientResponse)this.provisionExecutor().execute(request).handleResponse((ResponseHandler)new ListAllSchedulesAPIResponseHandler());
    }

    public APIClientResponse<APIListAllSchedulesResponse> listAllSchedules(String next_page) throws IOException, URISyntaxException {
        URI np = new URI(next_page);
        Request request = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, np.getPath() + "?" + np.getQuery())));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list all schedules request %s", request));
        }
        return (APIClientResponse)this.provisionExecutor().execute(request).handleResponse((ResponseHandler)new ListAllSchedulesAPIResponseHandler());
    }

    public APIClientResponse<SchedulePayload> listSchedule(String id) throws IOException {
        Request request = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, API_SCHEDULE_PATH + id)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list specific schedule request %s", request));
        }
        return (APIClientResponse)this.provisionExecutor().execute(request).handleResponse((ResponseHandler)new ListScheduleAPIResponseHandler());
    }

    public APIClientResponse<APIScheduleResponse> updateSchedule(SchedulePayload payload, String id) throws IOException {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload is required when updating schedule");
        Request req = this.provisionRequest(Request.Put((URI)APIClient.baseURIResolution(this.baseURI, API_SCHEDULE_PATH + id)));
        req.bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing update schedule request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ScheduleAPIResponseHandler());
    }

    public HttpResponse deleteSchedule(String id) throws IOException {
        Request req = this.provisionRequest(Request.Delete((URI)APIClient.baseURIResolution(this.baseURI, API_SCHEDULE_PATH + id)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing delete schedule request %s", req));
        }
        return this.provisionExecutor().execute(req).returnResponse();
    }

    public APIClientResponse<APIListTagsResponse> listTags() throws IOException {
        Request req = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, API_TAGS_PATH)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list tags request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListTagsAPIResponseHandler());
    }

    public HttpResponse createTag(String tag) throws IOException {
        Request req = this.provisionRequest(Request.Put((URI)APIClient.baseURIResolution(this.baseURI, API_TAGS_PATH + tag)));
        req.removeHeaders(CONTENT_TYPE_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing create tag request %s", req));
        }
        return this.provisionExecutor().execute(req).returnResponse();
    }

    public HttpResponse deleteTag(String tag) throws IOException {
        Request req = this.provisionRequest(Request.Delete((URI)APIClient.baseURIResolution(this.baseURI, API_TAGS_PATH + tag)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing delete tag request %s", req));
        }
        return this.provisionExecutor().execute(req).returnResponse();
    }

    public HttpResponse addRemoveDevicesFromTag(String tag, AddRemoveDeviceFromTagPayload payload) throws IOException {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload is required when adding and/or removing devices from a tag");
        Request req = this.provisionRequest(Request.Post((URI)APIClient.baseURIResolution(this.baseURI, API_TAGS_PATH + tag)));
        req.bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing add/remove devices from tag request %s", req));
        }
        return this.provisionExecutor().execute(req).returnResponse();
    }

    public HttpResponse batchModificationOfTags(BatchModificationPayload payload) throws IOException {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload is required when performing batch modification of tags");
        Request req = this.provisionRequest(Request.Post((URI)APIClient.baseURIResolution(this.baseURI, API_TAGS_BATCH_PATH)));
        req.bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing batch modification of tags request %s", req));
        }
        return this.provisionExecutor().execute(req).returnResponse();
    }

    public APIClientResponse<APILocationResponse> queryLocationInformation(String query) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)query), (Object)"Query text cannot be blank");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_LOCATION_PATH));
        builder.addParameter("q", query);
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        req.removeHeaders(ACCEPT_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing query location information without type request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new LocationAPIResponseHandler());
    }

    public APIClientResponse<APILocationResponse> queryLocationInformation(String query, String type) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)query), (Object)"Query text cannot be blank");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_LOCATION_PATH));
        builder.addParameter("q", query);
        builder.addParameter("type", type);
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        req.removeHeaders(ACCEPT_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing query location information without type request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new LocationAPIResponseHandler());
    }

    public APIClientResponse<APILocationResponse> queryLocationInformation(Point point) throws IOException {
        Preconditions.checkNotNull((Object)point, (Object)"Point must not be null");
        Preconditions.checkArgument((boolean)point.isValid(), (Object)"Point must be a valid coordinate");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_LOCATION_PATH + point.getLatitude() + "," + point.getLongitude()));
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        req.removeHeaders(ACCEPT_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing query location information without type request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new LocationAPIResponseHandler());
    }

    public APIClientResponse<APILocationResponse> queryLocationInformation(Point point, String type) throws IOException {
        Preconditions.checkNotNull((Object)point, (Object)"Point must not be null");
        Preconditions.checkArgument((boolean)point.isValid(), (Object)"Point must be a valid coordinate");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_LOCATION_PATH + point.getLatitude() + "," + point.getLongitude()));
        builder.addParameter("type", type);
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        req.removeHeaders(ACCEPT_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing query location information without type request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new LocationAPIResponseHandler());
    }

    public APIClientResponse<APILocationResponse> queryLocationInformation(BoundedBox box) throws IOException {
        Preconditions.checkNotNull((Object)box, (Object)"Box must not be null");
        Preconditions.checkArgument((boolean)box.isValid(), (Object)"Box must be a valid coordinate");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_LOCATION_PATH + box.getCornerOne().getLatitude() + "," + box.getCornerOne().getLongitude() + "," + box.getCornerTwo().getLatitude() + "," + box.getCornerTwo().getLongitude()));
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        req.removeHeaders(ACCEPT_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing query location information without type request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new LocationAPIResponseHandler());
    }

    public APIClientResponse<APILocationResponse> queryLocationInformation(BoundedBox box, String type) throws IOException {
        Preconditions.checkNotNull((Object)box, (Object)"Box must not be null");
        Preconditions.checkArgument((boolean)box.isValid(), (Object)"Box must be a valid coordinate");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_LOCATION_PATH + box.getCornerOne().getLatitude() + "," + box.getCornerOne().getLongitude() + "," + box.getCornerTwo().getLatitude() + "," + box.getCornerTwo().getLongitude()));
        builder.addParameter("type", type);
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        req.removeHeaders(ACCEPT_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing query location information without type request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new LocationAPIResponseHandler());
    }

    public APIClientResponse<APIListAllSegmentsResponse> listAllSegments() throws IOException {
        Request req = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, API_SEGMENTS_PATH)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list all segments request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListAllSegmentsAPIResponseHandler());
    }

    public APIClientResponse<APIListAllSegmentsResponse> listAllSegments(String nextPage) throws IOException, URISyntaxException {
        URI np = new URI(nextPage);
        Request req = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, np.getPath() + "?" + np.getQuery())));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list all segments request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListAllSegmentsAPIResponseHandler());
    }

    public APIClientResponse<APIListAllSegmentsResponse> listAllSegments(String start, int limit, String order) throws IOException {
        String path = "/api/segments?start=" + start + "&limit=" + limit + "&order=" + order;
        Request req = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, path)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list all segments request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListAllSegmentsAPIResponseHandler());
    }

    public APIClientResponse<AudienceSegment> listSegment(String segmentID) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)segmentID), (Object)"segmentID is required when listing segment");
        String path = API_SEGMENTS_PATH + segmentID;
        Request req = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, path)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list all segments request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new AudienceSegmentAPIResponseHandler());
    }

    public HttpResponse createSegment(AudienceSegment payload) throws IOException {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload is required when creating segment");
        Request req = this.provisionRequest(Request.Post((URI)APIClient.baseURIResolution(this.baseURI, API_SEGMENTS_PATH)));
        req.bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing create segment request %s", req));
        }
        return this.provisionExecutor().execute(req).returnResponse();
    }

    public HttpResponse changeSegment(String segmentID, AudienceSegment payload) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)segmentID), (Object)"segmentID is required when updating segment");
        Preconditions.checkNotNull((Object)payload, (Object)"Payload is required when updating segment");
        String path = API_SEGMENTS_PATH + segmentID;
        Request req = this.provisionRequest(Request.Put((URI)APIClient.baseURIResolution(this.baseURI, path)));
        req.bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing change segment request %s", req));
        }
        return this.provisionExecutor().execute(req).returnResponse();
    }

    public HttpResponse deleteSegment(String segmentID) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)segmentID), (Object)"segmentID is required when deleting segment");
        String path = API_SEGMENTS_PATH + segmentID;
        Request req = this.provisionRequest(Request.Delete((URI)APIClient.baseURIResolution(this.baseURI, path)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing delete segment request %s", req));
        }
        return this.provisionExecutor().execute(req).returnResponse();
    }

    public APIClientResponse<APIListSingleChannelResponse> listChannel(String channel) throws IOException {
        String path = API_DEVICE_CHANNELS_PATH + channel;
        Request req = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, path)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing get single channels request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListSingleChannelAPIResponseHandler());
    }

    public APIClientResponse<APIListAllChannelsResponse> listAllChannels() throws IOException {
        Request req = this.provisionRequest(Request.Get((URI)APIClient.baseURIResolution(this.baseURI, API_DEVICE_CHANNELS_PATH)));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list all channels request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListAllChannelsAPIResponseHandler());
    }

    public APIClientResponse<PerPushDetailResponse> listPerPushDetail(String pushID) throws IOException {
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_REPORTS_PER_PUSH_DETAIL_PATH + pushID));
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list per push detail request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListPerPushDetailAPIResponseHandler());
    }

    public APIClientResponse<PerPushSeriesResponse> listPerPushSeries(String pushID) throws IOException {
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_REPORTS_PER_PUSH_SERIES_PATH + pushID));
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list per push series request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListPerPushSeriesResponseHandler());
    }

    public APIClientResponse<PerPushSeriesResponse> listPerPushSeries(String pushID, String precision) throws IOException {
        Preconditions.checkArgument((HOURLY.equals(precision) || DAILY.equals(precision) || MONTHLY.equals(precision) ? 1 : 0) != 0, (Object)"Precision must be specified as HOURLY, DAILY or MONTHLY");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_REPORTS_PER_PUSH_SERIES_PATH + pushID));
        builder.addParameter("precision", precision.toUpperCase());
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list per push series with precision request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListPerPushSeriesResponseHandler());
    }

    public APIClientResponse<PerPushSeriesResponse> listPerPushSeries(String pushID, String precision, DateTime start, DateTime end) throws IOException {
        Preconditions.checkArgument((HOURLY.equals(precision) || DAILY.equals(precision) || MONTHLY.equals(precision) ? 1 : 0) != 0, (Object)"Precision must be specified as HOURLY, DAILY or MONTHLY");
        Preconditions.checkNotNull((Object)start, (Object)"Start time is required when performing listing of per push series");
        Preconditions.checkNotNull((Object)end, (Object)"End time is required when performing listing of per push series");
        Preconditions.checkArgument((boolean)start.isBefore((ReadableInstant)end), (Object)"Start time must be before End time");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_REPORTS_PER_PUSH_SERIES_PATH + pushID));
        builder.addParameter("precision", precision.toUpperCase());
        builder.addParameter("start", start.toLocalDateTime().toString());
        builder.addParameter("end", end.toLocalDateTime().toString());
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list per push series with precision and range request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListPerPushSeriesResponseHandler());
    }

    public APIClientResponse<SinglePushInfoResponse> listIndividualPushResponseStatistics(String id) throws IOException {
        Preconditions.checkNotNull((Object)id, (Object)"Push id is required when performing listing of individual push response statistics.");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_REPORTS_PUSH_RESPONSE_PATH + id));
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list Statistics in CSV String format request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListIndividualPushAPIResponseHandler());
    }

    public APIClientResponse<APIReportsPushListingResponse> listReportsResponseListing(DateTime start, DateTime end, Optional<Integer> limit, Optional<String> pushIDStart) throws IOException {
        Preconditions.checkNotNull((Object)start, (Object)"Start time is required when performing listing of push statistics");
        Preconditions.checkNotNull((Object)end, (Object)"End time is required when performing listing of push statistics");
        Preconditions.checkArgument((boolean)start.isBefore((ReadableInstant)end), (Object)"Start time must be before End time");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, "/api/reports/responses/list"));
        builder.addParameter("start", start.toLocalDateTime().toString());
        builder.addParameter("end", end.toLocalDateTime().toString());
        if (limit.isPresent()) {
            builder.addParameter("limit", ((Integer)limit.get()).toString());
        }
        if (pushIDStart.isPresent()) {
            builder.addParameter("push_id_start", (String)pushIDStart.get());
        }
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list Statistics in CSV String format request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListReportsListingResponseHandler());
    }

    public APIClientResponse<ReportsAPIOpensResponse> listAppsOpenReport(DateTime start, DateTime end, String precision) throws IOException {
        Preconditions.checkArgument((precision.toUpperCase().equals(HOURLY) || precision.toUpperCase().equals(DAILY) || precision.toUpperCase().equals(MONTHLY) ? 1 : 0) != 0, (Object)"Precision must be specified as HOURLY, DAILY or MONTHLY");
        Preconditions.checkNotNull((Object)start, (Object)"Start time is required when performing listing of apps open");
        Preconditions.checkNotNull((Object)end, (Object)"End time is required when performing listing of apps open");
        Preconditions.checkArgument((boolean)start.isBefore((ReadableInstant)end), (Object)"Start time must be before End time");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_REPORTS_APPS_OPEN_PATH));
        builder.addParameter("precision", precision.toUpperCase());
        builder.addParameter("start", start.toLocalDateTime().toString());
        builder.addParameter("end", end.toLocalDateTime().toString());
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list apps open report request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new AppsOpenReportAPIResponseHandler());
    }

    public APIClientResponse<ReportsAPITimeInAppResponse> listTimeInAppReport(DateTime start, DateTime end, String precision) throws IOException {
        Preconditions.checkArgument((precision.toUpperCase().equals(HOURLY) || precision.toUpperCase().equals(DAILY) || precision.toUpperCase().equals(MONTHLY) ? 1 : 0) != 0, (Object)"Precision must be specified as HOURLY, DAILY or MONTHLY");
        Preconditions.checkNotNull((Object)start, (Object)"Start time is required when performing listing of time in app");
        Preconditions.checkNotNull((Object)end, (Object)"End time is required when performing listing of time in app");
        Preconditions.checkArgument((boolean)start.isBefore((ReadableInstant)end), (Object)"Start time must be before End time");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_REPORTS_TIME_IN_APP_PATH));
        builder.addParameter("precision", precision.toUpperCase());
        builder.addParameter("start", start.toLocalDateTime().toString());
        builder.addParameter("end", end.toLocalDateTime().toString());
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list time in app report request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new TimeInAppReportAPIResponseHandler());
    }

    public APIClientResponse<List<AppStats>> listPushStatistics(DateTime start, DateTime end) throws IOException {
        Preconditions.checkNotNull((Object)start, (Object)"Start time is required when performing listing of push statistics");
        Preconditions.checkNotNull((Object)end, (Object)"End time is required when performing listing of push statistics");
        Preconditions.checkArgument((boolean)start.isBefore((ReadableInstant)end), (Object)"Start time must be before End time");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_STATISTICS_PATH));
        builder.addParameter("start", start.toLocalDateTime().toString());
        builder.addParameter("end", end.toLocalDateTime().toString());
        builder.addParameter("format", "json");
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        req.removeHeaders(ACCEPT_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list Statistics in CSV String format request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new ListAppStatsAPIResponseHandler());
    }

    public APIClientResponse<String> listPushStatisticsInCSVString(DateTime start, DateTime end) throws IOException {
        Preconditions.checkNotNull((Object)start, (Object)"Start time is required when performing listing of push statistics");
        Preconditions.checkNotNull((Object)end, (Object)"End time is required when performing listing of push statistics");
        Preconditions.checkArgument((boolean)start.isBefore((ReadableInstant)end), (Object)"Start time must be before End time");
        URIBuilder builder = new URIBuilder(APIClient.baseURIResolution(this.baseURI, API_STATISTICS_PATH));
        builder.addParameter("start", start.toLocalDateTime().toString());
        builder.addParameter("end", end.toLocalDateTime().toString());
        builder.addParameter("format", "csv");
        Request req = this.provisionRequest(Request.Get((String)builder.toString()));
        req.removeHeaders(ACCEPT_KEY);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Executing list Statistics in CSV String format request %s", req));
        }
        return (APIClientResponse)this.provisionExecutor().execute(req).handleResponse((ResponseHandler)new StringAPIResponseHandler());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.appKey, this.appSecret, this.baseURI, this.version, this.uaHost, this.proxyInfo, this.httpParams});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        APIClient other = (APIClient)obj;
        return Objects.equal((Object)this.appKey, (Object)other.appKey) && Objects.equal((Object)this.appSecret, (Object)other.appSecret) && Objects.equal((Object)this.baseURI, (Object)other.baseURI) && Objects.equal((Object)this.version, (Object)other.version) && Objects.equal((Object)this.uaHost, (Object)other.uaHost) && Objects.equal(this.proxyInfo, other.proxyInfo) && Objects.equal(this.httpParams, other.httpParams);
    }

    public String toString() {
        return "APIClient{ +appKey=" + this.appKey + ", appSecret=" + this.appSecret + ", baseURI=" + this.baseURI + ", version=" + this.version + ", uaHost=" + this.uaHost + ", proxyInfo=" + this.proxyInfo + ", httpParams=" + this.httpParams + '}';
    }

    public static class Builder {
        private String key;
        private String secret;
        private String baseURI = "https://go.urbanairship.com";
        private Number version = 3;
        private ProxyInfo proxyInfoOptional;
        private BasicHttpParams httpParams;

        private Builder() {
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setSecret(String appSecret) {
            this.secret = appSecret;
            return this;
        }

        public Builder setBaseURI(String URI2) {
            this.baseURI = URI2;
            return this;
        }

        public Builder setVersion(Number version) {
            this.version = version;
            return this;
        }

        public Builder setProxyInfo(ProxyInfo value) {
            this.proxyInfoOptional = value;
            return this;
        }

        public Builder setHttpParams(BasicHttpParams httpParams) {
            this.httpParams = httpParams;
            return this;
        }

        public APIClient build() {
            Preconditions.checkNotNull((Object)this.key, (Object)"app key needed to build APIClient");
            Preconditions.checkNotNull((Object)this.secret, (Object)"app secret needed to build APIClient");
            Preconditions.checkNotNull((Object)this.baseURI, (Object)"base URI needed to build APIClient");
            Preconditions.checkNotNull((Object)this.version, (Object)"version needed to build APIClient");
            return new APIClient(this.key, this.secret, this.baseURI, this.version, Optional.fromNullable((Object)this.proxyInfoOptional), Optional.fromNullable((Object)this.httpParams));
        }
    }
}

