/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.APIRequestException;
import com.urbanairship.api.client.model.APIClientResponse;
import com.urbanairship.api.client.parse.APIResponseObjectMapper;
import com.urbanairship.api.schedule.model.SchedulePayload;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListScheduleAPIResponseHandler
implements ResponseHandler<APIClientResponse<SchedulePayload>> {
    private static final ObjectMapper mapper = APIResponseObjectMapper.getInstance();
    private static final APIClientResponse.Builder<SchedulePayload> builder = APIClientResponse.newSchedulePayloadBuilder();

    public APIClientResponse<SchedulePayload> handleResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return this.handleSuccessfulSchedule(response);
        }
        throw APIRequestException.exceptionForResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIClientResponse<SchedulePayload> handleSuccessfulSchedule(HttpResponse response) throws IOException {
        builder.setHttpResponse(response);
        try {
            String jsonPayload = EntityUtils.toString((HttpEntity)response.getEntity());
            SchedulePayload scheduleResponse = (SchedulePayload)mapper.readValue(jsonPayload, SchedulePayload.class);
            builder.setApiResponse(scheduleResponse);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        return builder.build();
    }
}

