/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.APIRequestException;
import com.urbanairship.api.client.model.APIClientResponse;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringAPIResponseHandler
implements ResponseHandler<APIClientResponse<String>> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.urbanairship.api");
    private static final APIClientResponse.Builder<String> builder = APIClientResponse.newStringResponseBuilder();

    public APIClientResponse<String> handleResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 202: {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Handling response code:%s", statusCode));
                }
                return this.handleSuccessfulRequest(response);
            }
            case 400: 
            case 401: 
            case 406: {
                throw APIRequestException.exceptionForResponse(response);
            }
        }
        if (statusCode >= 200 && statusCode < 300) {
            return this.handleSuccessfulRequest(response);
        }
        throw APIRequestException.exceptionForResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIClientResponse<String> handleSuccessfulRequest(HttpResponse response) throws IOException {
        builder.setHttpResponse(response);
        try {
            String payload = EntityUtils.toString((HttpEntity)response.getEntity());
            builder.setApiResponse(payload);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        return builder.build();
    }
}

