/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.APIRequestException;
import com.urbanairship.api.client.model.APIClientResponse;
import com.urbanairship.api.client.parse.APIResponseObjectMapper;
import com.urbanairship.api.reports.model.ReportsAPITimeInAppResponse;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeInAppReportAPIResponseHandler
implements ResponseHandler<APIClientResponse<ReportsAPITimeInAppResponse>> {
    private static final ObjectMapper mapper = APIResponseObjectMapper.getInstance();
    private static final APIClientResponse.Builder<ReportsAPITimeInAppResponse> builder = APIClientResponse.newTimeInAppReportResponseBuilder();

    public APIClientResponse<ReportsAPITimeInAppResponse> handleResponse(HttpResponse httpResponse) throws IOException {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return this.handleSuccessfulResponse(httpResponse);
        }
        throw APIRequestException.exceptionForResponse(httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIClientResponse<ReportsAPITimeInAppResponse> handleSuccessfulResponse(HttpResponse response) throws IOException {
        builder.setHttpResponse(response);
        try {
            String jsonPayload = EntityUtils.toString((HttpEntity)response.getEntity());
            ReportsAPITimeInAppResponse apiresponse = (ReportsAPITimeInAppResponse)mapper.readValue(jsonPayload, ReportsAPITimeInAppResponse.class);
            builder.setApiResponse(apiresponse);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        return builder.build();
    }
}

