/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.channel.information.model.ChannelView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APIListAllChannelsResponse {
    private final boolean ok;
    private final Optional<String> nextPage;
    private final ImmutableList<ChannelView> channelObjects;

    private APIListAllChannelsResponse(boolean ok, String nextPage, ImmutableList<ChannelView> channelObjects) {
        this.ok = ok;
        this.nextPage = Optional.fromNullable((Object)nextPage);
        this.channelObjects = channelObjects;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getNextPage() {
        return this.nextPage;
    }

    public ImmutableList<ChannelView> getChannelObjects() {
        return this.channelObjects;
    }

    public String toString() {
        return "APIListAllChannelsResponse{ok=" + this.ok + ", nextPage='" + this.nextPage + '\'' + ", channelObjects=" + this.channelObjects + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.nextPage, this.channelObjects});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        APIListAllChannelsResponse other = (APIListAllChannelsResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.nextPage, other.nextPage) && Objects.equal(this.channelObjects, other.channelObjects);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private boolean ok;
        private String nextPage;
        private ImmutableList.Builder<ChannelView> channelObjects = ImmutableList.builder();

        private Builder() {
        }

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setNextPage(String value) {
            this.nextPage = value;
            return this;
        }

        public Builder addChannel(ChannelView value) {
            this.channelObjects.add((Object)value);
            return this;
        }

        public Builder addAllChannels(Iterable<? extends ChannelView> value) {
            this.channelObjects.addAll(value);
            return this;
        }

        public APIListAllChannelsResponse build() {
            return new APIListAllChannelsResponse(this.ok, this.nextPage, this.channelObjects.build());
        }
    }
}

