/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.location.parse;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.location.model.Location;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationReader
implements JsonObjectReader<Location> {
    private final Location.Builder builder = Location.newBuilder();

    public void readBounds(JsonParser jsonParser) throws IOException {
        this.builder.setBounds((List)jsonParser.readValueAs((TypeReference)new TypeReference<List<Double>>(){}));
    }

    public void readCentroid(JsonParser jsonParser) throws IOException {
        this.builder.setCentroid((List)jsonParser.readValueAs((TypeReference)new TypeReference<List<Double>>(){}));
    }

    public void readId(JsonParser jsonParser) throws IOException {
        this.builder.setLocationId((String)jsonParser.readValueAs(String.class));
    }

    public void readPropertyJSONNode(JsonParser jsonParser) throws IOException {
        JsonNode jsonNode = jsonParser.readValueAsTree();
        this.builder.setPropertiesNode(jsonNode);
    }

    public void readType(JsonParser jsonParser) throws IOException {
        this.builder.setLocationType((String)jsonParser.readValueAs(String.class));
    }

    @Override
    public Location validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), (Throwable)e);
        }
    }
}

