/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.notification.actions.Actions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interactive {
    private final String type;
    private final ImmutableMap<String, Actions> buttonActions;

    private Interactive(String type, ImmutableMap<String, Actions> buttonActions) {
        this.type = type;
        this.buttonActions = buttonActions;
    }

    public String getType() {
        return this.type;
    }

    public ImmutableMap<String, Actions> getButtonActions() {
        return this.buttonActions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interactive that = (Interactive)o;
        return Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.buttonActions, that.buttonActions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.buttonActions});
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("type", (Object)this.type).add("buttonActions", this.buttonActions).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String type = null;
        private ImmutableMap<String, Actions> buttonActions = null;

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setButtonActions(ImmutableMap<String, Actions> buttonActions) {
            this.buttonActions = buttonActions;
            return this;
        }

        public Interactive build() {
            Preconditions.checkNotNull((Object)this.type, (Object)"interactive payload requires a 'type' field");
            if (this.buttonActions == null) {
                this.buttonActions = ImmutableMap.of();
            }
            return new Interactive(this.type, this.buttonActions);
        }
    }
}

